/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.problems.AdditionalData;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.FileLocation;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemLocation;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.AdditionalDataBuilder;
import org.gradle.api.problems.internal.AdditionalDataBuilderFactory;
import org.gradle.api.problems.internal.AdditionalDataSpec;
import org.gradle.api.problems.internal.DefaultDocLink;
import org.gradle.api.problems.internal.DefaultFileLocation;
import org.gradle.api.problems.internal.DefaultLineInFileLocation;
import org.gradle.api.problems.internal.DefaultOffsetInFileLocation;
import org.gradle.api.problems.internal.DefaultPluginIdLocation;
import org.gradle.api.problems.internal.DefaultProblem;
import org.gradle.api.problems.internal.DefaultProblemDefinition;
import org.gradle.api.problems.internal.DefaultProblemId;
import org.gradle.api.problems.internal.DefaultTaskPathLocation;
import org.gradle.api.problems.internal.DefaultTypedAdditionalData;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemBuilder;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.problems.Location;
import org.gradle.problems.ProblemDiagnostics;
import org.gradle.problems.buildtree.ProblemStream;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class DefaultProblemBuilder
implements InternalProblemBuilder {
    @Nullable
    private ProblemStream problemStream;
    private ProblemId id;
    private String contextualLabel;
    private Severity severity;
    private final List<ProblemLocation> locations = new ArrayList<ProblemLocation>();
    private final List<ProblemLocation> contextLocations = new ArrayList<ProblemLocation>();
    private String details;
    private DocLink docLink;
    private List<String> solutions;
    private Throwable exception;
    private AdditionalData additionalData;
    private boolean collectLocation = false;
    private final AdditionalDataBuilderFactory additionalDataBuilderFactory;
    private final Instantiator instantiator;
    private final PayloadSerializer payloadSerializer;
    public static final Set<Class<?>> TYPES = ImmutableSet.of(String.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, (Object[])new Class[]{Float.class, Long.class, Double.class, BigInteger.class, BigDecimal.class, File.class});

    public DefaultProblemBuilder(AdditionalDataBuilderFactory additionalDataBuilderFactory, Instantiator instantiator, PayloadSerializer payloadSerializer) {
        this.additionalDataBuilderFactory = additionalDataBuilderFactory;
        this.instantiator = instantiator;
        this.payloadSerializer = payloadSerializer;
        this.additionalData = null;
        this.solutions = new ArrayList<String>();
    }

    public DefaultProblemBuilder(@Nullable ProblemStream problemStream, AdditionalDataBuilderFactory additionalDataBuilderFactory, Instantiator instantiator, PayloadSerializer payloadSerializer) {
        this(additionalDataBuilderFactory, instantiator, payloadSerializer);
        this.problemStream = problemStream;
    }

    public DefaultProblemBuilder(InternalProblem problem, AdditionalDataBuilderFactory additionalDataBuilderFactory, Instantiator instantiator, PayloadSerializer payloadSerializer) {
        this(additionalDataBuilderFactory, instantiator, payloadSerializer);
        this.id = problem.getDefinition().getId();
        this.contextualLabel = problem.getContextualLabel();
        this.solutions = new ArrayList<String>(problem.getSolutions());
        this.severity = problem.getDefinition().getSeverity();
        this.locations.addAll(problem.getOriginLocations());
        this.contextLocations.addAll(problem.getContextualLocations());
        this.details = problem.getDetails();
        this.docLink = problem.getDefinition().getDocumentationLink();
        this.exception = problem.getException();
        this.additionalData = problem.getAdditionalData();
        this.problemStream = null;
    }

    @Override
    public InternalProblem build() {
        if (this.getId() == null) {
            return this.invalidProblem("missing-id", "Problem id must be specified", null);
        }
        if (this.getId().getGroup() == null) {
            return this.invalidProblem("missing-parent", "Problem id must have a parent", null);
        }
        if (this.additionalData instanceof UnsupportedAdditionalDataSpec) {
            return this.invalidProblem("unsupported-additional-data", "Unsupported additional data type", "Unsupported additional data type: " + ((UnsupportedAdditionalDataSpec)this.additionalData).getType().getName() + ". Supported types are: " + this.getAdditionalDataBuilderFactory().getSupportedTypes());
        }
        Throwable exceptionForProblemInstantiation = this.getExceptionForProblemInstantiation();
        if (this.problemStream != null) {
            this.addLocationsFromProblemStream(this.locations, exceptionForProblemInstantiation);
        }
        DefaultProblemDefinition problemDefinition = new DefaultProblemDefinition(this.getId(), this.getSeverity(), this.docLink);
        return new DefaultProblem(problemDefinition, this.contextualLabel, this.solutions, this.locations, this.contextLocations, this.details, exceptionForProblemInstantiation, this.additionalData);
    }

    private void addLocationsFromProblemStream(List<ProblemLocation> locations, Throwable exceptionForProblemInstantiation) {
        assert (this.problemStream != null);
        ProblemDiagnostics problemDiagnostics = this.problemStream.forCurrentCaller(exceptionForProblemInstantiation);
        Location loc = problemDiagnostics.getLocation();
        if (loc != null) {
            this.addFileLocationTo(locations, DefaultProblemBuilder.getFileLocation(loc));
        }
        if (problemDiagnostics.getSource() != null && problemDiagnostics.getSource().getPluginId() != null) {
            locations.add(DefaultProblemBuilder.getDefaultPluginIdLocation(problemDiagnostics));
        }
    }

    private static DefaultPluginIdLocation getDefaultPluginIdLocation(ProblemDiagnostics problemDiagnostics) {
        assert (problemDiagnostics.getSource() != null);
        return new DefaultPluginIdLocation(problemDiagnostics.getSource().getPluginId());
    }

    private static FileLocation getFileLocation(Location loc) {
        String path = loc.getSourceLongDisplayName().getDisplayName();
        int line = loc.getLineNumber();
        return DefaultLineInFileLocation.from(path, line);
    }

    private InternalProblem invalidProblem(String id, String displayName, @Nullable String contextualLabel) {
        this.id(id, displayName, ProblemGroup.create("problems-api", "Problems API")).stackLocation();
        DefaultProblemDefinition problemDefinition = new DefaultProblemDefinition(this.getId(), Severity.WARNING, null);
        Throwable exceptionForProblemInstantiation = this.getExceptionForProblemInstantiation();
        ArrayList<ProblemLocation> problemLocations = new ArrayList<ProblemLocation>();
        this.addLocationsFromProblemStream(problemLocations, exceptionForProblemInstantiation);
        return new DefaultProblem(problemDefinition, contextualLabel, (List<String>)ImmutableList.of(), problemLocations, (List<ProblemLocation>)ImmutableList.of(), null, exceptionForProblemInstantiation, null);
    }

    public Throwable getExceptionForProblemInstantiation() {
        return this.getException() == null && this.collectLocation ? new RuntimeException() : this.getException();
    }

    protected Severity getSeverity() {
        if (this.severity == null) {
            return Severity.WARNING;
        }
        return this.severity;
    }

    @Override
    public InternalProblemBuilder contextualLabel(String contextualLabel) {
        this.contextualLabel = contextualLabel;
        return this;
    }

    @Override
    public InternalProblemBuilder severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public InternalProblemBuilder taskPathLocation(String buildTreePath) {
        this.contextLocations.add(new DefaultTaskPathLocation(buildTreePath));
        return this;
    }

    @Override
    public InternalProblemBuilder fileLocation(String path) {
        this.addFileLocation(DefaultFileLocation.from(path));
        return this;
    }

    @Override
    public InternalProblemBuilder lineInFileLocation(String path, int line) {
        return this.addFileLocation(DefaultLineInFileLocation.from(path, line));
    }

    @Nonnull
    private DefaultProblemBuilder addFileLocation(FileLocation from) {
        return this.addFileLocationTo(this.locations, from);
    }

    @Nonnull
    private DefaultProblemBuilder addFileLocationTo(List<ProblemLocation> problemLocations, FileLocation from) {
        if (problemLocations.contains(from)) {
            return this;
        }
        problemLocations.add(from);
        return this;
    }

    @Override
    public InternalProblemBuilder lineInFileLocation(String path, int line, int column) {
        this.addFileLocation(DefaultLineInFileLocation.from(path, line, column));
        return this;
    }

    @Override
    public InternalProblemBuilder offsetInFileLocation(String path, int offset, int length) {
        this.addFileLocation(DefaultOffsetInFileLocation.from(path, offset, length));
        return this;
    }

    @Override
    public InternalProblemBuilder lineInFileLocation(String path, int line, int column, int length) {
        this.addFileLocation(DefaultLineInFileLocation.from(path, line, column, length));
        return this;
    }

    @Override
    public InternalProblemBuilder stackLocation() {
        this.collectLocation = true;
        return this;
    }

    @Override
    public InternalProblemBuilder details(String details) {
        this.details = details;
        return this;
    }

    @Override
    public InternalProblemBuilder documentedAt(@Nullable DocLink doc) {
        this.docLink = doc;
        return this;
    }

    @Override
    public InternalProblemBuilder id(ProblemId problemId) {
        this.id = problemId instanceof DefaultProblemId ? problemId : DefaultProblemBuilder.cloneId(problemId);
        return this;
    }

    @Override
    public InternalProblemBuilder id(String name, String displayName, ProblemGroup parent) {
        this.id = ProblemId.create(name, displayName, DefaultProblemBuilder.cloneGroup(parent));
        return this;
    }

    private static ProblemId cloneId(ProblemId original) {
        return ProblemId.create(original.getName(), original.getDisplayName(), DefaultProblemBuilder.cloneGroup(original.getGroup()));
    }

    private static ProblemGroup cloneGroup(ProblemGroup original) {
        return ProblemGroup.create(original.getName(), original.getDisplayName(), original.getParent() == null ? null : DefaultProblemBuilder.cloneGroup(original.getParent()));
    }

    @Override
    public InternalProblemBuilder documentedAt(@Nullable String url) {
        this.docLink = url == null ? null : new DefaultDocLink(url);
        return this;
    }

    @Override
    public InternalProblemBuilder solution(@Nullable String solution) {
        if (this.solutions == null) {
            this.solutions = new ArrayList<String>();
        }
        this.solutions.add(solution);
        return this;
    }

    @Override
    public <U extends AdditionalDataSpec> InternalProblemBuilder additionalDataInternal(Class<? extends U> specType, Action<? super U> config) {
        if (this.getAdditionalDataBuilderFactory().hasProviderForSpec(specType)) {
            AdditionalDataBuilder<AdditionalData> additionalDataBuilder = this.getAdditionalDataBuilderFactory().createAdditionalDataBuilder(specType, this.additionalData);
            config.execute((Object)((AdditionalDataSpec)((Object)additionalDataBuilder)));
            this.additionalData = additionalDataBuilder.build();
        } else {
            this.additionalData = new UnsupportedAdditionalDataSpec(specType);
        }
        return this;
    }

    @Override
    public <T extends AdditionalData> InternalProblemBuilder additionalData(Class<T> type, Action<? super T> config) {
        DefaultProblemBuilder.validateMethods(type);
        AdditionalData additionalDataInstance = this.createAdditionalData(type, config);
        Map<String, Object> methodValues = DefaultProblemBuilder.getAdditionalDataMap(type, additionalDataInstance);
        SerializedPayload payload = this.getPayloadSerializer().serialize(type);
        this.additionalData = new DefaultTypedAdditionalData(methodValues, payload);
        return this;
    }

    @Nonnull
    private static <T extends AdditionalData> Map<String, Object> getAdditionalDataMap(Class<T> type, AdditionalData additionalDataInstance) {
        HashMap<String, Object> methodValues = new HashMap<String, Object>();
        for (Method method : type.getMethods()) {
            Class<?> returnType = method.getReturnType();
            if (Void.TYPE.equals(returnType) || method.getParameterCount() != 0) continue;
            try {
                methodValues.put(method.getName(), additionalDataInstance.getClass().getMethod(method.getName(), method.getParameterTypes()).invoke((Object)additionalDataInstance, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        return methodValues;
    }

    @Nonnull
    private <T extends AdditionalData> AdditionalData createAdditionalData(Class<T> type, Action<? super T> config) {
        AdditionalData additionalDataInstance = (AdditionalData)this.getInstantiator().newInstance(type, new Object[0]);
        config.execute((Object)additionalDataInstance);
        return additionalDataInstance;
    }

    @Override
    public <T extends AdditionalData> InternalProblemBuilder additionalDataInternal(T additionalDataInstance) {
        this.additionalData = additionalDataInstance;
        return this;
    }

    static <T extends AdditionalData> void validateMethods(Class<T> type) {
        Method[] methods;
        for (Method method : methods = type.getMethods()) {
            String name = method.getName();
            if (DefaultProblemBuilder.isValidGetter(method, name) || DefaultProblemBuilder.isValidSetter(method, name)) continue;
            throw new IllegalArgumentException(DefaultProblemBuilder.getExceptionMessage(type));
        }
    }

    private static String getExceptionMessage(Class<? extends AdditionalData> invalidType) {
        StringBuilder sb = new StringBuilder(invalidType.getSimpleName()).append(" must have only getters or setters using the following types: ");
        int size = TYPES.size();
        int index = 0;
        for (Class<?> type : TYPES) {
            sb.append(type.getSimpleName());
            if (++index < size - 1) {
                sb.append(", ");
                continue;
            }
            if (index != size - 1) continue;
            sb.append(", or ");
        }
        sb.append(".");
        return sb.toString();
    }

    private static boolean isValidSetter(Method method, String name) {
        return name.startsWith("set") && method.getParameterCount() == 1 && TYPES.contains(method.getParameterTypes()[0]);
    }

    private static boolean isValidGetter(Method method, String name) {
        return name.startsWith("get") && method.getParameterCount() == 0 && TYPES.contains(method.getReturnType());
    }

    @Override
    public InternalProblemBuilder withException(Throwable t) {
        this.exception = t;
        return this;
    }

    @Nullable
    Throwable getException() {
        return this.exception;
    }

    public ProblemId getId() {
        return this.id;
    }

    @Override
    public AdditionalDataBuilderFactory getAdditionalDataBuilderFactory() {
        return this.additionalDataBuilderFactory;
    }

    @Override
    public Instantiator getInstantiator() {
        return this.instantiator;
    }

    @Override
    public PayloadSerializer getPayloadSerializer() {
        return this.payloadSerializer;
    }

    private static class UnsupportedAdditionalDataSpec
    implements AdditionalData {
        private final Class<?> type;

        UnsupportedAdditionalDataSpec(Class<?> type) {
            this.type = type;
        }

        public Class<?> getType() {
            return this.type;
        }
    }
}

