/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.OutputStream;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.internal.daemon.client.execution.ClientBuildRequestContext;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.io.NullOutputStream;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.ProgressCompleteEvent;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.launcher.exec.BuildActionExecutor;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;
import org.gradle.tooling.internal.provider.ConnectionOperationParameters;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;

public class LoggingBridgingBuildActionExecuter
implements BuildActionExecutor<ConnectionOperationParameters, ClientBuildRequestContext> {
    private final LoggingManagerInternal loggingManager;
    private final BuildActionExecutor<ConnectionOperationParameters, ClientBuildRequestContext> delegate;

    public LoggingBridgingBuildActionExecuter(BuildActionExecutor<ConnectionOperationParameters, ClientBuildRequestContext> delegate, LoggingManagerInternal loggingManager) {
        this.delegate = delegate;
        this.loggingManager = loggingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildActionResult execute(BuildAction action, ConnectionOperationParameters parameters, ClientBuildRequestContext buildRequestContext) {
        ProviderOperationParameters actionParameters = parameters.getOperationParameters();
        this.attachConsole(actionParameters);
        ProgressListenerVersion1 progressListener = actionParameters.getProgressListener();
        OutputEventListenerAdapter listener = new OutputEventListenerAdapter(progressListener);
        this.loggingManager.addOutputEventListener((OutputEventListener)listener);
        this.loggingManager.setLevelInternal(actionParameters.getBuildLogLevel());
        this.loggingManager.start();
        try {
            BuildActionResult buildActionResult = this.delegate.execute(action, (Object)parameters, (Object)buildRequestContext);
            return buildActionResult;
        }
        finally {
            this.loggingManager.stop();
        }
    }

    private void attachConsole(ProviderOperationParameters actionParameters) {
        OutputStream stdOut = actionParameters.getStandardOutput();
        OutputStream stdErr = actionParameters.getStandardError();
        if (Boolean.TRUE.equals(actionParameters.isColorOutput()) && stdOut != null) {
            this.loggingManager.attachConsole(stdOut, this.notNull(stdErr), ConsoleOutput.Rich);
        } else if (stdOut != null || stdErr != null) {
            this.loggingManager.attachConsole(this.notNull(stdOut), this.notNull(stdErr), ConsoleOutput.Plain);
        }
    }

    private OutputStream notNull(OutputStream outputStream) {
        if (outputStream == null) {
            return NullOutputStream.INSTANCE;
        }
        return outputStream;
    }

    private static class OutputEventListenerAdapter
    implements OutputEventListener {
        private final ProgressListenerVersion1 progressListener;

        public OutputEventListenerAdapter(ProgressListenerVersion1 progressListener) {
            this.progressListener = progressListener;
        }

        public void onOutput(OutputEvent event) {
            if (event instanceof ProgressStartEvent) {
                ProgressStartEvent startEvent = (ProgressStartEvent)event;
                this.progressListener.onOperationStart(startEvent.getDescription());
            } else if (event instanceof ProgressCompleteEvent) {
                this.progressListener.onOperationEnd();
            }
        }
    }
}

