/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.serialize;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.initialization.ClassLoaderScopeOrigin;
import org.gradle.internal.cc.base.exceptions.ConfigurationCacheError;
import org.gradle.internal.cc.impl.serialize.ClassLoaderScopeSpec;
import org.gradle.internal.cc.impl.serialize.ClassLoadingKt;
import org.gradle.internal.cc.impl.serialize.ClassPathEncodingExtensionsKt;
import org.gradle.internal.cc.impl.serialize.DefaultClassEncoderKt;
import org.gradle.internal.cc.impl.serialize.ScopeLookup;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.graph.ClassEncoder;
import org.gradle.internal.serialize.graph.ClassLoaderRole;
import org.gradle.internal.serialize.graph.WriteIdentities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t*\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\t*\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0016J\u0016\u0010\u0014\u001a\u00020\u0015*\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u0010\u0016\u001a\u00020\t*\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\t*\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gradle/internal/cc/impl/serialize/DefaultClassEncoder;", "Lorg/gradle/internal/serialize/graph/ClassEncoder;", "scopeLookup", "Lorg/gradle/internal/cc/impl/serialize/ScopeLookup;", "(Lorg/gradle/internal/cc/impl/serialize/ScopeLookup;)V", "classes", "Lorg/gradle/internal/serialize/graph/WriteIdentities;", "scopes", "ensureClassCanBeFoundInGradleRuntimeClassLoader", "", "className", "", "originalClassLoader", "Ljava/lang/ClassLoader;", "encodeClass", "Lorg/gradle/internal/serialize/Encoder;", "type", "Ljava/lang/Class;", "encodeClassLoader", "classLoader", "writeClassLoaderScopeOf", "", "writeHashCode", "hashCode", "Lorg/gradle/internal/hash/HashCode;", "writeScope", "scope", "Lorg/gradle/internal/cc/impl/serialize/ClassLoaderScopeSpec;", "configuration-cache"})
@SourceDebugExtension(value={"SMAP\nDefaultClassEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultClassEncoder.kt\norg/gradle/internal/cc/impl/serialize/DefaultClassEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1#2:162\n*E\n"})
public final class DefaultClassEncoder
implements ClassEncoder {
    @NotNull
    private final ScopeLookup scopeLookup;
    @NotNull
    private final WriteIdentities classes;
    @NotNull
    private final WriteIdentities scopes;

    public DefaultClassEncoder(@NotNull ScopeLookup scopeLookup) {
        Intrinsics.checkNotNullParameter((Object)scopeLookup, (String)"scopeLookup");
        this.scopeLookup = scopeLookup;
        this.classes = new WriteIdentities();
        this.scopes = new WriteIdentities();
    }

    public void encodeClass(@NotNull Encoder $this$encodeClass, @NotNull Class<?> type) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeClass, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Integer id2 = this.classes.getId(type);
        if (id2 != null) {
            $this$encodeClass.writeSmallInt(id2.intValue());
        } else {
            int newId = this.classes.putInstance(type);
            $this$encodeClass.writeSmallInt(newId);
            String className = type.getName();
            $this$encodeClass.writeString((CharSequence)className);
            ClassLoader classLoader = type.getClassLoader();
            if (!this.writeClassLoaderScopeOf($this$encodeClass, classLoader) && classLoader != null) {
                Intrinsics.checkNotNullExpressionValue((Object)className, (String)"className");
                this.ensureClassCanBeFoundInGradleRuntimeClassLoader(className, classLoader);
            }
        }
    }

    public void encodeClassLoader(@NotNull Encoder $this$encodeClassLoader, @Nullable ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeClassLoader, (String)"<this>");
        this.writeClassLoaderScopeOf($this$encodeClassLoader, classLoader);
    }

    private final boolean writeClassLoaderScopeOf(Encoder $this$writeClassLoaderScopeOf, ClassLoader classLoader) {
        Pair<ClassLoaderScopeSpec, ClassLoaderRole> scope;
        Pair<ClassLoaderScopeSpec, ClassLoaderRole> pair;
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 != null) {
            ClassLoader it2 = classLoader2;
            boolean bl = false;
            pair = this.scopeLookup.scopeFor(it2);
        } else {
            pair = scope = null;
        }
        if (scope == null) {
            $this$writeClassLoaderScopeOf.writeBoolean(false);
            return false;
        }
        $this$writeClassLoaderScopeOf.writeBoolean(true);
        this.writeScope($this$writeClassLoaderScopeOf, (ClassLoaderScopeSpec)scope.getFirst());
        $this$writeClassLoaderScopeOf.writeBoolean(((ClassLoaderRole)scope.getSecond()).unbox-impl());
        return true;
    }

    private final void writeScope(Encoder $this$writeScope, ClassLoaderScopeSpec scope) {
        Integer id2 = this.scopes.getId((Object)scope);
        if (id2 != null) {
            $this$writeScope.writeSmallInt(id2.intValue());
        } else {
            int newId = this.scopes.putInstance((Object)scope);
            $this$writeScope.writeSmallInt(newId);
            if (scope.getParent() == null) {
                $this$writeScope.writeBoolean(false);
            } else {
                $this$writeScope.writeBoolean(true);
                this.writeScope($this$writeScope, scope.getParent());
            }
            $this$writeScope.writeString((CharSequence)scope.getName());
            if (scope.getOrigin() instanceof ClassLoaderScopeOrigin.Script) {
                $this$writeScope.writeBoolean(true);
                $this$writeScope.writeString((CharSequence)((ClassLoaderScopeOrigin.Script)scope.getOrigin()).getFileName());
                $this$writeScope.writeString((CharSequence)((ClassLoaderScopeOrigin.Script)scope.getOrigin()).getLongDisplayName().getDisplayName());
                $this$writeScope.writeString((CharSequence)((ClassLoaderScopeOrigin.Script)scope.getOrigin()).getShortDisplayName().getDisplayName());
            } else {
                $this$writeScope.writeBoolean(false);
            }
            ClassPathEncodingExtensionsKt.writeClassPath($this$writeScope, scope.getLocalClassPath());
            this.writeHashCode($this$writeScope, scope.getLocalImplementationHash());
            ClassPathEncodingExtensionsKt.writeClassPath($this$writeScope, scope.getExportClassPath());
        }
    }

    private final void ensureClassCanBeFoundInGradleRuntimeClassLoader(String className, ClassLoader originalClassLoader) {
        try {
            ClassLoader classLoader = ClassLoadingKt.getGradleRuntimeClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"gradleRuntimeClassLoader");
            ClassLoadingKt.classForName(className, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationCacheError("Class '" + className + "' cannot be encoded because " + ClassLoadingKt.describeClassLoader(originalClassLoader) + " could not be encoded and the class is not available through the default class loader.\n" + DefaultClassEncoderKt.describeKnownClassLoaders(this.scopeLookup) + "Please report this error, run './gradlew --stop' and try again.", (Throwable)e);
        }
    }

    private final void writeHashCode(Encoder $this$writeHashCode, HashCode hashCode) {
        if (hashCode == null) {
            $this$writeHashCode.writeBoolean(false);
        } else {
            $this$writeHashCode.writeBoolean(true);
            $this$writeHashCode.writeBinary(hashCode.toByteArray());
        }
    }
}

