/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.serialize;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.ClassLoaderScopeOrigin;
import org.gradle.internal.Describables;
import org.gradle.internal.cc.impl.serialize.ClassLoadingKt;
import org.gradle.internal.cc.impl.serialize.ClassPathEncodingExtensionsKt;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.graph.ClassDecoder;
import org.gradle.internal.serialize.graph.ReadIdentities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t*\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\nH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\nH\u0002J\f\u0010\u000f\u001a\u00020\u0003*\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gradle/internal/cc/impl/serialize/DefaultClassDecoder;", "Lorg/gradle/internal/serialize/graph/ClassDecoder;", "defaultClassLoaderScope", "Lorg/gradle/api/internal/initialization/ClassLoaderScope;", "(Lorg/gradle/api/internal/initialization/ClassLoaderScope;)V", "classes", "Lorg/gradle/internal/serialize/graph/ReadIdentities;", "scopes", "decodeClass", "Ljava/lang/Class;", "Lorg/gradle/internal/serialize/Decoder;", "decodeClassLoader", "Ljava/lang/ClassLoader;", "readHashCode", "Lorg/gradle/internal/hash/HashCode;", "readScope", "configuration-cache"})
public final class DefaultClassDecoder
implements ClassDecoder {
    @NotNull
    private final ClassLoaderScope defaultClassLoaderScope;
    @NotNull
    private final ReadIdentities classes;
    @NotNull
    private final ReadIdentities scopes;

    public DefaultClassDecoder(@NotNull ClassLoaderScope defaultClassLoaderScope) {
        Intrinsics.checkNotNullParameter((Object)defaultClassLoaderScope, (String)"defaultClassLoaderScope");
        this.defaultClassLoaderScope = defaultClassLoaderScope;
        this.classes = new ReadIdentities();
        this.scopes = new ReadIdentities();
    }

    @NotNull
    public Class<?> decodeClass(@NotNull Decoder $this$decodeClass) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeClass, (String)"<this>");
        int id2 = $this$decodeClass.readSmallInt();
        Object type = this.classes.getInstance(id2);
        if (type != null) {
            return (Class)type;
        }
        String name = $this$decodeClass.readString();
        ClassLoader classLoader = this.decodeClassLoader($this$decodeClass);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 == null) {
            classLoader2 = ClassLoadingKt.getGradleRuntimeClassLoader();
        }
        Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"classLoader ?: gradleRuntimeClassLoader");
        Class<?> newType = ClassLoadingKt.classForName(name, classLoader2);
        this.classes.putInstance(id2, newType);
        return newType;
    }

    @Nullable
    public ClassLoader decodeClassLoader(@NotNull Decoder $this$decodeClassLoader) {
        ClassLoader classLoader;
        Intrinsics.checkNotNullParameter((Object)$this$decodeClassLoader, (String)"<this>");
        if ($this$decodeClassLoader.readBoolean()) {
            ClassLoaderScope scope = this.readScope($this$decodeClassLoader);
            classLoader = $this$decodeClassLoader.readBoolean() ? scope.getLocalClassLoader() : scope.getExportClassLoader();
        } else {
            classLoader = null;
        }
        return classLoader;
    }

    private final ClassLoaderScope readScope(Decoder $this$readScope) {
        int id2 = $this$readScope.readSmallInt();
        Object scope = this.scopes.getInstance(id2);
        if (scope != null) {
            return (ClassLoaderScope)scope;
        }
        ClassLoaderScope parent = $this$readScope.readBoolean() ? this.readScope($this$readScope) : this.defaultClassLoaderScope;
        String name = $this$readScope.readString();
        ClassLoaderScopeOrigin.Script origin = $this$readScope.readBoolean() ? new ClassLoaderScopeOrigin.Script($this$readScope.readString(), Describables.of((Object)$this$readScope.readString()), Describables.of((Object)$this$readScope.readString())) : null;
        ClassPath localClassPath = ClassPathEncodingExtensionsKt.readClassPath($this$readScope);
        HashCode localImplementationHash = this.readHashCode($this$readScope);
        ClassPath exportClassPath = ClassPathEncodingExtensionsKt.readClassPath($this$readScope);
        ClassLoaderScope classLoaderScope = localImplementationHash != null && exportClassPath.isEmpty() ? parent.createLockedChild(name, (ClassLoaderScopeOrigin)origin, localClassPath, localImplementationHash, null) : parent.createChild(name, (ClassLoaderScopeOrigin)origin).local(localClassPath).export(exportClassPath).lock();
        Intrinsics.checkNotNullExpressionValue((Object)classLoaderScope, (String)"if (localImplementationH\u2026assPath).lock()\n        }");
        ClassLoaderScope newScope = classLoaderScope;
        this.scopes.putInstance(id2, (Object)newScope);
        return newScope;
    }

    private final HashCode readHashCode(Decoder $this$readHashCode) {
        return $this$readHashCode.readBoolean() ? HashCode.fromBytes((byte[])$this$readHashCode.readBinary()) : null;
    }
}

