/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.execution;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.gradle.kotlin.dsl.execution.InterpreterKt;
import org.gradle.kotlin.dsl.execution.PluginsBlockInterpretation;
import org.gradle.kotlin.dsl.execution.PluginsBlockInterpretationKt;
import org.gradle.kotlin.dsl.execution.Program;
import org.gradle.kotlin.dsl.execution.ProgramKind;
import org.gradle.kotlin.dsl.execution.ProgramSource;
import org.gradle.kotlin.dsl.execution.ProgramSourceFragment;
import org.gradle.kotlin.dsl.execution.ProgramTarget;
import org.gradle.kotlin.dsl.execution.ProgramText;
import org.gradle.kotlin.dsl.execution.ResidualProgram;
import org.gradle.kotlin.dsl.execution.ScriptSection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000b\u001a\u00020\u0010H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/gradle/kotlin/dsl/execution/PartialEvaluator;", "", "programKind", "Lorg/gradle/kotlin/dsl/execution/ProgramKind;", "programTarget", "Lorg/gradle/kotlin/dsl/execution/ProgramTarget;", "(Lorg/gradle/kotlin/dsl/execution/ProgramKind;Lorg/gradle/kotlin/dsl/execution/ProgramTarget;)V", "defaultStageTransition", "Lorg/gradle/kotlin/dsl/execution/ResidualProgram$Instruction;", "fragmentHolderSourceFor", "Lorg/gradle/kotlin/dsl/execution/ProgramSource;", "program", "Lorg/gradle/kotlin/dsl/execution/Program$FragmentHolder;", "logUnoptimized", "", "plugins", "Lorg/gradle/kotlin/dsl/execution/Program$Plugins;", "interpretation", "Lorg/gradle/kotlin/dsl/execution/PluginsBlockInterpretation$Dynamic;", "optimize", "Lorg/gradle/kotlin/dsl/execution/ResidualProgram$Instruction$ApplyPluginRequests;", "optimizedPluginsBlock", "stage1", "Lorg/gradle/kotlin/dsl/execution/Program$Stage1;", "reduce", "Lorg/gradle/kotlin/dsl/execution/ResidualProgram;", "Lorg/gradle/kotlin/dsl/execution/Program;", "reduceBuildscriptProgram", "Lorg/gradle/kotlin/dsl/execution/ResidualProgram$Static;", "Lorg/gradle/kotlin/dsl/execution/Program$Buildscript;", "reduceEmptyProgram", "reduceScriptProgram", "Lorg/gradle/kotlin/dsl/execution/Program$Script;", "reduceStage1Program", "reduceStagedProgram", "Lorg/gradle/kotlin/dsl/execution/ResidualProgram$Dynamic;", "Lorg/gradle/kotlin/dsl/execution/Program$Staged;", "stage1WithPluginManagement", "Lorg/gradle/kotlin/dsl/execution/Program$PluginManagement;", "stage1WithPlugins", "static", "applyPlugins", "kotlin-dsl"})
public final class PartialEvaluator {
    @NotNull
    private final ProgramKind programKind;
    @NotNull
    private final ProgramTarget programTarget;

    public PartialEvaluator(@NotNull ProgramKind programKind, @NotNull ProgramTarget programTarget) {
        Intrinsics.checkNotNullParameter((Object)((Object)programKind), (String)"programKind");
        Intrinsics.checkNotNullParameter((Object)((Object)programTarget), (String)"programTarget");
        this.programKind = programKind;
        this.programTarget = programTarget;
    }

    @NotNull
    public final ResidualProgram reduce(@NotNull Program program2) {
        ResidualProgram residualProgram2;
        Intrinsics.checkNotNullParameter((Object)program2, (String)"program");
        Program program3 = program2;
        if (program3 instanceof Program.Empty) {
            residualProgram2 = this.reduceEmptyProgram();
        } else if (program3 instanceof Program.PluginManagement) {
            residualProgram2 = this.stage1WithPluginManagement((Program.PluginManagement)program2);
        } else if (program3 instanceof Program.Buildscript) {
            residualProgram2 = this.reduceBuildscriptProgram((Program.Buildscript)program2);
        } else if (program3 instanceof Program.Plugins) {
            residualProgram2 = this.stage1WithPlugins((Program.Stage1)program2);
        } else if (program3 instanceof Program.Stage1Sequence) {
            residualProgram2 = this.stage1WithPlugins((Program.Stage1)program2);
        } else if (program3 instanceof Program.Script) {
            residualProgram2 = this.reduceScriptProgram((Program.Script)program2);
        } else if (program3 instanceof Program.Staged) {
            residualProgram2 = this.reduceStagedProgram((Program.Staged)program2);
        } else {
            throw new IllegalArgumentException("Unsupported `" + program2 + '\'');
        }
        return residualProgram2;
    }

    private final ResidualProgram.Static reduceEmptyProgram() {
        ResidualProgram.Static static_;
        block5: {
            block4: {
                if (WhenMappings.$EnumSwitchMapping$1[this.programTarget.ordinal()] != 1) break block4;
                switch (WhenMappings.$EnumSwitchMapping$0[this.programKind.ordinal()]) {
                    case 1: {
                        ResidualProgram.Instruction[] instructionArray = new ResidualProgram.Instruction[]{ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, ResidualProgram.Instruction.ApplyDefaultPluginRequests.INSTANCE, ResidualProgram.Instruction.ApplyBasePlugins.INSTANCE};
                        ResidualProgram.Static static_2 = new ResidualProgram.Static(instructionArray);
                        static_ = static_2;
                        break block5;
                    }
                    case 2: {
                        ResidualProgram.Instruction[] instructionArray = new ResidualProgram.Instruction[]{ResidualProgram.Instruction.CloseTargetScope.INSTANCE, ResidualProgram.Instruction.ApplyBasePlugins.INSTANCE};
                        ResidualProgram.Static static_3 = new ResidualProgram.Static(instructionArray);
                        static_ = static_3;
                        break block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            ResidualProgram.Instruction[] instructionArray = new ResidualProgram.Instruction[]{this.defaultStageTransition()};
            ResidualProgram.Static static_4 = new ResidualProgram.Static(instructionArray);
            static_ = static_4;
        }
        return static_;
    }

    private final ResidualProgram.Static reduceBuildscriptProgram(Program.Buildscript program2) {
        ResidualProgram.Static static_;
        if (WhenMappings.$EnumSwitchMapping$1[this.programTarget.ordinal()] == 1) {
            ResidualProgram.Instruction[] instructionArray = new ResidualProgram.Instruction[]{ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, new ResidualProgram.Instruction.CollectProjectScriptDependencies(this.fragmentHolderSourceFor(program2)), this.defaultStageTransition()};
            ResidualProgram.Static static_2 = new ResidualProgram.Static(instructionArray);
            static_ = static_2;
        } else {
            ResidualProgram.Instruction[] instructionArray = new ResidualProgram.Instruction[]{ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, new ResidualProgram.Instruction.Eval(this.fragmentHolderSourceFor(program2)), this.defaultStageTransition()};
            ResidualProgram.Static static_3 = new ResidualProgram.Static(instructionArray);
            static_ = static_3;
        }
        return static_;
    }

    private final ProgramSource fragmentHolderSourceFor(Program.FragmentHolder program2) {
        ProgramSourceFragment fragment = program2.getFragment();
        ScriptSection section = fragment.getSection$kotlin_dsl();
        return fragment.getSource().map((Function1<? super ProgramText, ProgramText>)((Function1)new Function1<ProgramText, ProgramText>(section){
            final /* synthetic */ ScriptSection $section;
            {
                this.$section = $section;
                super(1);
            }

            public final ProgramText invoke(ProgramText sourceText) {
                Intrinsics.checkNotNullParameter((Object)sourceText, (String)"sourceText");
                return sourceText.subText(new IntRange(0, this.$section.getBlock().getLast())).preserve(this.$section.getWholeRange());
            }
        }));
    }

    private final ResidualProgram reduceScriptProgram(Program.Script program2) {
        ResidualProgram residualProgram2;
        block5: {
            block4: {
                if (WhenMappings.$EnumSwitchMapping$1[this.programTarget.ordinal()] != 1) break block4;
                switch (WhenMappings.$EnumSwitchMapping$0[this.programKind.ordinal()]) {
                    case 1: {
                        ResidualProgram.Instruction[] instructionArray = new ResidualProgram.Instruction[]{ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, ResidualProgram.Instruction.ApplyDefaultPluginRequests.INSTANCE, ResidualProgram.Instruction.ApplyBasePlugins.INSTANCE};
                        residualProgram2 = new ResidualProgram.Dynamic(new ResidualProgram.Static(instructionArray), program2.getSource());
                        break block5;
                    }
                    case 2: {
                        ResidualProgram.Instruction[] instructionArray = new ResidualProgram.Instruction[]{ResidualProgram.Instruction.CloseTargetScope.INSTANCE, ResidualProgram.Instruction.ApplyBasePlugins.INSTANCE, new ResidualProgram.Instruction.Eval(program2.getSource())};
                        residualProgram2 = new ResidualProgram.Static(instructionArray);
                        break block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            ResidualProgram.Instruction[] instructionArray = new ResidualProgram.Instruction[]{this.defaultStageTransition(), new ResidualProgram.Instruction.Eval(program2.getSource())};
            residualProgram2 = new ResidualProgram.Static(instructionArray);
        }
        return residualProgram2;
    }

    private final ResidualProgram.Instruction defaultStageTransition() {
        return WhenMappings.$EnumSwitchMapping$0[this.programKind.ordinal()] == 1 ? (ResidualProgram.Instruction)ResidualProgram.Instruction.ApplyDefaultPluginRequests.INSTANCE : (ResidualProgram.Instruction)ResidualProgram.Instruction.CloseTargetScope.INSTANCE;
    }

    private final ResidualProgram.Dynamic reduceStagedProgram(Program.Staged program2) {
        return new ResidualProgram.Dynamic(this.reduceStage1Program(program2.getStage1()), program2.getStage2().getSource());
    }

    private final ResidualProgram.Static reduceStage1Program(Program.Stage1 stage1) {
        ResidualProgram.Static static_;
        if (stage1 instanceof Program.Buildscript) {
            if (WhenMappings.$EnumSwitchMapping$1[this.programTarget.ordinal()] == 1) {
                ResidualProgram.Instruction[] instructionArray = new ResidualProgram.Instruction[]{ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, new ResidualProgram.Instruction.CollectProjectScriptDependencies(this.fragmentHolderSourceFor((Program.FragmentHolder)((Object)stage1))), ResidualProgram.Instruction.ApplyDefaultPluginRequests.INSTANCE, ResidualProgram.Instruction.ApplyBasePlugins.INSTANCE};
                ResidualProgram.Static static_2 = new ResidualProgram.Static(instructionArray);
                static_ = static_2;
            } else {
                static_ = this.reduceBuildscriptProgram((Program.Buildscript)stage1);
            }
        } else {
            static_ = this.stage1WithPlugins(stage1);
        }
        return static_;
    }

    private final ResidualProgram.Static stage1WithPlugins(Program.Stage1 stage1) {
        ResidualProgram.Instruction instruction = this.optimizedPluginsBlock(stage1);
        if (instruction == null) {
            instruction = new ResidualProgram.Instruction.ApplyPluginRequestsOf(stage1);
        }
        return this.static(instruction);
    }

    private final ResidualProgram.Instruction.ApplyPluginRequests optimizedPluginsBlock(Program.Stage1 stage1) {
        return stage1 instanceof Program.Plugins ? this.optimize((Program.Plugins)stage1) : null;
    }

    private final ResidualProgram.Instruction.ApplyPluginRequests optimize(Program.Plugins program2) {
        ResidualProgram.Instruction.ApplyPluginRequests applyPluginRequests;
        PluginsBlockInterpretation interpretation = PluginsBlockInterpretationKt.interpret(program2);
        if (interpretation instanceof PluginsBlockInterpretation.Static) {
            applyPluginRequests = new ResidualProgram.Instruction.ApplyPluginRequests(((PluginsBlockInterpretation.Static)interpretation).getPlugins(), program2);
        } else if (interpretation instanceof PluginsBlockInterpretation.Dynamic) {
            this.logUnoptimized(program2, (PluginsBlockInterpretation.Dynamic)interpretation);
            applyPluginRequests = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return applyPluginRequests;
    }

    private final ResidualProgram.Static static(ResidualProgram.Instruction applyPlugins) {
        ResidualProgram.Static static_;
        if (WhenMappings.$EnumSwitchMapping$1[this.programTarget.ordinal()] == 1) {
            ResidualProgram.Instruction[] instructionArray = new ResidualProgram.Instruction[]{ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, applyPlugins, ResidualProgram.Instruction.ApplyBasePlugins.INSTANCE};
            ResidualProgram.Static static_2 = new ResidualProgram.Static(instructionArray);
            static_ = static_2;
        } else {
            ResidualProgram.Instruction[] instructionArray = new ResidualProgram.Instruction[]{ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, applyPlugins};
            ResidualProgram.Static static_3 = new ResidualProgram.Static(instructionArray);
            static_ = static_3;
        }
        return static_;
    }

    private final void logUnoptimized(Program.Plugins plugins2, PluginsBlockInterpretation.Dynamic interpretation) {
        Logger $this$logUnoptimized_u24lambda_u240 = InterpreterKt.getInterpreterLogger();
        boolean bl = false;
        if ($this$logUnoptimized_u24lambda_u240.isDebugEnabled()) {
            $this$logUnoptimized_u24lambda_u240.debug("Unable to interpret plugins block in '" + plugins2.getFragment().getSource().getPath() + "', Kotlin compiler will be used: " + interpretation.getReason());
        }
    }

    private final ResidualProgram.Static stage1WithPluginManagement(Program.PluginManagement program2) {
        ResidualProgram.Instruction[] instructionArray = new ResidualProgram.Instruction[]{ResidualProgram.Instruction.SetupEmbeddedKotlin.INSTANCE, new ResidualProgram.Instruction.Eval(this.fragmentHolderSourceFor(program2)), ResidualProgram.Instruction.ApplyDefaultPluginRequests.INSTANCE};
        return new ResidualProgram.Static(instructionArray);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProgramKind.values().length];
            try {
                nArray[ProgramKind.TopLevel.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgramKind.ScriptPlugin.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProgramTarget.values().length];
            try {
                nArray[ProgramTarget.Project.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

