/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchainSpecInternal;

public abstract class DefaultToolchainSpec
implements JavaToolchainSpecInternal {
    @Inject
    public DefaultToolchainSpec() {
        this.getVendor().convention((Object)DefaultToolchainSpec.getConventionVendor());
        this.getImplementation().convention((Object)DefaultToolchainSpec.getConventionImplementation());
    }

    @Override
    public JavaToolchainSpecInternal.Key toKey() {
        return new Key((JavaLanguageVersion)this.getLanguageVersion().getOrNull(), (JvmVendorSpec)this.getVendor().getOrNull(), (JvmImplementation)this.getImplementation().getOrNull());
    }

    @Override
    public boolean isConfigured() {
        return this.getLanguageVersion().isPresent();
    }

    @Override
    public boolean isValid() {
        if (this.getVendor().getOrNull() == JvmVendorSpec.IBM_SEMERU) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)"Requesting JVM vendor IBM_SEMERU.").willBeRemovedInGradle9().withUpgradeGuideSection(8, "ibm_semeru_should_not_be_used")).nagUser();
        }
        return this.getLanguageVersion().isPresent() || this.isSecondaryPropertiesUnchanged();
    }

    private boolean isSecondaryPropertiesUnchanged() {
        return Objects.equals(DefaultToolchainSpec.getConventionVendor(), this.getVendor().getOrNull()) && Objects.equals(DefaultToolchainSpec.getConventionImplementation(), this.getImplementation().getOrNull());
    }

    @Override
    public void finalizeProperties() {
        this.getLanguageVersion().finalizeValue();
        this.getVendor().finalizeValue();
        this.getImplementation().finalizeValue();
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static JvmVendorSpec getConventionVendor() {
        return DefaultJvmVendorSpec.any();
    }

    private static JvmImplementation getConventionImplementation() {
        return JvmImplementation.VENDOR_SPECIFIC;
    }

    public static class Key
    implements JavaToolchainSpecInternal.Key {
        private final JavaLanguageVersion languageVersion;
        private final JvmVendorSpec vendor;
        private final JvmImplementation implementation;

        public Key(@Nullable JavaLanguageVersion languageVersion, @Nullable JvmVendorSpec vendor, @Nullable JvmImplementation implementation) {
            this.languageVersion = languageVersion;
            this.vendor = vendor;
            this.implementation = implementation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return Objects.equals(this.languageVersion, that.languageVersion) && Objects.equals(this.vendor, that.vendor) && Objects.equals(this.implementation, that.implementation);
        }

        public int hashCode() {
            return Objects.hash(this.languageVersion, this.vendor, this.implementation);
        }

        public String toString() {
            return "DefaultKey{languageVersion=" + this.languageVersion + ", vendor=" + this.vendor + ", implementation=" + this.implementation + '}';
        }
    }
}

