/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal.modifiers;

import java.util.Arrays;
import java.util.List;
import org.gradle.buildinit.plugins.internal.modifiers.Names;

public enum ComponentType {
    APPLICATION("Application", "app", "list", "utilities"),
    LIBRARY("Library", "lib"),
    GRADLE_PLUGIN("Gradle plugin", "plugin"),
    BASIC("Basic (build structure only)", new String[0]);

    private final String displayName;
    private final List<String> defaultProjectNames;

    private ComponentType(String displayName, String ... defaultProjectNames) {
        this.displayName = displayName;
        this.defaultProjectNames = Arrays.asList(defaultProjectNames);
    }

    public List<String> getDefaultProjectNames() {
        return this.defaultProjectNames;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String toString() {
        return Names.displayNameFor(this);
    }

    public String pluralName() {
        return (this.toString() + "s").replace("ys", "ies");
    }
}

