/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.color;

import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParserActionObject;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import com.dickimawbooks.texparserlib.UndefAction;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.generic.TeXParserSetUndefAction;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.color.ColorSty;
import com.dickimawbooks.texparserlib.latex.color.PrepareColorSet;
import java.io.IOException;

public class XColorSty
extends LaTeXSty {
    private ColorSty colorSty;
    private boolean loadX11 = false;
    private boolean loadSvg = false;

    public XColorSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener, boolean bl, ColorSty colorSty) throws IOException {
        this(keyValList, "xcolor", laTeXParserListener, bl, colorSty);
    }

    public XColorSty(KeyValList keyValList, String string, LaTeXParserListener laTeXParserListener, boolean bl, ColorSty colorSty) throws IOException {
        super(keyValList, string, laTeXParserListener, bl);
        this.colorSty = colorSty;
    }

    @Override
    public void addDefinitions() {
        this.registerControlSequence(new TextualContentCommand("colornameprefix", "XC@"));
        this.registerControlSequence(new PrepareColorSet(this.colorSty));
    }

    @Override
    public void processOption(String string, TeXObject teXObject) throws IOException {
        if (string.equals("x11names")) {
            this.loadX11 = true;
        } else if (string.equals("svgnames")) {
            this.loadSvg = true;
        }
    }

    @Override
    protected void postOptions(TeXObjectList teXObjectList) throws IOException {
        super.postOptions(teXObjectList);
        if (this.loadX11 || this.loadSvg) {
            UndefAction undefAction = this.listener.getUndefinedAction();
            int n = this.getParser().getCatCode(64);
            TeXObjectList teXObjectList2 = this.getListener().createStack();
            teXObjectList2.add(new TeXParserSetUndefAction(UndefAction.WARN));
            if (n != 11) {
                teXObjectList2.add(this.listener.getControlSequence("makeatletter"));
            }
            if (this.loadX11) {
                teXObjectList2.add(TeXParserActionObject.createInputAction(this.getParser(), "x11name.def"));
                this.loadX11 = false;
            }
            if (this.loadSvg) {
                teXObjectList2.add(TeXParserActionObject.createInputAction(this.getParser(), "svgname.def"));
                this.loadX11 = false;
            }
            if (n != 11) {
                teXObjectList2.add(this.listener.getControlSequence("catcode"));
                teXObjectList2.add(new UserNumber(64));
                teXObjectList2.add(this.listener.getOther(61));
                teXObjectList2.add(new UserNumber(n));
            }
            teXObjectList2.add(new TeXParserSetUndefAction(undefAction));
            if (!teXObjectList2.isEmpty()) {
                if (this.getParser() == teXObjectList || teXObjectList == null) {
                    this.getParser().push(teXObjectList2, true);
                } else {
                    teXObjectList2.process(this.getParser(), teXObjectList);
                }
            }
        }
    }
}

