/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.TrivListDec;
import com.dickimawbooks.texparserlib.primitives.RomanNumeral;
import java.io.IOException;

public class ListDec
extends TrivListDec {
    public ListDec() {
        this("list");
    }

    public ListDec(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new ListDec(this.getName());
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.getListener().getControlSequence("@nmbrlistfalse").process(teXParser);
        this.setup(teXParser, teXParser, teXParser.popNextArg(), teXParser.popNextArg());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXParser.getListener().getControlSequence("@nmbrlistfalse").process(teXParser, teXObjectList);
        this.setup(teXParser, teXObjectList, teXObjectList.popArg(teXParser), teXObjectList.popArg(teXParser));
    }

    public void setup(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        teXParser.putControlSequence(true, new GenericCommand(true, "@itemlabel", null, teXObject));
        TeXSettings teXSettings = teXParser.getSettings();
        NumericRegister numericRegister = teXSettings.globalAdvanceRegister("@listdepth", LaTeXParserListener.ONE);
        ControlSequence controlSequence = teXParser.getControlSequence(String.format("@list%s", RomanNumeral.romannumeral(numericRegister.number(teXParser))));
        if (controlSequence == null) {
            controlSequence = teXParser.getListener().getControlSequence("relax");
        }
        if (teXParser == teXObjectList || teXObjectList == null) {
            teXObject2.process(teXParser);
        } else {
            teXObject2.process(teXParser, teXObjectList);
        }
        ((LaTeXParserListener)teXParser.getListener()).startList(this);
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXSettings teXSettings = teXParser.getSettings();
        NumericRegister numericRegister = teXSettings.globalAdvanceRegister("@listdepth", LaTeXParserListener.MINUS_ONE);
        super.end(teXParser, teXObjectList);
    }
}

