/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.image;

import com.dickimawbooks.texparserlib.FixedUnit;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.UserDimension;
import java.awt.geom.AffineTransform;

public class TeXGraphicsTransformAttributes {
    private AffineTransform transform;
    private TeXDimension unitWidth;
    private TeXDimension unitHeight;

    public TeXGraphicsTransformAttributes() {
        this(new AffineTransform(), new UserDimension(1.0f, (TeXUnit)TeXUnit.PT), new UserDimension(1.0f, (TeXUnit)TeXUnit.PT));
    }

    public TeXGraphicsTransformAttributes(AffineTransform affineTransform, TeXDimension teXDimension, TeXDimension teXDimension2) {
        this.transform = affineTransform;
        this.unitWidth = teXDimension;
        this.unitHeight = teXDimension2;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public TeXDimension getUnitWidth() {
        return this.unitWidth;
    }

    public TeXDimension getUnitHeight() {
        return this.unitHeight;
    }

    public void setUnitWidth(TeXDimension teXDimension) {
        this.unitWidth = teXDimension;
    }

    public void setUnitHeight(TeXDimension teXDimension) {
        this.unitHeight = teXDimension;
    }

    public void setUnitLength(TeXDimension teXDimension) {
        this.unitWidth = teXDimension;
        this.unitHeight = teXDimension;
    }

    public Object clone() {
        return new TeXGraphicsTransformAttributes((AffineTransform)this.transform.clone(), (TeXDimension)this.unitWidth.clone(), (TeXDimension)this.unitHeight.clone());
    }

    public float toBpX(TeXParser teXParser, float f) throws TeXSyntaxException {
        return TeXGraphicsTransformAttributes.toBp(teXParser, f, this.unitWidth);
    }

    public float toBpY(TeXParser teXParser, float f) throws TeXSyntaxException {
        return TeXGraphicsTransformAttributes.toBp(teXParser, f, this.unitHeight);
    }

    public static float toBp(TeXParser teXParser, float f, TeXDimension teXDimension) throws TeXSyntaxException {
        return teXDimension.getUnit().toUnit(teXParser, f, FixedUnit.BP);
    }
}

