/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.DimenRegister;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Register;
import com.dickimawbooks.texparserlib.TeXCellAlign;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXGlue;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.AlignRow;
import com.dickimawbooks.texparserlib.latex.AlignSpan;
import com.dickimawbooks.texparserlib.latex.MultiCell;
import java.io.IOException;
import java.util.HashMap;

public class L2HAlignRow
extends AlignRow {
    private int[] hlines;
    protected String tag = "td";

    public L2HAlignRow() {
    }

    public L2HAlignRow(int n) {
        super(n);
    }

    public L2HAlignRow(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this();
        this.parse(teXParser, teXObjectList);
    }

    @Override
    protected void startRow(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        int n;
        AbstractTeXObject abstractTeXObject;
        TeXObject teXObject2;
        this.hlines = new int[teXParser.getSettings().getAlignmentColumnCount()];
        for (int i = 0; i < this.hlines.length; ++i) {
            this.hlines[i] = 0;
        }
        TeXObjectList teXObjectList2 = this.getAlignSpanList();
        int n2 = 0;
        for (TeXObject teXObject2 : teXObjectList2) {
            if (!(teXObject2 instanceof AlignSpan)) continue;
            abstractTeXObject = (AlignSpan)teXObject2;
            int n3 = ((AlignSpan)abstractTeXObject).firstColumn();
            n = ((AlignSpan)abstractTeXObject).lastColumn();
            if (n3 == -1 || n == -1) {
                ++n2;
                continue;
            }
            for (int i = n3; i <= n; ++i) {
                int n4 = i - 1;
                this.hlines[n4] = this.hlines[n4] + 1;
            }
        }
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        teXObject2 = l2HConverter.createStack();
        abstractTeXObject = new StartElement("tr");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        switch (n2) {
            case 1: {
                hashMap.put("border-top", "solid");
                break;
            }
            case 2: {
                hashMap.put("border-top", "double");
            }
        }
        ((StartElement)abstractTeXObject).putStyle(l2HConverter, hashMap);
        ((TeXObjectList)teXObject2).add(abstractTeXObject);
        if (this.isEmpty()) {
            hashMap = new HashMap();
            for (n = 0; n < this.hlines.length; ++n) {
                switch (this.hlines[n]) {
                    case 0: {
                        hashMap.put("border-top", "none");
                        break;
                    }
                    case 1: {
                        hashMap.put("border-top", "solid");
                        break;
                    }
                    default: {
                        hashMap.put("border-top", "double");
                    }
                }
                abstractTeXObject = new StartElement("td");
                ((StartElement)abstractTeXObject).putStyle(l2HConverter, hashMap);
                ((TeXObjectList)teXObject2).add(abstractTeXObject);
                ((TeXObjectList)teXObject2).add(new EndElement("td"));
            }
        }
        if (teXParser == teXObjectList || teXObjectList == null) {
            ((TeXObjectList)teXObject2).process(teXParser);
        } else {
            ((TeXObjectList)teXObject2).process(teXParser, teXObjectList);
        }
    }

    @Override
    protected void endRow(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXParser.getListener().getWriteable().writeliteral("</tr>");
    }

    public TeXDimension getDefaultColSep(TeXParser teXParser) throws TeXSyntaxException {
        Register register = teXParser.getSettings().getRegister("tabcolsep");
        if (register == null || !(register instanceof DimenRegister)) {
            throw new TeXSyntaxException(teXParser, "tex.error.dimen_expected", String.format("%stabcolsep", new String(Character.toChars(teXParser.getEscChar()))));
        }
        return ((DimenRegister)register).getDimension();
    }

    protected void getAlignStyle(TeXParser teXParser, TeXCellAlign teXCellAlign, TeXDimension teXDimension, HashMap<String, String> hashMap) throws IOException {
        int n = teXCellAlign.preRuleCount();
        int n2 = teXCellAlign.postRuleCount();
        switch (n) {
            case 0: {
                hashMap.put("border-left", "none");
                break;
            }
            case 1: {
                hashMap.put("border-left", "solid");
                break;
            }
            default: {
                hashMap.put("border-left", "double");
            }
        }
        switch (n2) {
            case 0: {
                hashMap.put("border-right", "none");
                break;
            }
            case 1: {
                hashMap.put("border-right", "solid");
                break;
            }
            default: {
                hashMap.put("border-right", "double");
            }
        }
        int n3 = teXParser.getSettings().getAlignmentColumn();
        switch (this.hlines[n3 - 1]) {
            case 0: {
                hashMap.put("border-top", "none");
                break;
            }
            case 1: {
                hashMap.put("border-top", "solid");
                break;
            }
            default: {
                hashMap.put("border-top", "double");
            }
        }
        String string = teXDimension.format();
        if (teXCellAlign.getBefore() == null) {
            hashMap.put("padding-left", string);
        } else {
            hashMap.put("padding-left", "0px");
        }
        if (teXCellAlign.getAfter() == null) {
            hashMap.put("padding-right", string);
        } else {
            hashMap.put("padding-right", "0px");
        }
        TeXDimension teXDimension2 = teXCellAlign.getWidth();
        if (teXDimension2 != null) {
            hashMap.put("width", ((L2HConverter)teXParser.getListener()).getHtmlDimension(teXDimension2));
        }
        switch (teXCellAlign.getAlign()) {
            case 99: {
                hashMap.put("text-align", "center");
                break;
            }
            case 108: 
            case 112: {
                hashMap.put("text-align", "left");
                break;
            }
            case 114: {
                hashMap.put("text-align", "right");
            }
        }
    }

    @Override
    protected void processCell(TeXParser teXParser, TeXObjectList teXObjectList, TeXCellAlign teXCellAlign, Group group) throws IOException {
        TeXObject teXObject;
        TeXCellAlign teXCellAlign2;
        TeXObject teXObject2;
        TeXObject teXObject3;
        TeXDimension teXDimension = this.getDefaultColSep(teXParser);
        if (teXDimension instanceof TeXGlue) {
            teXDimension = ((TeXGlue)teXDimension).getFixed();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        TeXObject teXObject4 = teXObject3 = group.isEmpty() ? group : group.peekStack();
        if (teXObject3 instanceof MultiCell) {
            teXObject2 = (MultiCell)teXObject3;
            teXCellAlign2 = ((MultiCell)teXObject2).getAlignment();
            int n = ((MultiCell)teXObject2).getRowSpan();
            int n2 = ((MultiCell)teXObject2).getColumnSpan();
            if (n > 1) {
                hashMap.put("rowspan", "" + n);
            }
            if (n2 > 1) {
                hashMap.put("colspan", "" + n2);
            }
        } else {
            teXCellAlign2 = teXCellAlign;
        }
        this.tag = "td";
        if (!group.isEmpty() && (teXObject2 = (TeXObject)group.firstElement()) instanceof ControlSequence && ((ControlSequence)teXObject2).getName().equals("bfseries")) {
            group.remove(0);
            this.tag = "th";
        }
        this.getAlignStyle(teXParser, teXCellAlign2, teXDimension, hashMap);
        this.startCell(teXParser, teXObjectList, hashMap);
        teXObject2 = new TeXObjectList();
        TeXObject teXObject5 = teXCellAlign2.getBefore();
        TeXObject teXObject6 = teXCellAlign2.getAfter();
        if (teXObject5 != null) {
            ((TeXObjectList)teXObject2).add((TeXObject)teXObject5.clone());
        }
        if ((teXObject = teXCellAlign2.getPreShift()) != null) {
            group.push((TeXObject)teXObject.clone());
        }
        ((TeXObjectList)teXObject2).add(group);
        TeXObject teXObject7 = teXCellAlign2.getPostShift();
        if (teXObject7 != null) {
            group.add((TeXObject)teXObject7.clone());
        }
        if (teXObject6 != null) {
            ((TeXObjectList)teXObject2).add((TeXObject)teXObject6.clone());
        }
        ((TeXObjectList)teXObject2).process(teXParser, teXObjectList);
        this.endCell(teXParser, teXObjectList);
    }

    protected void startCell(TeXParser teXParser, TeXObjectList teXObjectList, HashMap<String, String> hashMap) throws IOException {
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        l2HConverter.writeliteral(String.format("<%s%s>", this.tag, l2HConverter.getStyleOrClass(hashMap)));
    }

    protected void endCell(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        teXParser.getListener().getWriteable().writeliteralln(String.format("</%s>", this.tag));
    }
}

