/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.DataObjectList;
import com.dickimawbooks.texparserlib.Direction;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.SpacingObject;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.UserDimension;
import com.dickimawbooks.texparserlib.latex.Begin;
import com.dickimawbooks.texparserlib.latex.End;
import com.dickimawbooks.texparserlib.primitives.Else;
import com.dickimawbooks.texparserlib.primitives.Fi;
import com.dickimawbooks.texparserlib.primitives.Or;
import com.dickimawbooks.texparserlib.primitives.ParIndent;
import com.dickimawbooks.texparserlib.primitives.Relax;
import java.io.IOException;
import java.util.Vector;

public class Paragraph
extends DataObjectList {
    protected TeXDimension leftMargin;
    protected TeXDimension rightMargin;
    protected TeXDimension topMargin;
    protected TeXDimension bottomMargin;
    protected TeXDimension parIndent;
    protected boolean incomplete = false;

    public Paragraph() {
    }

    public Paragraph(int n) {
        super(n);
    }

    public Paragraph(TeXParserListener teXParserListener, String string) {
        super(teXParserListener, string);
    }

    public void setLeftMargin(TeXDimension teXDimension) {
        this.leftMargin = teXDimension;
    }

    public void setRightMargin(TeXDimension teXDimension) {
        this.rightMargin = teXDimension;
    }

    public void setTopMargin(TeXDimension teXDimension) {
        this.topMargin = teXDimension;
    }

    public void setBottomMargin(TeXDimension teXDimension) {
        this.bottomMargin = teXDimension;
    }

    public void setParIndent(TeXDimension teXDimension) {
        this.parIndent = teXDimension;
    }

    public TeXDimension getLeftMargin() {
        return this.leftMargin;
    }

    public TeXDimension getRightMargin() {
        return this.rightMargin;
    }

    public TeXDimension getTopMargin() {
        return this.topMargin;
    }

    public TeXDimension getBottomMargin() {
        return this.bottomMargin;
    }

    public TeXDimension getParIndent() {
        return this.parIndent;
    }

    @Override
    public boolean isStack() {
        return false;
    }

    @Override
    public TeXObjectList createList() {
        return new Paragraph(this.capacity());
    }

    protected TeXObject getHead(TeXParser teXParser) {
        return null;
    }

    protected TeXObject getTail(TeXParser teXParser) {
        return teXParser.getListener().getPar();
    }

    public boolean isIncomplete() {
        return this.incomplete;
    }

    public void build(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        boolean bl = false;
        byte by = TeXObjectList.POP_IGNORE_LEADING_SPACE;
        boolean bl2 = !this.incomplete;
        String string = null;
        Vector<String> vector = null;
        UserDimension userDimension = null;
        if (bl2 && (teXObject = teXParser.getSettings().getCurrentParIndent()) != null) {
            userDimension = new UserDimension();
            userDimension.advance(teXParser, (Numerical)teXObject);
        }
        while (!bl && (teXObject = teXObjectList.popToken(by)) != null) {
            Object object;
            by = 0;
            if ((teXObject = TeXParserUtils.resolve(teXObject, teXParser)).canExpand() && teXObject instanceof Expandable && !teXObject.isDataObject()) {
                teXObjectList.push(TeXParserUtils.expandOnce(teXObject, teXParser, teXObjectList), true);
                continue;
            }
            if (teXObject.isPar()) {
                bl = true;
                continue;
            }
            if (teXObject instanceof Else || teXObject instanceof Fi || teXObject instanceof Or) {
                teXObjectList.push(teXObject);
                break;
            }
            if (teXObject instanceof ParIndent && bl2) {
                if (teXParser == teXObjectList) {
                    teXObject.process(teXParser);
                } else {
                    teXObject.process(teXParser, teXObjectList);
                }
                if ((object = teXParser.getSettings().getCurrentParIndent()) == null) continue;
                if (userDimension == null) {
                    userDimension = new UserDimension();
                }
                userDimension.advance(teXParser, (Numerical)object);
                continue;
            }
            if (bl2 && teXObject instanceof SpacingObject && ((SpacingObject)teXObject).getDirection() == Direction.HORIZONTAL) {
                if (userDimension == null) {
                    userDimension = new UserDimension();
                }
                userDimension.advance(teXParser, ((SpacingObject)teXObject).getSize(teXParser, teXObjectList));
                continue;
            }
            if (teXObject instanceof SpacingObject && ((SpacingObject)teXObject).getDirection() == Direction.VERTICAL) {
                bl = true;
                teXObjectList.push(teXObject);
                continue;
            }
            if (teXObject instanceof Relax) {
                this.add(teXObject);
                continue;
            }
            if (teXObject instanceof Begin) {
                bl2 = false;
                this.add(teXObject, true);
                string = ((Begin)teXObject).popLabelString(teXParser, teXObjectList);
                this.add(teXParser.getListener().createGroup(string));
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.add(string);
                continue;
            }
            if (teXObject instanceof End) {
                bl2 = false;
                object = ((End)teXObject).popLabelString(teXParser, teXObjectList);
                if (vector == null || vector.isEmpty() || !((String)object).equals(string)) {
                    teXObjectList.push(teXParser.getListener().createGroup((String)object));
                    teXObjectList.push(teXObject);
                    bl = true;
                    continue;
                }
                this.add(teXObject, true);
                this.add(teXParser.getListener().createGroup((String)object));
                string = (String)vector.remove(vector.size() - 1);
                continue;
            }
            bl2 = false;
            this.add(teXObject, true);
        }
        if (userDimension != null) {
            this.setParIndent(userDimension);
        }
        this.incomplete = !bl;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        if (this.incomplete) {
            this.build(teXParser, teXObjectList);
            this.incomplete = false;
        }
        if ((teXObject = this.getHead(teXParser)) != null) {
            teXObject.process(teXParser, teXObjectList);
        }
        super.process(teXParser, teXObjectList);
        TeXObject teXObject2 = this.getTail(teXParser);
        if (teXObject2 != null) {
            teXObject2.process(teXParser, teXObjectList);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        TeXObject teXObject;
        if (this.incomplete) {
            this.build(teXParser, teXParser);
            this.incomplete = false;
        }
        if ((teXObject = this.getHead(teXParser)) != null) {
            teXObject.process(teXParser);
        }
        super.process(teXParser);
        TeXObject teXObject2 = this.getTail(teXParser);
        if (teXObject2 != null) {
            teXObject2.process(teXParser);
        }
    }

    @Override
    protected String toStringExtraIdentifier() {
        return String.format("(left=%s,right=%s,top=%s,bottom=%s,indent=%s,incomplete=%s)", this.leftMargin, this.rightMargin, this.topMargin, this.bottomMargin, this.parIndent, this.incomplete);
    }
}

