/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.DateTimeGroupTitle;
import com.dickimawbooks.bib2gls.GlsResource;
import com.dickimawbooks.bib2gls.GroupTitle;
import com.dickimawbooks.bib2gls.SortComparator;
import com.dickimawbooks.bib2gls.SortSettings;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

public class Bib2GlsEntryDateTimeComparator
extends SortComparator {
    private boolean hasDate;
    private boolean hasTime;
    private DateFormat dateFormat;
    private DateFormat sortDateFormat;
    private Calendar calendar = null;

    public Bib2GlsEntryDateTimeComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, SortSettings sortSettings, String string, String string2, String string3, boolean bl) {
        super(bib2Gls, vector, sortSettings, string, string2, string3, bl);
        String string4 = sortSettings.getDateFormat();
        Locale locale = sortSettings.getDateLocale();
        if (sortSettings.isDateTimeSort()) {
            this.hasDate = true;
            this.hasTime = true;
            this.sortDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        } else if (sortSettings.isDateSort()) {
            this.hasDate = true;
            this.hasTime = false;
            this.sortDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            this.calendar = locale == null ? Calendar.getInstance() : Calendar.getInstance(locale);
        } else {
            this.hasDate = false;
            this.hasTime = true;
            this.sortDateFormat = new SimpleDateFormat("HH:mm:ssZ");
        }
        this.dateFormat = SortSettings.getDateFormat(locale, string4, this.hasDate, this.hasTime);
    }

    @Override
    protected boolean useSortSuffix() {
        return false;
    }

    @Override
    protected String adjustSort(Bib2GlsEntry bib2GlsEntry, String string) {
        Long l;
        Date date;
        String string2 = bib2GlsEntry.getId();
        try {
            date = this.dateFormat.parse(string);
        }
        catch (ParseException parseException) {
            date = new Date();
            if (this.dateFormat instanceof SimpleDateFormat) {
                this.bib2gls.warningMessage("warning.cant.parse.pattern.sort", string, string2, ((SimpleDateFormat)this.dateFormat).toPattern());
            }
            this.bib2gls.warningMessage("warning.cant.parse.sort", string, string2);
        }
        string = this.sortDateFormat.format(date);
        if (this.calendar == null) {
            l = date.getTime();
        } else {
            this.calendar.setTime(date);
            int n = this.calendar.get(0);
            if (n == 0) {
                n = -1;
            }
            l = ((long)this.calendar.get(1) * 10000L + (long)this.calendar.get(2) * 100L + (long)this.calendar.get(5)) * (long)n;
            string = String.format("%+d %s", n, string);
        }
        bib2GlsEntry.setNumericSort(l);
        bib2GlsEntry.setSortObject(date);
        return string;
    }

    @Override
    protected long getDefaultGroupId(Bib2GlsEntry bib2GlsEntry, int n, Object object) {
        return bib2GlsEntry.getNumericSort().longValue();
    }

    @Override
    protected GroupTitle createDefaultGroupTitle(int n, Object object, String string, String string2) {
        return new DateTimeGroupTitle(this.bib2gls, this.dateFormat, (Date)object, string, string2, this.hasDate, this.hasTime);
    }

    @Override
    protected String updateSortValue(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) {
        String string = super.updateSortValue(bib2GlsEntry, vector);
        Number number = bib2GlsEntry.getNumericSort();
        Date date = (Date)bib2GlsEntry.getSortObject();
        String string2 = null;
        GlsResource glsResource = this.bib2gls.getCurrentResource();
        String string3 = this.getType(bib2GlsEntry);
        if (string.length() > 0 && glsResource.useGroupField(bib2GlsEntry, vector) && bib2GlsEntry.getFieldValue(this.groupField) == null) {
            string2 = this.setGroupTitle(bib2GlsEntry, -1, date, this.dateFormat.format(date), string3);
        }
        if (this.bib2gls.getVerboseLevel() > 0) {
            String string4 = bib2GlsEntry.getId();
            if (string2 == null) {
                this.bib2gls.verbose(String.format("%s -> '%s' [%d]", string4, string, number));
            } else {
                this.bib2gls.verbose(String.format("%s -> '%s' [%d] (%s)", string4, string, number, string2));
            }
        }
        return string;
    }

    @Override
    protected int compare(Number number, Number number2) {
        return ((Long)number).compareTo((Long)number2);
    }

    @Override
    protected int compareElements(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2) {
        Number number = bib2GlsEntry.getNumericSort();
        Number number2 = bib2GlsEntry2.getNumericSort();
        return this.compare(number, number2);
    }
}

