# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Seacas/SEACASCpup clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "SEACASCpup requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Seacas/SEACASCpup build
## ---------------------------------------------------------------------------

set(SEACASCpup_CXX_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/g++.exe")

set(SEACASCpup_C_COMPILER "${CMAKE_CURRENT_LIST_DIR}/../../../bin/gcc.exe")

set(SEACASCpup_Fortran_COMPILER "gfortran")
# Deprecated!
set(SEACASCpup_FORTRAN_COMPILER "gfortran") 


## ---------------------------------------------------------------------------
## Compiler flags used by Seacas/SEACASCpup build
## ---------------------------------------------------------------------------

## Give the build type
set(SEACASCpup_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(SEACASCpup_CXX_FLAGS [[ ]])

set(SEACASCpup_C_FLAGS [[  -Wall -Wunused -pedantic -Wshadow -std=c11 ]])

set(SEACASCpup_Fortran_FLAGS [[ ]])
# Deprecated
set(SEACASCpup_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(SEACASCpup_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(SEACASCpup_SHARED_LIB_RPATH_COMMAND "${CMAKE_CURRENT_LIST_DIR}/../../../lib")
set(SEACASCpup_BUILD_SHARED_LIBS "ON")

set(SEACASCpup_LINKER ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ld.exe)
set(SEACASCpup_AR ${CMAKE_CURRENT_LIST_DIR}/../../../bin/ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(SEACASCpup_INSTALL_DIR "${CMAKE_CURRENT_LIST_DIR}/../../..")

## List of package libraries
set(SEACASCpup_LIBRARIES SEACASCpup::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(SEACASCpup_MPI_LIBRARIES "")
set(SEACASCpup_MPI_LIBRARY_DIRS "")
set(SEACASCpup_MPI_INCLUDE_DIRS "")
set(SEACASCpup_MPI_EXEC "")
set(SEACASCpup_MPI_EXEC_MAX_NUMPROCS "")
set(SEACASCpup_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(SEACASCpup_ENABLE_SEACASExodus ON)
set(SEACASCpup_ENABLE_SEACASIoss ON)
set(SEACASCpup_ENABLE_SEACASSuplibC ON)
set(SEACASCpup_ENABLE_SEACASSuplibCpp ON)

# Exported cache variables
set(SEACAS_ENABLE_DEBUG "OFF")
set(HAVE_SEACAS_DEBUG "OFF")
set(SEACASExodus_ENABLE_THREADSAFE "YES")
set(EXODUS_THREADSAFE "ON")
set(SEACASIoss_ENABLE_THREADSAFE "YES")
set(IOSS_THREADSAFE "ON")

# Include configuration of dependent packages
if (NOT TARGET SEACASExodus::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASExodus/SEACASExodusConfig.cmake")
endif()
if (NOT TARGET SEACASIoss::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASIoss/SEACASIossConfig.cmake")
endif()
if (NOT TARGET SEACASSuplibC::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASSuplibC/SEACASSuplibCConfig.cmake")
endif()
if (NOT TARGET SEACASSuplibCpp::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../SEACASSuplibCpp/SEACASSuplibCppConfig.cmake")
endif()

# Import SEACASCpup targets
include("${CMAKE_CURRENT_LIST_DIR}/SEACASCpupTargets.cmake")

# Standard TriBITS-compliant external package variables
set(SEACASCpup_IS_TRIBITS_COMPLIANT TRUE)
set(SEACASCpup_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(SEACASCpup_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(SEACASCpup_EXPORTED_PACKAGE_LIBS_NAMES "")

foreach(libname IN LISTS SEACASCpup_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE SEACASCpup::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Seacas', then use the"
      " new namespaced target 'SEACASCpup::${libname}', or better yet,"
      " 'SEACASCpup::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'SEACASCpup'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Seacas', instead link against the"
      " libraries specified by the variable 'SEACASCpup_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
