# tar

> 归档实用程序。
> 通常与压缩方法结合使用，例如 `gzip` 或 `bzip2`。
> 更多信息：<https://www.gnu.org/software/tar/manual/tar.html>。

- 创建存档并将其写入文件：

`tar cf {{目标文件.tar}} {{路径/到/文件1 路径/到/文件2 ...}}`

- 创建一个 gzip 压缩文件并将其写入文件：

`tar czf {{目标文件.tar.gz}} {{路径/到/文件1 路径/到/文件2 ...}}`

- 使用相对路径从目录创建一个 gzip 压缩文件：

`tar czf {{目标文件.tar.gz}} {{[-C|--directory]}} {{路径/到/目录}} .`

- 详细地将（压缩的）存档文件提取到当前目录中：

`tar xvf {{源文件.tar[.gz|.bz2|.xz]}}`

- 将（压缩的）存档文件解压缩到目标目录中：

`tar xf {{源文件.tar[.gz|.bz2|.xz]}} {{[-C|--directory]}} {{目标目录}}`

- 创建压缩存档并将其写入文件，使用文件扩展名自动确定压缩程序：

`tar caf {{目标文件.tar.xz}} {{路径/到/文件1 路径/到/文件2 ...}}`

- 详细列出 tar 文件的内容：

`tar tvf {{源文件.tar}}`

- 从存档文件中提取与模式匹配的文件：

`tar xf {{源文件.tar}} --wildcards "{{*.html}}"`
