# grep

> Поиск по шаблону в файлах используя регулярные выражения.
> Смотрите также: `regex`.
> Больше информации: <https://www.gnu.org/software/grep/manual/grep.html>.

- Искать по шаблону в файлах:

`grep "{{шаблон_поиска}}" {{путь/к/файлу1 путь/к/файлу2 ...}}`

- Искать по заданной подстроке (регулярные выражения отключены):

`grep {{[-F|--fixed-strings]}} "{{заданная_подстрока}}" {{путь/к/файлу}}`

- Искать по шаблону во всех файлах в директории рекурсивно, исключая двоичные файлы:

`grep {{[-rI|--recursive --binary-files=without-match]}} "{{шаблон_поиска}}" {{путь/к/директории}}`

- Вывести 3 строки контекста вокруг, до или после каждого совпадения:

`grep {{--context|--before-context|--after-context}} 3 "{{шаблон_поиска}}" {{путь/к/файлу}}`

- Вывести имя файла и номер строки для каждого совпадения с цветным выводом:

`grep {{[-Hn|--with-filename --line-number]}} --color=always "{{шаблон_поиска}}" {{путь/к/файлу}}`

- Искать строки, где есть совпадение по шаблону поиска, выводя только совпадающую часть текста:

`grep {{[-o|--only-matching]}} "{{шаблон_поиска}}" {{путь/к/файлу}}`

- Искать строки в стандартном потоке ввода, которые не совпадают с шаблоном поиска:

`cat {{путь/к/файлу}} | grep {{[-v|--invert-match]}} "{{шаблон_поиска}}"`

- Искать, используя расширенные регулярные выражения (поддержка `?`, `+`, `{}`, `()`, и `|`), без учета регистра:

`grep {{[-Ei|--extended-regexp --ignore-case]}} "{{шаблон_поиска}}" {{путь/к/файлу}}`
