# ffmpeg

> भिडियो रूपान्तरण उपकरण।
> हेर्नुहोस् पनि: `gst-launch-1.0`.
> थप जानकारी: <https://ffmpeg.org/ffmpeg.html#Options>।

- भिडियोबाट ध्वनि निकाल्नुहोस् र MP3 को रूपमा सेभ गर्नुहोस:

`ffmpeg -i {{भिडियो.mp4}} -vn {{ध्वनि}}.mp3`

- भिडियोको उचाइ 1000px मा स्केल गर्दै र फ्रेमरेटलाई 15 राखेर GIF को रूपमा सेभ गर्नुहोस:

`ffmpeg -i {{भिडियो.mp4}} {{[-vf|-filter:v]}} 'scale=-1:1000' -r 15 {{आउटपुट.gif}}`

- अंकित छविहरूलाइ(`फ्रेम_1.jpg`, `फ्रेम_2.jpg`, आदि) भिडियो वा GIF मा जोड्नुहोस:

`ffmpeg -i {{फ्रेम_%d.jpg}} -f image2 {{भिडियो.mpg|भिडियो.gif}}`

- भिडियोको mm:ss बाट एकल फ्रेम निकाल्नुहोस् र यसलाई 128x128 रिजोल्युसनको छविको रूपमा सेभ गर्नुहोस्:

`ffmpeg -ss {{mm:ss}} -i {{भिडियो.mp4}} -frames 1 -s {{128x128}} -f image2 {{छवि.png}}`

- दिइएको सुरु समय mm:ss देखि अन्त्यसमय mm2:ss2 सम्म भिडियोलाइ काट्नुहोस (अन्त्य सम्म नै काट्नलाई -to फ्ल्याग हटाउनुहोस्):

`ffmpeg -ss {{mm:ss}} -to {{mm2:ss2}} -i {{भिडियो.mp4}} {{[-c|-codec]}} copy {{आउटपुट.mp4}}`

- AVI भिडियोलाई MP4 मा रूपान्तरण गर्नुहोस्। अडियोको 128kbit बिटरेट राखेर AAC मा, भिडियोको CRF 23 राखेर h264 मा:

`ffmpeg -i {{इनपुट_भिडियो}}.avi {{[-c|-codec]}}:a aac -b:a 128k {{[-c|-codec]}}:v libx264 -crf 23 {{आउटपुट_भिडियो}}.mp4`

- MKV भिडियोको अडियो वा भिडियो स्ट्रिमहरू पुन: एन्कोडिङ नगरी हानिरहित ढाँचामा MP4 मा बदल्नुहोस:

`ffmpeg -i {{इनपुट_भिडियो}}.mkv {{[-c|-codec]}} copy {{आउटपुट_भिडियो}}.mp4`

- MP4 भिडियोलाई VP9 कोडेकमा रूपान्तरण गर्नुहोस्। उत्कृष्ट गुणस्तरको लागि, CRF फ्ल्यागको प्रयोग गर्नुहोस् (सिफारिस गरिएको दायरा 15-35) र `-b:v 0` पनि प्रयोग गर्नुहोस्:

`ffmpeg -i {{इनपुट_भिडियो}}.mp4 {{[-c|-codec]}}:v libvpx-vp9 -crf {{30}} -b:v 0 {{[-c|-codec]}}:a libopus -vbr on -threads {{थ्रेड_संख्या}} {{आउटपुट_भिडियो}}.webm`
