# q

> CSV 및 TSV 파일에서 SQL 유사 쿼리 실행.
> 더 많은 정보: <https://harelba.github.io/q/>.

- 구분 기호를 ','로 지정하여 CSV 파일 쿼리:

`q -d',' "SELECT * from {{경로/대상/파일}}"`

- TSV 파일 쿼리:

`q -t "SELECT * from {{경로/대상/파일}}"`

- 헤더 행이 있는 파일 쿼리:

`q -d{{구분자}} -H "SELECT * from {{경로/대상/파일}}"`

- `stdin`에서 데이터 읽기; 쿼리에서 '-'는 `stdin`의 데이터를 나타냄:

`{{출력}} | q "select * from -"`

- 두 파일을 공통 열 `c1`을 기준으로 조인 (`f1`과 `f2`로 별칭):

`q "SELECT * FROM {{경로/대상/파일}} f1 JOIN {{경로/대상/다른_파일}} f2 ON (f1.c1 = f2.c1)"`

- 출력 구분자와 출력 헤더 행을 사용하여 출력 형식 지정 (참고: 명령은 입력 파일 헤더 또는 쿼리에서 재정의된 열 별칭에 기반하여 열 이름 출력):

`q -D{{구분자}} -O "SELECT {{열}} as {{별칭}} from {{경로/대상/파일}}"`
