# ack

> 프로그래머에게 최적화된 grep과 같은 검색 도구.
> 같이 보기: `rg`.
> 더 많은 정보: <https://beyondgrep.com/documentation/>.

- 현재 디렉토리에서 문자열 또는 정규 표현식이 포함된 파일을 재귀적으로 검색:

`ack "{{검색_패턴}}"`

- 대소문자를 구분하지 않는 패턴 검색:

`ack {{[-i|--ignore-case]}} "{{검색_패턴}}"`

- 패턴과 일치하는 줄을 검색해, 검색되어 일치하는 텍스트만([o]nly) 인쇄:

`ack {{[-o|--output '$&']}} "{{검색_패턴}}"`

- 특정 타입을 가지는 파일로 검색을 제한:

`ack {{[-t|--type]}} {{ruby}} "{{검색_패턴}}"`

- 특정 타입을 가지는 파일을 검색하지 않음:

`ack {{[-t|--type]}} no{{ruby}} "{{검색_패턴}}"`

- 패턴과 일치하는 총 항목 수를 계산:

`ack {{[-c|--count]}} {{[-h|--no-filename]}} "{{검색_패턴}}"`

- 각 파일에 대해서, 파일 이름과 일치하는 개수를 출력:

`ack {{[-c|--count]}} {{[-l|--files-with-matches]}} "{{검색_패턴}}"`

- `--type`과 함께 사용할 수 있는 모든 값을 나열:

`ack --help-types`
