# docker

> Gestion des conteneurs et des images Docker.
> Certaines commandes comme `docker run` ont leur propre documentation.
> Plus d'informations : <https://docs.docker.com/reference/cli/docker/>.

- Liste tous les conteneurs Docker (en cours d'exécution ou arrêtés) :

`docker {{[ps|container ls]}} {{[-a|--all]}}`

- Démarre un conteneur à partir d'une image, avec un nom personnalisé :

`docker {{[run|container run]}} --name {{nom_conteneur}} {{image}}`

- Démarre ou arrête un conteneur existant :

`docker container {{start|stop}} {{nom_conteneur}}`

- Télécharge une image depuis un registre Docker :

`docker {{[pull|image pull]}} {{image}}`

- Affiche les images déjà téléchargées :

`docker {{[images|image ls]}}`

- Ouvre un shell dans un conteneur déjà en cours d'exécution :

`docker {{[exec|container exec]}} {{[-it|--interactive --tty]}} {{nom_conteneur}} {{sh}}`

- Supprime un conteneur arrêté :

`docker {{[rm|container rm]}} {{nom_conteneur}}`

- Récupère et suit les journaux de message d'un conteneur :

`docker {{[logs|container logs]}} {{[-f|--follow]}} {{nom_conteneur}}`
