# $

> Expand a Bash variable.
> More information: <https://gnu.org/software/bash/manual/bash.html#Shell-Variables>.

- Print a variable:

`echo ${{VARIABLE}}`

- Run variable contents as a command:

`${{VARIABLE}}`

- Print the exit status of the previous command:

`echo $?`

- Print a random number between 0 and 32767:

`echo $RANDOM`

- Print one of the prompt strings:

`echo ${{PS0|PS1|PS2|PS3|PS4}}`

- Expand with the output of `command` and run it. Same as enclosing `command` in backticks:

`$({{command}})`

- List how many arguments the current context has:

`echo $#`

- Print out a Bash array:

`echo ${{{array_name[@]}}}`
