# shasum

> SHA மறையீட்டு சரிகாண்தொகைகளைக் கணி அல்லது சரிபார்.
> மேலும் விவரத்திற்கு: <https://manned.org/shasum>.

- ஒன்று அல்லது அதற்கு மேற்பட்ட கோப்புகளுக்கான SHA1 சரிகாண்தொகையைக் கணி:

`shasum {{கோப்பு1/பாதை கோப்பு2/பாதை ...}}`

- ஒன்று அல்லது அதற்கு மேற்பட்ட கோப்புகளுக்கான SHA256 சரிகாண்தொகையைக் கணி:

`shasum --algorithm 256 {{கோப்பு1/பாதை கோப்பு2/பாதை ...}}`

- ஒன்று அல்லது அதற்கு மேற்பட்ட கோப்புகளுக்கான SHA512 சரிகாண்தொகைகளைக் கணி:

`shasum --algorithm 512 {{கோப்பு1/பாதை கோப்பு2/பாதை ...}}`

- `stdin` (இயல் உள்ளீடு) இலிருந்து SHA1 சரிகாண்தொகையை கணி:

`{{கட்டளை}} | shasum`

- SHA256 சரிகாண்தொகை பட்டியலைக் கணக்கிட்டு ஒரு கோப்பில் சேமிக்கவும்:

`shasum --algorithm 256 {{கோப்பு1/பாதை கோப்பு2/பாதை ...}} > {{கோப்பு.sha256/பாதை}}`

- SHA1 தொகைகள் மற்றும் கோப்புப்பெயர்களின் கோப்பைப் படித்து, எல்லாக் கோப்புகளிலும் சரிகாண்தொகைகள் பொருந்துகின்றன என்பதைச் சரிபார்க்கவும்:

`shasum --check {{கோப்பு/பாதை}}`

- விடுபட்ட கோப்புகள் அல்லது சரிபார்ப்பு தோல்வியுற்றால் மட்டுமே செய்தியைக் காட்டவும்:

`shasum --check --quiet {{கோப்பு/பாதை}}`

- சரிபார்ப்பு தோல்வியுற்றால், விடுபட்ட கோப்புகளைப் புறக்கணித்து, செய்தியை மட்டும் காட்டவும்:

`shasum --ignore-missing --check --quiet {{கோப்பு/பாதை}}`
