# 2to3

> Alih bahasa kode program dari Python 2 menuju Python 3 secara otomatis.
> Modul ini telah ditandai untuk dibuang sejak Python versi 3.11 dan telah dibuang sejak versi 3.13.
> Untuk referensi, lihat: <https://github.com/python/cpython/blob/8d42e2d915c3096e7eac1c649751d1da567bb7c3/Doc/whatsnew/3.13.rst?plain=1#L188>.
> Informasi lebih lanjut: <https://manned.org/2to3>.

- Tampilkan apa saja yang akan diubah tanpa mengubahnya secara langsung (dry-run):

`2to3 {{jalan/menuju/berkas.py}}`

- Alih bahasa dan tulis ulang berkas program Python 2 menuju Python 3:

`2to3 {{[-w|--write]}} {{jalan/menuju/berkas.py}}`

- Pilih jenis fitur bahasa yang akan dialihbahasakan dari Python 2 menuju Python 3:

`2to3 {{[-w|--write]}} {{jalan/menuju/berkas.py}} {{[-f|--fix]}} {{raw_input}} {{[-f|--fix]}} {{print}}`

- Pilih jenis fitur bahasa yang dikecualikan dari proses pengalihbahasaan:

`2to3 {{[-w|--write]}} {{jalan/menuju/file.py}} {{[-x|--nofix]}} {{has_key}} {{[-x|--nofix]}} {{isinstance}}`

- Tampilkan daftar fitur bahasa pemrograman yang dapat dialihbahasakan dari Python 2 menuju Python 3:

`2to3 {{[-l|--list-fixes]}}`

- Alih bahasa dan tulis ulang seluruh berkas dari suatu direktori menuju direktori baru:

`2to3 {{[-o|--output-dir]}} {{jalan/menuju/direktori_python3}} {{[-W|--write-unchanged-files]}} {{[-n|--nobackups]}} {{jalan/menuju/direktori_python2}}`

- Jalankan program ini dengan lebih dari satu thread:

`2to3 {{[-j|--processes]}} {{4}} {{[-o|--output-dir]}} {{jalan/menuju/direktori_python3}} {{[-w|--write]}} {{[-n|--nobackups]}} --no-diffs {{jalan/menuju/direktori_python2}}`
