# git commit

> கோப்புகளை களஞ்சியத்திற்கு கமிட்செய்ய.
> மேலும் விவரத்திற்கு: <https://git-scm.com/docs/git-commit>.

- ஒரு செய்தியுடன் களஞ்சியத்திற்கு அரங்குக் கோப்புகளை கமிட் செய்யுங்கள்:

`git commit {{[-m|--message]}} "{{செய்தி}}"`

- ஒரு கோப்பிலிருந்து படிக்கப்பட்ட செய்தியுடன் கட்டப்பட்ட கோப்புகளை கமிட்செய்யவும்:

`git commit {{[-F|--file]}} {{கமிட்_செய்தி_கோப்பு/பாதை}}`

- அனைத்து மாற்றியமைக்கப்பட்ட கோப்புகளையும் தானாக நிலைநிறுத்து, செய்தியுடன் கமிட் செய்யுங்கள்:

`git commit {{[-a|--all]}} {{[-m|--message]}} "{{செய்தி}}"`

- ஸ்டேஜ் செய்யப்பட்ட கோப்புகளை உறுதிசெய்து, குறிப்பிட்ட GPG விசையுடன் கையொப்பமிடுங்கள் (அல்லது எந்த வாதமும் குறிப்பிடப்படவில்லை எனில் கட்டமைப்பு கோப்பில் வரையறுக்கப்பட்ட ஒன்று):

`git commit {{[-S|--gpg-sign]}} {{key_id}} {{[-m|--message]}} "{{செய்தி}}"`

- தற்போது செய்யப்பட்ட மாற்றங்களைச் சேர்ப்பதன் மூலம் கடைசி கமிட்டைப் புதுப்பிக்கவும், கமிட் இன் ஹாஷை மாற்றவும்:

`git commit --amend`

- குறிப்பிட்ட (ஏற்கனவே அரங்கேற்றப்பட்ட) கோப்புகளை மட்டுமே கமிட் செய்யுங்கள்:

`git commit {{கோப்பு1/பாதை கோப்பு2/பாதை ...}}`

- கட்டப்பட்ட கோப்புகள் இல்லாவிட்டாலும், கமிட்டை உருவாக்கவும்:

`git commit {{[-m|--message]}} "{{செய்தி}}" --allow-empty`
