# yacc

> Generate an LALR parser (in C) with a formal grammar specification file.
> See also: `bison`.
> More information: <https://manned.org/yacc.1p>.

- Create a file `y.tab.c` containing the C parser code and compile the grammar file with all necessary constant declarations for values. (Constant declarations file `y.tab.h` is created only when the `-d` flag is used):

`yacc -d {{path/to/grammar_file.y}}`

- Compile a grammar file containing the description of the parser and a report of conflicts generated by ambiguities in the grammar:

`yacc -d {{path/to/grammar_file.y}} -v`

- Compile a grammar file, and prefix output filenames with `prefix` instead of `y`:

`yacc -d {{path/to/grammar_file.y}} -v -b {{prefix}}`
