/* Copyright 2022 - 2025 R. Thomas
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_ASM_X86_REGISTER_H
#define LIEF_ASM_X86_REGISTER_H
namespace LIEF {
namespace assembly {
namespace x86 {
enum class REG;
const char* get_register_name(REG r);

enum class REG {
  NoRegister = 0,
  AH = 1,
  AL = 2,
  AX = 3,
  BH = 4,
  BL = 5,
  BP = 6,
  BPH = 7,
  BPL = 8,
  BX = 9,
  CH = 10,
  CL = 11,
  CS = 12,
  CX = 13,
  DF = 14,
  DH = 15,
  DI = 16,
  DIH = 17,
  DIL = 18,
  DL = 19,
  DS = 20,
  DX = 21,
  EAX = 22,
  EBP = 23,
  EBX = 24,
  ECX = 25,
  EDI = 26,
  EDX = 27,
  EFLAGS = 28,
  EIP = 29,
  EIZ = 30,
  ES = 31,
  ESI = 32,
  ESP = 33,
  FPCW = 34,
  FPSW = 35,
  FS = 36,
  FS_BASE = 37,
  GS = 38,
  GS_BASE = 39,
  HAX = 40,
  HBP = 41,
  HBX = 42,
  HCX = 43,
  HDI = 44,
  HDX = 45,
  HIP = 46,
  HSI = 47,
  HSP = 48,
  IP = 49,
  MXCSR = 50,
  RAX = 51,
  RBP = 52,
  RBX = 53,
  RCX = 54,
  RDI = 55,
  RDX = 56,
  RFLAGS = 57,
  RIP = 58,
  RIZ = 59,
  RSI = 60,
  RSP = 61,
  SI = 62,
  SIH = 63,
  SIL = 64,
  SP = 65,
  SPH = 66,
  SPL = 67,
  SS = 68,
  SSP = 69,
  _EFLAGS = 70,
  CR0 = 71,
  CR1 = 72,
  CR2 = 73,
  CR3 = 74,
  CR4 = 75,
  CR5 = 76,
  CR6 = 77,
  CR7 = 78,
  CR8 = 79,
  CR9 = 80,
  CR10 = 81,
  CR11 = 82,
  CR12 = 83,
  CR13 = 84,
  CR14 = 85,
  CR15 = 86,
  DR0 = 87,
  DR1 = 88,
  DR2 = 89,
  DR3 = 90,
  DR4 = 91,
  DR5 = 92,
  DR6 = 93,
  DR7 = 94,
  DR8 = 95,
  DR9 = 96,
  DR10 = 97,
  DR11 = 98,
  DR12 = 99,
  DR13 = 100,
  DR14 = 101,
  DR15 = 102,
  FP0 = 103,
  FP1 = 104,
  FP2 = 105,
  FP3 = 106,
  FP4 = 107,
  FP5 = 108,
  FP6 = 109,
  FP7 = 110,
  MM0 = 111,
  MM1 = 112,
  MM2 = 113,
  MM3 = 114,
  MM4 = 115,
  MM5 = 116,
  MM6 = 117,
  MM7 = 118,
  R8 = 119,
  R9 = 120,
  R10 = 121,
  R11 = 122,
  R12 = 123,
  R13 = 124,
  R14 = 125,
  R15 = 126,
  ST0 = 127,
  ST1 = 128,
  ST2 = 129,
  ST3 = 130,
  ST4 = 131,
  ST5 = 132,
  ST6 = 133,
  ST7 = 134,
  XMM0 = 135,
  XMM1 = 136,
  XMM2 = 137,
  XMM3 = 138,
  XMM4 = 139,
  XMM5 = 140,
  XMM6 = 141,
  XMM7 = 142,
  XMM8 = 143,
  XMM9 = 144,
  XMM10 = 145,
  XMM11 = 146,
  XMM12 = 147,
  XMM13 = 148,
  XMM14 = 149,
  XMM15 = 150,
  R8B = 151,
  R9B = 152,
  R10B = 153,
  R11B = 154,
  R12B = 155,
  R13B = 156,
  R14B = 157,
  R15B = 158,
  R8BH = 159,
  R9BH = 160,
  R10BH = 161,
  R11BH = 162,
  R12BH = 163,
  R13BH = 164,
  R14BH = 165,
  R15BH = 166,
  R8D = 167,
  R9D = 168,
  R10D = 169,
  R11D = 170,
  R12D = 171,
  R13D = 172,
  R14D = 173,
  R15D = 174,
  R8W = 175,
  R9W = 176,
  R10W = 177,
  R11W = 178,
  R12W = 179,
  R13W = 180,
  R14W = 181,
  R15W = 182,
  R8WH = 183,
  R9WH = 184,
  R10WH = 185,
  R11WH = 186,
  R12WH = 187,
  R13WH = 188,
  R14WH = 189,
  R15WH = 190,
  YMM0 = 191,
  YMM1 = 192,
  YMM2 = 193,
  YMM3 = 194,
  YMM4 = 195,
  YMM5 = 196,
  YMM6 = 197,
  YMM7 = 198,
  YMM8 = 199,
  YMM9 = 200,
  YMM10 = 201,
  YMM11 = 202,
  YMM12 = 203,
  YMM13 = 204,
  YMM14 = 205,
  YMM15 = 206,
  K0 = 207,
  K1 = 208,
  K2 = 209,
  K3 = 210,
  K4 = 211,
  K5 = 212,
  K6 = 213,
  K7 = 214,
  XMM16 = 215,
  XMM17 = 216,
  XMM18 = 217,
  XMM19 = 218,
  XMM20 = 219,
  XMM21 = 220,
  XMM22 = 221,
  XMM23 = 222,
  XMM24 = 223,
  XMM25 = 224,
  XMM26 = 225,
  XMM27 = 226,
  XMM28 = 227,
  XMM29 = 228,
  XMM30 = 229,
  XMM31 = 230,
  YMM16 = 231,
  YMM17 = 232,
  YMM18 = 233,
  YMM19 = 234,
  YMM20 = 235,
  YMM21 = 236,
  YMM22 = 237,
  YMM23 = 238,
  YMM24 = 239,
  YMM25 = 240,
  YMM26 = 241,
  YMM27 = 242,
  YMM28 = 243,
  YMM29 = 244,
  YMM30 = 245,
  YMM31 = 246,
  ZMM0 = 247,
  ZMM1 = 248,
  ZMM2 = 249,
  ZMM3 = 250,
  ZMM4 = 251,
  ZMM5 = 252,
  ZMM6 = 253,
  ZMM7 = 254,
  ZMM8 = 255,
  ZMM9 = 256,
  ZMM10 = 257,
  ZMM11 = 258,
  ZMM12 = 259,
  ZMM13 = 260,
  ZMM14 = 261,
  ZMM15 = 262,
  ZMM16 = 263,
  ZMM17 = 264,
  ZMM18 = 265,
  ZMM19 = 266,
  ZMM20 = 267,
  ZMM21 = 268,
  ZMM22 = 269,
  ZMM23 = 270,
  ZMM24 = 271,
  ZMM25 = 272,
  ZMM26 = 273,
  ZMM27 = 274,
  ZMM28 = 275,
  ZMM29 = 276,
  ZMM30 = 277,
  ZMM31 = 278,
  K0_K1 = 279,
  K2_K3 = 280,
  K4_K5 = 281,
  K6_K7 = 282,
  TMMCFG = 283,
  TMM0 = 284,
  TMM1 = 285,
  TMM2 = 286,
  TMM3 = 287,
  TMM4 = 288,
  TMM5 = 289,
  TMM6 = 290,
  TMM7 = 291,
  TMM0_TMM1 = 292,
  TMM2_TMM3 = 293,
  TMM4_TMM5 = 294,
  TMM6_TMM7 = 295,
  R16 = 296,
  R17 = 297,
  R18 = 298,
  R19 = 299,
  R20 = 300,
  R21 = 301,
  R22 = 302,
  R23 = 303,
  R24 = 304,
  R25 = 305,
  R26 = 306,
  R27 = 307,
  R28 = 308,
  R29 = 309,
  R30 = 310,
  R31 = 311,
  R16B = 312,
  R17B = 313,
  R18B = 314,
  R19B = 315,
  R20B = 316,
  R21B = 317,
  R22B = 318,
  R23B = 319,
  R24B = 320,
  R25B = 321,
  R26B = 322,
  R27B = 323,
  R28B = 324,
  R29B = 325,
  R30B = 326,
  R31B = 327,
  R16BH = 328,
  R17BH = 329,
  R18BH = 330,
  R19BH = 331,
  R20BH = 332,
  R21BH = 333,
  R22BH = 334,
  R23BH = 335,
  R24BH = 336,
  R25BH = 337,
  R26BH = 338,
  R27BH = 339,
  R28BH = 340,
  R29BH = 341,
  R30BH = 342,
  R31BH = 343,
  R16D = 344,
  R17D = 345,
  R18D = 346,
  R19D = 347,
  R20D = 348,
  R21D = 349,
  R22D = 350,
  R23D = 351,
  R24D = 352,
  R25D = 353,
  R26D = 354,
  R27D = 355,
  R28D = 356,
  R29D = 357,
  R30D = 358,
  R31D = 359,
  R16W = 360,
  R17W = 361,
  R18W = 362,
  R19W = 363,
  R20W = 364,
  R21W = 365,
  R22W = 366,
  R23W = 367,
  R24W = 368,
  R25W = 369,
  R26W = 370,
  R27W = 371,
  R28W = 372,
  R29W = 373,
  R30W = 374,
  R31W = 375,
  R16WH = 376,
  R17WH = 377,
  R18WH = 378,
  R19WH = 379,
  R20WH = 380,
  R21WH = 381,
  R22WH = 382,
  R23WH = 383,
  R24WH = 384,
  R25WH = 385,
  R26WH = 386,
  R27WH = 387,
  R28WH = 388,
  R29WH = 389,
  R30WH = 390,
  R31WH = 391,
  NUM_TARGET_REGS = 392,
};

}
}
}
#endif
