# Corporate Engagement and Contribution Guide

Along with welcoming contributions from individuals, we also welcome
contributions to JupyterLab from corporations. Over a number of years of working
with a wide range of corporations, we have discovered a set of principles and
practices that enable these collaborations to be healthy, productive, and
sustainable. These principles and practices are detailed here, along with a
mental model that sets the stage.

## Mental Model

We would like to offer the following mental model of open-source projects, set
as a parable. This idea was first introduced by a core Python contributor, Brett
Cannon, on Twitter:

> Pull requests can be like someone trying to give you a puppy you didn't ask
> for; they mean well, but they can forget a puppy is a decade-or-more commitment…

Let's expand on this idea a bit more.

An open-source software project is like a big yard full of puppies. Puppies are
amazing!!! Lots of people stop by to look at the puppies, play with them, take
them on walks, and play fetch. These people are like the users of an open-source
project. A few people, the maintainers, live in the yard with the puppies. The
maintainers feed the puppies, take care of them, wash them, take them to the
vet, get their shots, and keep the yard clean. Just to keep the existing puppies
happy and healthy requires a ton of work and money.

Working in a yard full of puppies is CRAZY! At times, there can be a line around
the block of people wanting to play with the puppies and talk, or complain, to
the maintainers. Sometimes, people show up with more puppies. These are like pull
requests to an open-source project. While the maintainers love puppies and would
love to be able to have more of them for everyone to enjoy, each new puppy has
to be cleaned, fed, trained, taken to the vet, etc.

## Practices and Principles

The following principles and practices should be followed by corporations
wanting to contribute to JupyterLab. These apply to both corporations as a
whole, as well as individual contributors within those corporations.

**Empower individual contributors.** _Encourage your employees to help at the
puppy yard._ In the daily development and design work of the project, everyone
contributes as individuals. Because of this, if your corporation wants to engage
with and contribute to JupyterLab, the primary means will be through allocating,
empowering, and encouraging your individual employees to contribute in an
ongoing manner. Put more bluntly, pay your employees to contribute to Jupyter.

**Make balanced contributions.** _You can help take care of the puppies in a
variety of ways._ We expect all contributors to make balanced contributions that
match their skill level and level of participation. Balanced contributions
include work on new features, fixing bugs, reviewing pull requests, writing
documentation, issue triage, answering users' questions, attending meetings,
helping with releases, and other maintenance tasks. Balanced contributions build
trust with the team and scale the human side of the project in a healthy and
sustainable manner.

**Help review pull requests.** One aspect of this balanced contribution approach
deserves special attention: reviewing pull requests. Submitting pull requests
with new features is an exciting and high-profile way to contribute. However,
reviewing such pull requests is probably the biggest bottleneck in the
development of open-source software. If you want your pull requests to move
through review quickly, proactively review and test the pull requests of other
contributors. Helping us to keep the pull request queue moving quickly
accelerates the work of everyone.

**Use public communications channels whenever possible.** JupyterLab is
developed openly on GitHub. We have weekly video meetings on Wednesday at 9:00
am PT on Zoom (https://zoom.us/j/95228013874?pwd=Ep7HIk8t9JP6VToxt1Wj4P7K5PshC0.1).
Finally, we have a public chat room on Zulip (https://jupyter.zulipchat.com/#narrow/channel/469762-jupyterlab).
As much as possible, all work and communications should take place on these public
channels. We welcome you to join these channels and introduce yourself.
We are willing to have private conversations once in a while, but we
try to minimize their frequency and always summarize them in our
public channels.

**Hire our core maintainers and give them more time to contribute.** _Consider
paying the regulars around here to keep looking after the puppies._ Our core
maintainers love working on Jupyter, but have to balance those contributions
with the reality of paid employment. If you are interested in hiring a core
maintainer, we encourage you to do this in a way that gives them **more** time
to contribute than they currently have. Put this into their employment contract.
This is an incredibly effective way of turbocharging the work of the project and
building trust in the community. Conversely, if you hire a maintainer who wants
to work on the project and give them less time to contribute, you may damage the
project and your organization may find itself alienated from the community.

**Commit to maintaining your contributions.** _Don't abandon puppies here!_
Contributions, especially those for new features, add to the ongoing maintenance
load of the project. New features bring new users to the project, and along with
them, bug reports, ideas, discussions, questions, refactoring, etc. If your
company wants to contribute new features, we ask that you commit to maintaining
those features for a period of at least 2-3 years. This isn't a legal contract,
but we do want you to carefully consider the maintenance of your contributions.
If a new feature is abandoned and we are unable to maintain it, it may be
deprecated or removed.

**Don't surprise us.** _Don't build us a new dog park, when what we really need
is just a couple more kennels._ Before beginning major work, build trust through
balanced contributions, and talk to us about your plans (see public
communication channels above). See if there are existing issues on the topic, or
open a new issue describing the work. There may be other people already working
on it, or the work may be blocked by other factors.

**Be patient.** _Puppies require training, and complex new tricks can take years
and the right motivation to learn._ Open-source software projects offer a unique
path to innovation by bringing together users and contributors with diverse
needs and usage cases. Even if fully resourced, the resulting innovation can be
slow, possibly much slower than your corporation's desired timeline in the short
term. However, in the long-term, sustainable open-source can lead to rapid
growth and development. Help us build a sustainable project through long-term
thinking, strategy, and resource allocation.
