/* heatmap - High performance heatmap creation in C.
 *
 * The MIT License (MIT)
 *
 * Copyright (c) 2013 Lucas Beyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "heatmap.h"
#include "colorschemes/Greens.h"

static const unsigned char discrete_data[] = {
    0, 0, 0, 0, 0, 68, 27, 255, 0, 109, 44, 255, 35, 139, 69, 255, 65, 171, 93, 255, 116, 196, 118, 255, 161, 217, 155, 255, 199, 233, 192, 255, 229, 245, 224, 255, 247, 252, 245, 255
};
static const heatmap_colorscheme_t discrete = { discrete_data, sizeof(discrete_data)/sizeof(discrete_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Greens_discrete = &discrete;

static const unsigned char soft_data[] = {
    0, 0, 0, 0, 0, 68, 26, 0, 0, 68, 27, 7, 0, 68, 27, 14, 0, 68, 27, 22, 0, 69, 27, 29, 0, 69, 27, 37, 0, 69, 27, 44, 0, 70, 27, 52, 0, 70, 28, 59, 0, 70, 28, 67, 0, 71, 28, 74, 0, 71, 28, 82, 0, 71, 28, 89, 0, 72, 28, 97, 0, 72, 28, 104, 0, 72, 28, 112, 0, 72, 29, 119, 0, 73, 29, 127, 0, 73, 29, 134, 0, 73, 29, 141, 0, 74, 29, 149, 0, 74, 29, 156, 0, 74, 29, 164, 0, 75, 30, 171, 0, 75, 30, 179, 0, 75, 30, 186, 0, 76, 30, 194, 0, 76, 30, 201, 0, 76, 30, 209, 0, 77, 30, 216, 0, 77, 30, 224, 0, 77, 31, 231, 0, 77, 31, 239, 0, 78, 31, 246, 0, 78, 31, 254, 0, 78, 31, 255, 0, 79, 31, 255, 0, 79, 31, 255, 0, 79, 32, 255, 0, 80, 32, 255, 0, 80, 32, 255, 0, 80, 32, 255, 0, 81, 32, 255, 0, 81, 32, 255, 0, 81, 32, 255, 0, 82, 32, 255, 0, 82, 33, 255, 0, 82, 33, 255, 0, 82, 33, 255, 0, 83, 33, 255, 0, 83, 33, 255, 0, 83, 33, 255, 0, 84, 33, 255, 0, 84, 34, 255, 0, 84, 34, 255, 0, 85, 34, 255, 0, 85, 34, 255, 0, 85, 34, 255, 0, 86, 34, 255, 0, 86, 34, 255, 0, 86, 34, 255, 0, 87, 35, 255, 0, 87, 35, 255, 0, 87, 35, 255, 0, 88, 35, 255, 0, 88, 35, 255, 0, 88, 35, 255, 0, 89, 35, 255, 0, 89, 36, 255, 0, 89, 36, 255, 0, 90, 36, 255, 0, 90, 36, 255, 0, 90, 36, 255, 0, 90, 36, 255, 0, 91, 36, 255, 0, 91, 36, 255, 0, 91, 37, 255, 0, 92, 37, 255, 0, 92, 37, 255, 0, 92, 37, 255, 0, 93, 37, 255, 0, 93, 37, 255, 0, 93, 37, 255, 0, 94, 38, 255, 0, 94, 38, 255, 0, 94, 38, 255, 0, 95, 38, 255, 0, 95, 38, 255, 0, 95, 38, 255, 0, 96, 38, 255, 0, 96, 38, 255, 0, 96, 39, 255, 0, 97, 39, 255, 0, 97, 39, 255, 0, 97, 39, 255, 0, 98, 39, 255, 0, 98, 39, 255, 0, 98, 39, 255, 0, 99, 40, 255, 0, 99, 40, 255, 0, 99, 40, 255, 0, 100, 40, 255, 0, 100, 40, 255, 0, 100, 40, 255, 0, 101, 40, 255, 0, 101, 40, 255, 0, 101, 41, 255, 0, 102, 41, 255, 0, 102, 41, 255, 0, 102, 41, 255, 0, 103, 41, 255, 0, 103, 41, 255, 0, 103, 41, 255, 0, 104, 42, 255, 0, 104, 42, 255, 0, 104, 42, 255, 0, 105, 42, 255, 0, 105, 42, 255, 0, 105, 42, 255, 0, 106, 42, 255, 0, 106, 42, 255, 0, 106, 43, 255, 0, 107, 43, 255, 0, 107, 43, 255, 0, 107, 43, 255, 0, 108, 43, 255, 0, 108, 43, 255, 0, 108, 43, 255, 0, 109, 43, 255, 0, 109, 44, 255, 0, 109, 44, 255, 0, 109, 44, 255, 1, 109, 44, 255, 1, 110, 44, 255, 1, 110, 45, 255, 2, 110, 45, 255, 2, 110, 45, 255, 2, 111, 45, 255, 3, 111, 45, 255, 3, 111, 46, 255, 3, 111, 46, 255, 4, 111, 46, 255, 4, 112, 46, 255, 4, 112, 46, 255, 5, 112, 47, 255, 5, 112, 47, 255, 5, 113, 47, 255, 6, 113, 47, 255, 6, 113, 47, 255, 6, 113, 48, 255, 7, 114, 48, 255, 7, 114, 48, 255, 7, 114, 48, 255, 8, 114, 48, 255, 8, 114, 48, 255, 8, 115, 49, 255, 9, 115, 49, 255, 9, 115, 49, 255, 9, 115, 49, 255, 10, 116, 49, 255, 10, 116, 50, 255, 10, 116, 50, 255, 11, 116, 50, 255, 11, 117, 50, 255, 11, 117, 50, 255, 12, 117, 51, 255, 12, 117, 51, 255, 12, 118, 51, 255, 13, 118, 51, 255, 13, 118, 51, 255, 13, 118, 52, 255, 14, 118, 52, 255, 14, 119, 52, 255, 14, 119, 52, 255, 15, 119, 52, 255, 15, 119, 53, 255, 15, 120, 53, 255, 16, 120, 53, 255, 16, 120, 53, 255, 16, 120, 53, 255, 16, 121, 54, 255, 17, 121, 54, 255, 17, 121, 54, 255, 17, 121, 54, 255, 17, 121, 54, 255, 18, 122, 54, 255, 18, 122, 55, 255, 18, 122, 55, 255, 19, 122, 55, 255, 19, 123, 55, 255, 19, 123, 55, 255, 19, 123, 56, 255, 20, 123, 56, 255, 20, 124, 56, 255, 20, 124, 56, 255, 20, 124, 56, 255, 21, 124, 57, 255, 21, 125, 57, 255, 21, 125, 57, 255, 21, 125, 57, 255, 22, 125, 57, 255, 22, 125, 58, 255, 22, 126, 58, 255, 22, 126, 58, 255, 23, 126, 58, 255, 23, 126, 58, 255, 23, 127, 59, 255, 23, 127, 59, 255, 24, 127, 59, 255, 24, 127, 59, 255, 24, 128, 59, 255, 24, 128, 60, 255, 25, 128, 60, 255, 25, 128, 60, 255, 25, 129, 60, 255, 25, 129, 60, 255, 26, 129, 61, 255, 26, 129, 61, 255, 26, 129, 61, 255, 26, 130, 61, 255, 27, 130, 61, 255, 27, 130, 62, 255, 27, 130, 62, 255, 27, 131, 62, 255, 27, 131, 62, 255, 28, 131, 62, 255, 28, 131, 63, 255, 28, 132, 63, 255, 28, 132, 63, 255, 29, 132, 63, 255, 29, 132, 63, 255, 29, 133, 64, 255, 29, 133, 64, 255, 29, 133, 64, 255, 30, 133, 64, 255, 30, 133, 64, 255, 30, 134, 65, 255, 30, 134, 65, 255, 31, 134, 65, 255, 31, 134, 65, 255, 31, 135, 65, 255, 31, 135, 66, 255, 31, 135, 66, 255, 32, 135, 66, 255, 32, 136, 66, 255, 32, 136, 66, 255, 32, 136, 67, 255, 33, 136, 67, 255, 33, 137, 67, 255, 33, 137, 67, 255, 33, 137, 67, 255, 33, 137, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 35, 139, 68, 255, 35, 139, 69, 255, 35, 139, 69, 255, 35, 139, 69, 255, 36, 139, 69, 255, 36, 140, 69, 255, 36, 140, 70, 255, 36, 140, 70, 255, 37, 140, 70, 255, 37, 141, 70, 255, 37, 141, 70, 255, 37, 141, 71, 255, 38, 141, 71, 255, 38, 142, 71, 255, 38, 142, 71, 255, 38, 142, 71, 255, 39, 142, 71, 255, 39, 143, 72, 255, 39, 143, 72, 255, 39, 143, 72, 255, 40, 143, 72, 255, 40, 144, 72, 255, 40, 144, 73, 255, 40, 144, 73, 255, 41, 144, 73, 255, 41, 145, 73, 255, 41, 145, 73, 255, 41, 145, 73, 255, 41, 145, 74, 255, 42, 146, 74, 255, 42, 146, 74, 255, 42, 146, 74, 255, 42, 146, 74, 255, 43, 147, 75, 255, 43, 147, 75, 255, 43, 147, 75, 255, 43, 147, 75, 255, 44, 148, 75, 255, 44, 148, 76, 255, 44, 148, 76, 255, 44, 148, 76, 255, 45, 149, 76, 255, 45, 149, 76, 255, 45, 149, 76, 255, 45, 149, 77, 255, 46, 150, 77, 255, 46, 150, 77, 255, 46, 150, 77, 255, 46, 150, 77, 255, 46, 151, 78, 255, 47, 151, 78, 255, 47, 151, 78, 255, 47, 151, 78, 255, 47, 152, 78, 255, 48, 152, 79, 255, 48, 152, 79, 255, 48, 152, 79, 255, 48, 153, 79, 255, 49, 153, 79, 255, 49, 153, 79, 255, 49, 153, 80, 255, 49, 154, 80, 255, 50, 154, 80, 255, 50, 154, 80, 255, 50, 154, 80, 255, 50, 155, 81, 255, 50, 155, 81, 255, 51, 155, 81, 255, 51, 155, 81, 255, 51, 156, 81, 255, 51, 156, 82, 255, 52, 156, 82, 255, 52, 156, 82, 255, 52, 157, 82, 255, 52, 157, 82, 255, 53, 157, 82, 255, 53, 157, 83, 255, 53, 158, 83, 255, 53, 158, 83, 255, 53, 158, 83, 255, 54, 158, 83, 255, 54, 159, 84, 255, 54, 159, 84, 255, 54, 159, 84, 255, 55, 159, 84, 255, 55, 160, 84, 255, 55, 160, 85, 255, 55, 160, 85, 255, 56, 160, 85, 255, 56, 161, 85, 255, 56, 161, 85, 255, 56, 161, 85, 255, 56, 161, 86, 255, 57, 162, 86, 255, 57, 162, 86, 255, 57, 162, 86, 255, 57, 162, 86, 255, 58, 163, 87, 255, 58, 163, 87, 255, 58, 163, 87, 255, 58, 163, 87, 255, 58, 164, 87, 255, 59, 164, 88, 255, 59, 164, 88, 255, 59, 164, 88, 255, 59, 165, 88, 255, 60, 165, 88, 255, 60, 165, 88, 255, 60, 165, 89, 255, 60, 166, 89, 255, 60, 166, 89, 255, 61, 166, 89, 255, 61, 166, 89, 255, 61, 167, 90, 255, 61, 167, 90, 255, 62, 167, 90, 255, 62, 167, 90, 255, 62, 168, 90, 255, 62, 168, 91, 255, 62, 168, 91, 255, 63, 168, 91, 255, 63, 169, 91, 255, 63, 169, 91, 255, 63, 169, 92, 255, 64, 169, 92, 255, 64, 170, 92, 255, 64, 170, 92, 255, 64, 170, 92, 255, 65, 171, 92, 255, 65, 171, 93, 255, 65, 171, 93, 255, 66, 171, 93, 255, 66, 171, 93, 255, 67, 171, 93, 255, 67, 172, 94, 255, 68, 172, 94, 255, 68, 172, 94, 255, 69, 172, 94, 255, 69, 172, 94, 255, 70, 173, 95, 255, 70, 173, 95, 255, 70, 173, 95, 255, 71, 173, 95, 255, 71, 173, 95, 255, 72, 174, 95, 255, 72, 174, 96, 255, 73, 174, 96, 255, 73, 174, 96, 255, 74, 174, 96, 255, 74, 175, 96, 255, 74, 175, 97, 255, 75, 175, 97, 255, 75, 175, 97, 255, 76, 175, 97, 255, 76, 176, 97, 255, 77, 176, 98, 255, 77, 176, 98, 255, 77, 176, 98, 255, 78, 176, 98, 255, 78, 177, 98, 255, 79, 177, 99, 255, 79, 177, 99, 255, 80, 177, 99, 255, 80, 177, 99, 255, 80, 178, 99, 255, 81, 178, 99, 255, 81, 178, 100, 255, 82, 178, 100, 255, 82, 178, 100, 255, 82, 178, 100, 255, 83, 179, 100, 255, 83, 179, 101, 255, 84, 179, 101, 255, 84, 179, 101, 255, 84, 179, 101, 255, 85, 180, 101, 255, 85, 180, 102, 255, 86, 180, 102, 255, 86, 180, 102, 255, 86, 180, 102, 255, 87, 181, 102, 255, 87, 181, 103, 255, 88, 181, 103, 255, 88, 181, 103, 255, 88, 181, 103, 255, 89, 182, 103, 255, 89, 182, 104, 255, 90, 182, 104, 255, 90, 182, 104, 255, 90, 182, 104, 255, 91, 183, 104, 255, 91, 183, 104, 255, 92, 183, 105, 255, 92, 183, 105, 255, 92, 183, 105, 255, 93, 184, 105, 255, 93, 184, 105, 255, 94, 184, 106, 255, 94, 184, 106, 255, 94, 184, 106, 255, 95, 185, 106, 255, 95, 185, 106, 255, 96, 185, 107, 255, 96, 185, 107, 255, 96, 185, 107, 255, 97, 186, 107, 255, 97, 186, 107, 255, 97, 186, 108, 255, 98, 186, 108, 255, 98, 186, 108, 255, 99, 186, 108, 255, 99, 187, 108, 255, 99, 187, 109, 255, 100, 187, 109, 255, 100, 187, 109, 255, 100, 187, 109, 255, 101, 188, 109, 255, 101, 188, 110, 255, 102, 188, 110, 255, 102, 188, 110, 255, 102, 188, 110, 255, 103, 189, 110, 255, 103, 189, 111, 255, 103, 189, 111, 255, 104, 189, 111, 255, 104, 189, 111, 255, 105, 190, 111, 255, 105, 190, 112, 255, 105, 190, 112, 255, 106, 190, 112, 255, 106, 190, 112, 255, 106, 191, 112, 255, 107, 191, 113, 255, 107, 191, 113, 255, 108, 191, 113, 255, 108, 191, 113, 255, 108, 192, 113, 255, 109, 192, 114, 255, 109, 192, 114, 255, 109, 192, 114, 255, 110, 192, 114, 255, 110, 193, 114, 255, 110, 193, 115, 255, 111, 193, 115, 255, 111, 193, 115, 255, 112, 193, 115, 255, 112, 194, 115, 255, 112, 194, 116, 255, 113, 194, 116, 255, 113, 194, 116, 255, 113, 194, 116, 255, 114, 195, 116, 255, 114, 195, 117, 255, 114, 195, 117, 255, 115, 195, 117, 255, 115, 195, 117, 255, 115, 196, 117, 255, 116, 196, 118, 255, 116, 196, 118, 255, 117, 196, 118, 255, 117, 196, 119, 255, 117, 196, 119, 255, 118, 196, 119, 255, 118, 197, 119, 255, 118, 197, 120, 255, 119, 197, 120, 255, 119, 197, 120, 255, 120, 197, 121, 255, 120, 197, 121, 255, 120, 198, 121, 255, 121, 198, 121, 255, 121, 198, 122, 255, 121, 198, 122, 255, 122, 198, 122, 255, 122, 198, 123, 255, 123, 199, 123, 255, 123, 199, 123, 255, 123, 199, 123, 255, 124, 199, 124, 255, 124, 199, 124, 255, 124, 199, 124, 255, 125, 200, 125, 255, 125, 200, 125, 255, 125, 200, 125, 255, 126, 200, 125, 255, 126, 200, 126, 255, 127, 200, 126, 255, 127, 201, 126, 255, 127, 201, 127, 255, 128, 201, 127, 255, 128, 201, 127, 255, 128, 201, 127, 255, 129, 201, 128, 255, 129, 202, 128, 255, 129, 202, 128, 255, 130, 202, 129, 255, 130, 202, 129, 255, 130, 202, 129, 255, 131, 202, 129, 255, 131, 203, 130, 255, 132, 203, 130, 255, 132, 203, 130, 255, 132, 203, 131, 255, 133, 203, 131, 255, 133, 203, 131, 255, 133, 204, 131, 255, 134, 204, 132, 255, 134, 204, 132, 255, 134, 204, 132, 255, 135, 204, 133, 255, 135, 204, 133, 255, 135, 205, 133, 255, 136, 205, 133, 255, 136, 205, 134, 255, 137, 205, 134, 255, 137, 205, 134, 255, 137, 205, 135, 255, 138, 206, 135, 255, 138, 206, 135, 255, 138, 206, 135, 255, 139, 206, 136, 255, 139, 206, 136, 255, 139, 206, 136, 255, 140, 206, 137, 255, 140, 207, 137, 255, 140, 207, 137, 255, 141, 207, 137, 255, 141, 207, 138, 255, 141, 207, 138, 255, 142, 207, 138, 255, 142, 208, 139, 255, 142, 208, 139, 255, 143, 208, 139, 255, 143, 208, 140, 255, 143, 208, 140, 255, 144, 208, 140, 255, 144, 209, 140, 255, 145, 209, 141, 255, 145, 209, 141, 255, 145, 209, 141, 255, 146, 209, 142, 255, 146, 209, 142, 255, 146, 210, 142, 255, 147, 210, 142, 255, 147, 210, 143, 255, 147, 210, 143, 255, 148, 210, 143, 255, 148, 210, 144, 255, 148, 211, 144, 255, 149, 211, 144, 255, 149, 211, 144, 255, 149, 211, 145, 255, 150, 211, 145, 255, 150, 211, 145, 255, 150, 212, 146, 255, 151, 212, 146, 255, 151, 212, 146, 255, 151, 212, 147, 255, 152, 212, 147, 255, 152, 212, 147, 255, 152, 213, 147, 255, 153, 213, 148, 255, 153, 213, 148, 255, 153, 213, 148, 255, 154, 213, 149, 255, 154, 213, 149, 255, 154, 214, 149, 255, 155, 214, 149, 255, 155, 214, 150, 255, 155, 214, 150, 255, 156, 214, 150, 255, 156, 214, 151, 255, 156, 215, 151, 255, 157, 215, 151, 255, 157, 215, 152, 255, 157, 215, 152, 255, 158, 215, 152, 255, 158, 215, 152, 255, 158, 216, 153, 255, 159, 216, 153, 255, 159, 216, 153, 255, 159, 216, 154, 255, 160, 216, 154, 255, 160, 216, 154, 255, 160, 217, 154, 255, 161, 217, 155, 255, 161, 217, 155, 255, 161, 217, 155, 255, 162, 217, 156, 255, 162, 217, 156, 255, 162, 217, 156, 255, 163, 217, 156, 255, 163, 218, 157, 255, 163, 218, 157, 255, 164, 218, 157, 255, 164, 218, 158, 255, 164, 218, 158, 255, 164, 218, 158, 255, 165, 218, 158, 255, 165, 218, 159, 255, 165, 219, 159, 255, 166, 219, 159, 255, 166, 219, 160, 255, 166, 219, 160, 255, 167, 219, 160, 255, 167, 219, 160, 255, 167, 219, 161, 255, 168, 219, 161, 255, 168, 220, 161, 255, 168, 220, 162, 255, 168, 220, 162, 255, 169, 220, 162, 255, 169, 220, 162, 255, 169, 220, 163, 255, 170, 220, 163, 255, 170, 220, 163, 255, 170, 221, 164, 255, 171, 221, 164, 255, 171, 221, 164, 255, 171, 221, 164, 255, 171, 221, 165, 255, 172, 221, 165, 255, 172, 221, 165, 255, 172, 221, 166, 255, 173, 222, 166, 255, 173, 222, 166, 255, 173, 222, 166, 255, 174, 222, 167, 255, 174, 222, 167, 255, 174, 222, 167, 255, 174, 222, 168, 255, 175, 222, 168, 255, 175, 223, 168, 255, 175, 223, 168, 255, 176, 223, 169, 255, 176, 223, 169, 255, 176, 223, 169, 255, 177, 223, 170, 255, 177, 223, 170, 255, 177, 223, 170, 255, 177, 224, 170, 255, 178, 224, 171, 255, 178, 224, 171, 255, 178, 224, 171, 255, 179, 224, 172, 255, 179, 224, 172, 255, 179, 224, 172, 255, 180, 224, 173, 255, 180, 225, 173, 255, 180, 225, 173, 255, 180, 225, 173, 255, 181, 225, 174, 255, 181, 225, 174, 255, 181, 225, 174, 255, 182, 225, 175, 255, 182, 225, 175, 255, 182, 226, 175, 255, 182, 226, 175, 255, 183, 226, 176, 255, 183, 226, 176, 255, 183, 226, 176, 255, 184, 226, 177, 255, 184, 226, 177, 255, 184, 226, 177, 255, 185, 227, 177, 255, 185, 227, 178, 255, 185, 227, 178, 255, 185, 227, 178, 255, 186, 227, 179, 255, 186, 227, 179, 255, 186, 227, 179, 255, 187, 227, 179, 255, 187, 228, 180, 255, 187, 228, 180, 255, 187, 228, 180, 255, 188, 228, 181, 255, 188, 228, 181, 255, 188, 228, 181, 255, 189, 228, 182, 255, 189, 228, 182, 255, 189, 229, 182, 255, 190, 229, 182, 255, 190, 229, 183, 255, 190, 229, 183, 255, 190, 229, 183, 255, 191, 229, 184, 255, 191, 229, 184, 255, 191, 229, 184, 255, 192, 230, 184, 255, 192, 230, 185, 255, 192, 230, 185, 255, 192, 230, 185, 255, 193, 230, 186, 255, 193, 230, 186, 255, 193, 230, 186, 255, 194, 230, 186, 255, 194, 231, 187, 255, 194, 231, 187, 255, 194, 231, 187, 255, 195, 231, 188, 255, 195, 231, 188, 255, 195, 231, 188, 255, 196, 231, 189, 255, 196, 231, 189, 255, 196, 232, 189, 255, 196, 232, 189, 255, 197, 232, 190, 255, 197, 232, 190, 255, 197, 232, 190, 255, 198, 232, 191, 255, 198, 232, 191, 255, 198, 232, 191, 255, 198, 233, 191, 255, 199, 233, 192, 255, 199, 233, 192, 255, 199, 233, 192, 255, 199, 233, 192, 255, 200, 233, 193, 255, 200, 233, 193, 255, 200, 233, 193, 255, 200, 233, 193, 255, 201, 233, 194, 255, 201, 233, 194, 255, 201, 234, 194, 255, 201, 234, 194, 255, 202, 234, 195, 255, 202, 234, 195, 255, 202, 234, 195, 255, 202, 234, 195, 255, 203, 234, 196, 255, 203, 234, 196, 255, 203, 234, 196, 255, 203, 234, 196, 255, 204, 234, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 199, 255, 206, 235, 199, 255, 206, 235, 199, 255, 206, 236, 199, 255, 206, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 208, 236, 202, 255, 209, 236, 202, 255, 209, 237, 202, 255, 209, 237, 202, 255, 209, 237, 203, 255, 209, 237, 203, 255, 210, 237, 203, 255, 210, 237, 203, 255, 210, 237, 204, 255, 210, 237, 204, 255, 211, 237, 204, 255, 211, 237, 204, 255, 211, 237, 205, 255, 211, 238, 205, 255, 212, 238, 205, 255, 212, 238, 205, 255, 212, 238, 206, 255, 212, 238, 206, 255, 213, 238, 206, 255, 213, 238, 206, 255, 213, 238, 207, 255, 213, 238, 207, 255, 213, 238, 207, 255, 214, 238, 207, 255, 214, 239, 208, 255, 214, 239, 208, 255, 214, 239, 208, 255, 215, 239, 208, 255, 215, 239, 209, 255, 215, 239, 209, 255, 215, 239, 209, 255, 216, 239, 209, 255, 216, 239, 210, 255, 216, 239, 210, 255, 216, 240, 210, 255, 217, 240, 210, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 219, 240, 213, 255, 219, 241, 213, 255, 219, 241, 213, 255, 219, 241, 213, 255, 220, 241, 214, 255, 220, 241, 214, 255, 220, 241, 214, 255, 220, 241, 214, 255, 220, 241, 215, 255, 221, 241, 215, 255, 221, 241, 215, 255, 221, 241, 215, 255, 221, 242, 216, 255, 222, 242, 216, 255, 222, 242, 216, 255, 222, 242, 216, 255, 222, 242, 217, 255, 223, 242, 217, 255, 223, 242, 217, 255, 223, 242, 217, 255, 223, 242, 218, 255, 223, 242, 218, 255, 224, 243, 218, 255, 224, 243, 218, 255, 224, 243, 219, 255, 224, 243, 219, 255, 225, 243, 219, 255, 225, 243, 219, 255, 225, 243, 220, 255, 225, 243, 220, 255, 226, 243, 220, 255, 226, 243, 220, 255, 226, 243, 221, 255, 226, 244, 221, 255, 226, 244, 221, 255, 227, 244, 221, 255, 227, 244, 222, 255, 227, 244, 222, 255, 227, 244, 222, 255, 228, 244, 222, 255, 228, 244, 223, 255, 228, 244, 223, 255, 228, 244, 223, 255, 228, 245, 223, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 224, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 226, 255, 231, 245, 226, 255, 231, 245, 226, 255, 231, 245, 226, 255, 231, 245, 226, 255, 231, 245, 226, 255, 231, 246, 227, 255, 231, 246, 227, 255, 232, 246, 227, 255, 232, 246, 227, 255, 232, 246, 227, 255, 232, 246, 227, 255, 232, 246, 228, 255, 232, 246, 228, 255, 232, 246, 228, 255, 233, 246, 228, 255, 233, 246, 228, 255, 233, 246, 228, 255, 233, 246, 229, 255, 233, 246, 229, 255, 233, 246, 229, 255, 233, 246, 229, 255, 234, 246, 229, 255, 234, 246, 229, 255, 234, 247, 229, 255, 234, 247, 230, 255, 234, 247, 230, 255, 234, 247, 230, 255, 234, 247, 230, 255, 234, 247, 230, 255, 235, 247, 230, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 236, 247, 232, 255, 236, 247, 232, 255, 236, 247, 232, 255, 236, 247, 232, 255, 236, 247, 232, 255, 236, 248, 232, 255, 236, 248, 233, 255, 237, 248, 233, 255, 237, 248, 233, 255, 237, 248, 233, 255, 237, 248, 233, 255, 237, 248, 233, 255, 237, 248, 234, 255, 237, 248, 234, 255, 238, 248, 234, 255, 238, 248, 234, 255, 238, 248, 234, 255, 238, 248, 234, 255, 238, 248, 235, 255, 238, 248, 235, 255, 238, 248, 235, 255, 239, 248, 235, 255, 239, 248, 235, 255, 239, 248, 235, 255, 239, 249, 236, 255, 239, 249, 236, 255, 239, 249, 236, 255, 239, 249, 236, 255, 240, 249, 236, 255, 240, 249, 236, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 241, 249, 237, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 240, 255, 242, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 241, 255, 243, 250, 241, 255, 243, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 246, 251, 243, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255
};
static const heatmap_colorscheme_t soft = { soft_data, sizeof(soft_data)/sizeof(soft_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Greens_soft = &soft;

static const unsigned char mixed_data[] = {
    0, 0, 0, 0, 0, 68, 26, 0, 0, 68, 27, 7, 0, 68, 27, 14, 0, 68, 27, 22, 0, 68, 27, 29, 0, 69, 27, 37, 0, 69, 27, 44, 0, 69, 27, 52, 0, 69, 27, 59, 0, 70, 27, 67, 0, 70, 28, 74, 0, 70, 28, 82, 0, 70, 28, 89, 0, 71, 28, 97, 0, 71, 28, 104, 0, 71, 28, 112, 0, 71, 28, 119, 0, 72, 28, 127, 0, 72, 28, 134, 0, 72, 29, 141, 0, 72, 29, 149, 0, 73, 29, 156, 0, 73, 29, 164, 0, 73, 29, 171, 0, 73, 29, 179, 0, 74, 29, 186, 0, 74, 29, 194, 0, 74, 29, 201, 0, 74, 29, 209, 0, 75, 30, 216, 0, 75, 30, 224, 0, 75, 30, 231, 0, 75, 30, 239, 0, 76, 30, 246, 0, 76, 30, 254, 0, 76, 30, 255, 0, 76, 30, 255, 0, 77, 30, 255, 0, 77, 31, 255, 0, 77, 31, 255, 0, 77, 31, 255, 0, 78, 31, 255, 0, 78, 31, 255, 0, 78, 31, 255, 0, 78, 31, 255, 0, 79, 31, 255, 0, 79, 31, 255, 0, 79, 31, 255, 0, 79, 32, 255, 0, 80, 32, 255, 0, 80, 32, 255, 0, 80, 32, 255, 0, 81, 32, 255, 0, 81, 32, 255, 0, 81, 32, 255, 0, 81, 32, 255, 0, 82, 32, 255, 0, 82, 33, 255, 0, 82, 33, 255, 0, 82, 33, 255, 0, 83, 33, 255, 0, 83, 33, 255, 0, 83, 33, 255, 0, 83, 33, 255, 0, 92, 37, 255, 0, 92, 37, 255, 0, 92, 37, 255, 0, 93, 37, 255, 0, 93, 37, 255, 0, 93, 37, 255, 0, 93, 37, 255, 0, 94, 37, 255, 0, 94, 38, 255, 0, 94, 38, 255, 0, 94, 38, 255, 0, 95, 38, 255, 0, 95, 38, 255, 0, 95, 38, 255, 0, 95, 38, 255, 0, 96, 38, 255, 0, 96, 38, 255, 0, 96, 39, 255, 0, 96, 39, 255, 0, 97, 39, 255, 0, 97, 39, 255, 0, 97, 39, 255, 0, 97, 39, 255, 0, 98, 39, 255, 0, 98, 39, 255, 0, 98, 39, 255, 0, 99, 39, 255, 0, 99, 40, 255, 0, 99, 40, 255, 0, 99, 40, 255, 0, 100, 40, 255, 0, 100, 40, 255, 0, 100, 40, 255, 0, 100, 40, 255, 0, 101, 40, 255, 0, 101, 40, 255, 0, 101, 41, 255, 0, 101, 41, 255, 0, 102, 41, 255, 0, 102, 41, 255, 0, 102, 41, 255, 0, 102, 41, 255, 0, 103, 41, 255, 0, 103, 41, 255, 0, 103, 41, 255, 0, 103, 41, 255, 0, 104, 42, 255, 0, 104, 42, 255, 0, 104, 42, 255, 0, 105, 42, 255, 0, 105, 42, 255, 0, 105, 42, 255, 0, 105, 42, 255, 0, 106, 42, 255, 0, 106, 42, 255, 0, 106, 43, 255, 0, 106, 43, 255, 0, 107, 43, 255, 0, 107, 43, 255, 0, 107, 43, 255, 0, 107, 43, 255, 0, 108, 43, 255, 0, 108, 43, 255, 0, 108, 43, 255, 0, 109, 43, 255, 0, 109, 44, 255, 0, 109, 44, 255, 0, 109, 44, 255, 0, 109, 44, 255, 1, 109, 44, 255, 1, 110, 44, 255, 1, 110, 45, 255, 1, 110, 45, 255, 2, 110, 45, 255, 2, 110, 45, 255, 2, 111, 45, 255, 2, 111, 45, 255, 3, 111, 45, 255, 3, 111, 46, 255, 3, 111, 46, 255, 4, 111, 46, 255, 4, 112, 46, 255, 4, 112, 46, 255, 4, 112, 46, 255, 5, 112, 47, 255, 5, 112, 47, 255, 5, 113, 47, 255, 5, 113, 47, 255, 6, 113, 47, 255, 6, 113, 47, 255, 6, 113, 47, 255, 7, 113, 48, 255, 7, 114, 48, 255, 7, 114, 48, 255, 7, 114, 48, 255, 8, 114, 48, 255, 8, 114, 48, 255, 8, 115, 49, 255, 9, 115, 49, 255, 9, 115, 49, 255, 9, 115, 49, 255, 9, 115, 49, 255, 10, 116, 49, 255, 10, 116, 49, 255, 10, 116, 50, 255, 10, 116, 50, 255, 11, 116, 50, 255, 11, 116, 50, 255, 11, 117, 50, 255, 11, 117, 50, 255, 12, 117, 51, 255, 12, 117, 51, 255, 12, 117, 51, 255, 12, 118, 51, 255, 13, 118, 51, 255, 13, 118, 51, 255, 13, 118, 52, 255, 13, 118, 52, 255, 13, 119, 52, 255, 14, 119, 52, 255, 14, 119, 52, 255, 14, 119, 52, 255, 14, 119, 52, 255, 15, 119, 53, 255, 15, 120, 53, 255, 15, 120, 53, 255, 15, 120, 53, 255, 15, 120, 53, 255, 23, 126, 58, 255, 23, 127, 59, 255, 23, 127, 59, 255, 23, 127, 59, 255, 23, 127, 59, 255, 24, 127, 59, 255, 24, 128, 59, 255, 24, 128, 59, 255, 24, 128, 60, 255, 24, 128, 60, 255, 25, 128, 60, 255, 25, 128, 60, 255, 25, 129, 60, 255, 25, 129, 60, 255, 25, 129, 61, 255, 26, 129, 61, 255, 26, 129, 61, 255, 26, 130, 61, 255, 26, 130, 61, 255, 26, 130, 61, 255, 27, 130, 62, 255, 27, 130, 62, 255, 27, 131, 62, 255, 27, 131, 62, 255, 27, 131, 62, 255, 28, 131, 62, 255, 28, 131, 62, 255, 28, 131, 63, 255, 28, 132, 63, 255, 28, 132, 63, 255, 28, 132, 63, 255, 29, 132, 63, 255, 29, 132, 63, 255, 29, 133, 64, 255, 29, 133, 64, 255, 29, 133, 64, 255, 30, 133, 64, 255, 30, 133, 64, 255, 30, 134, 64, 255, 30, 134, 65, 255, 30, 134, 65, 255, 30, 134, 65, 255, 31, 134, 65, 255, 31, 134, 65, 255, 31, 135, 65, 255, 31, 135, 65, 255, 31, 135, 66, 255, 32, 135, 66, 255, 32, 135, 66, 255, 32, 136, 66, 255, 32, 136, 66, 255, 32, 136, 66, 255, 32, 136, 67, 255, 33, 136, 67, 255, 33, 137, 67, 255, 33, 137, 67, 255, 33, 137, 67, 255, 33, 137, 67, 255, 33, 137, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 34, 138, 68, 255, 35, 139, 68, 255, 35, 139, 69, 255, 35, 139, 69, 255, 35, 139, 69, 255, 35, 139, 69, 255, 36, 139, 69, 255, 36, 140, 69, 255, 36, 140, 70, 255, 36, 140, 70, 255, 36, 140, 70, 255, 37, 140, 70, 255, 37, 141, 70, 255, 37, 141, 70, 255, 37, 141, 70, 255, 37, 141, 71, 255, 38, 141, 71, 255, 38, 142, 71, 255, 38, 142, 71, 255, 38, 142, 71, 255, 38, 142, 71, 255, 39, 142, 71, 255, 39, 143, 72, 255, 39, 143, 72, 255, 39, 143, 72, 255, 39, 143, 72, 255, 39, 143, 72, 255, 40, 144, 72, 255, 40, 144, 72, 255, 40, 144, 73, 255, 40, 144, 73, 255, 40, 144, 73, 255, 41, 145, 73, 255, 41, 145, 73, 255, 41, 145, 73, 255, 41, 145, 74, 255, 41, 145, 74, 255, 42, 146, 74, 255, 42, 146, 74, 255, 42, 146, 74, 255, 42, 146, 74, 255, 42, 146, 74, 255, 43, 147, 75, 255, 43, 147, 75, 255, 43, 147, 75, 255, 43, 147, 75, 255, 43, 147, 75, 255, 44, 148, 75, 255, 44, 148, 75, 255, 44, 148, 76, 255, 44, 148, 76, 255, 44, 148, 76, 255, 44, 149, 76, 255, 45, 149, 76, 255, 45, 149, 76, 255, 45, 149, 77, 255, 45, 149, 77, 255, 45, 150, 77, 255, 46, 150, 77, 255, 46, 150, 77, 255, 46, 150, 77, 255, 46, 150, 77, 255, 46, 151, 78, 255, 47, 151, 78, 255, 47, 151, 78, 255, 53, 158, 83, 255, 53, 158, 83, 255, 53, 158, 83, 255, 53, 158, 83, 255, 54, 158, 83, 255, 54, 159, 84, 255, 54, 159, 84, 255, 54, 159, 84, 255, 54, 159, 84, 255, 55, 159, 84, 255, 55, 160, 84, 255, 55, 160, 84, 255, 55, 160, 85, 255, 55, 160, 85, 255, 55, 160, 85, 255, 56, 161, 85, 255, 56, 161, 85, 255, 56, 161, 85, 255, 56, 161, 86, 255, 56, 161, 86, 255, 57, 162, 86, 255, 57, 162, 86, 255, 57, 162, 86, 255, 57, 162, 86, 255, 57, 162, 86, 255, 57, 163, 87, 255, 58, 163, 87, 255, 58, 163, 87, 255, 58, 163, 87, 255, 58, 163, 87, 255, 58, 164, 87, 255, 59, 164, 87, 255, 59, 164, 88, 255, 59, 164, 88, 255, 59, 164, 88, 255, 59, 165, 88, 255, 59, 165, 88, 255, 60, 165, 88, 255, 60, 165, 89, 255, 60, 165, 89, 255, 60, 166, 89, 255, 60, 166, 89, 255, 61, 166, 89, 255, 61, 166, 89, 255, 61, 166, 89, 255, 61, 167, 90, 255, 61, 167, 90, 255, 61, 167, 90, 255, 62, 167, 90, 255, 62, 167, 90, 255, 62, 168, 90, 255, 62, 168, 91, 255, 62, 168, 91, 255, 63, 168, 91, 255, 63, 168, 91, 255, 63, 169, 91, 255, 63, 169, 91, 255, 63, 169, 91, 255, 63, 169, 92, 255, 64, 169, 92, 255, 64, 170, 92, 255, 64, 170, 92, 255, 64, 170, 92, 255, 64, 170, 92, 255, 65, 171, 92, 255, 65, 171, 93, 255, 65, 171, 93, 255, 66, 171, 93, 255, 66, 171, 93, 255, 66, 171, 93, 255, 67, 171, 93, 255, 67, 172, 94, 255, 67, 172, 94, 255, 68, 172, 94, 255, 68, 172, 94, 255, 69, 172, 94, 255, 69, 172, 94, 255, 69, 173, 94, 255, 70, 173, 95, 255, 70, 173, 95, 255, 70, 173, 95, 255, 71, 173, 95, 255, 71, 173, 95, 255, 71, 173, 95, 255, 72, 174, 95, 255, 72, 174, 96, 255, 72, 174, 96, 255, 73, 174, 96, 255, 73, 174, 96, 255, 73, 174, 96, 255, 74, 175, 96, 255, 74, 175, 97, 255, 74, 175, 97, 255, 75, 175, 97, 255, 75, 175, 97, 255, 76, 175, 97, 255, 76, 175, 97, 255, 76, 176, 97, 255, 77, 176, 98, 255, 77, 176, 98, 255, 77, 176, 98, 255, 78, 176, 98, 255, 78, 176, 98, 255, 78, 177, 98, 255, 79, 177, 99, 255, 79, 177, 99, 255, 79, 177, 99, 255, 79, 177, 99, 255, 80, 177, 99, 255, 80, 178, 99, 255, 80, 178, 99, 255, 81, 178, 100, 255, 81, 178, 100, 255, 81, 178, 100, 255, 82, 178, 100, 255, 82, 178, 100, 255, 82, 179, 100, 255, 83, 179, 101, 255, 83, 179, 101, 255, 83, 179, 101, 255, 84, 179, 101, 255, 84, 179, 101, 255, 84, 180, 101, 255, 85, 180, 101, 255, 85, 180, 102, 255, 85, 180, 102, 255, 86, 180, 102, 255, 86, 180, 102, 255, 96, 185, 107, 255, 97, 186, 107, 255, 97, 186, 108, 255, 97, 186, 108, 255, 98, 186, 108, 255, 98, 186, 108, 255, 98, 186, 108, 255, 99, 187, 108, 255, 99, 187, 108, 255, 99, 187, 109, 255, 100, 187, 109, 255, 100, 187, 109, 255, 100, 187, 109, 255, 100, 188, 109, 255, 101, 188, 109, 255, 101, 188, 110, 255, 101, 188, 110, 255, 102, 188, 110, 255, 102, 188, 110, 255, 102, 188, 110, 255, 103, 189, 110, 255, 103, 189, 111, 255, 103, 189, 111, 255, 103, 189, 111, 255, 104, 189, 111, 255, 104, 189, 111, 255, 104, 190, 111, 255, 105, 190, 112, 255, 105, 190, 112, 255, 105, 190, 112, 255, 106, 190, 112, 255, 106, 190, 112, 255, 106, 190, 112, 255, 106, 191, 112, 255, 107, 191, 113, 255, 107, 191, 113, 255, 107, 191, 113, 255, 108, 191, 113, 255, 108, 191, 113, 255, 108, 192, 113, 255, 109, 192, 114, 255, 109, 192, 114, 255, 109, 192, 114, 255, 109, 192, 114, 255, 110, 192, 114, 255, 110, 193, 114, 255, 110, 193, 115, 255, 111, 193, 115, 255, 111, 193, 115, 255, 111, 193, 115, 255, 111, 193, 115, 255, 112, 193, 115, 255, 112, 194, 116, 255, 112, 194, 116, 255, 113, 194, 116, 255, 113, 194, 116, 255, 113, 194, 116, 255, 113, 194, 116, 255, 114, 195, 117, 255, 114, 195, 117, 255, 114, 195, 117, 255, 115, 195, 117, 255, 115, 195, 117, 255, 115, 195, 117, 255, 115, 196, 117, 255, 116, 196, 118, 255, 116, 196, 118, 255, 116, 196, 118, 255, 117, 196, 118, 255, 117, 196, 119, 255, 117, 196, 119, 255, 118, 196, 119, 255, 118, 197, 119, 255, 118, 197, 120, 255, 118, 197, 120, 255, 119, 197, 120, 255, 119, 197, 120, 255, 119, 197, 120, 255, 120, 197, 121, 255, 120, 197, 121, 255, 120, 198, 121, 255, 121, 198, 121, 255, 121, 198, 122, 255, 121, 198, 122, 255, 121, 198, 122, 255, 122, 198, 122, 255, 122, 198, 122, 255, 122, 199, 123, 255, 123, 199, 123, 255, 123, 199, 123, 255, 123, 199, 123, 255, 123, 199, 124, 255, 124, 199, 124, 255, 124, 199, 124, 255, 124, 199, 124, 255, 125, 200, 125, 255, 125, 200, 125, 255, 125, 200, 125, 255, 125, 200, 125, 255, 126, 200, 125, 255, 126, 200, 126, 255, 126, 200, 126, 255, 127, 200, 126, 255, 127, 201, 126, 255, 127, 201, 127, 255, 127, 201, 127, 255, 128, 201, 127, 255, 128, 201, 127, 255, 128, 201, 127, 255, 129, 201, 128, 255, 129, 202, 128, 255, 129, 202, 128, 255, 129, 202, 128, 255, 130, 202, 129, 255, 130, 202, 129, 255, 130, 202, 129, 255, 131, 202, 129, 255, 131, 202, 130, 255, 131, 203, 130, 255, 131, 203, 130, 255, 132, 203, 130, 255, 132, 203, 130, 255, 132, 203, 131, 255, 133, 203, 131, 255, 133, 203, 131, 255, 133, 204, 131, 255, 133, 204, 132, 255, 134, 204, 132, 255, 143, 208, 139, 255, 143, 208, 140, 255, 144, 208, 140, 255, 144, 208, 140, 255, 144, 209, 140, 255, 144, 209, 141, 255, 145, 209, 141, 255, 145, 209, 141, 255, 145, 209, 141, 255, 146, 209, 142, 255, 146, 209, 142, 255, 146, 210, 142, 255, 146, 210, 142, 255, 147, 210, 143, 255, 147, 210, 143, 255, 147, 210, 143, 255, 147, 210, 143, 255, 148, 210, 143, 255, 148, 210, 144, 255, 148, 211, 144, 255, 149, 211, 144, 255, 149, 211, 144, 255, 149, 211, 145, 255, 149, 211, 145, 255, 150, 211, 145, 255, 150, 211, 145, 255, 150, 212, 146, 255, 150, 212, 146, 255, 151, 212, 146, 255, 151, 212, 146, 255, 151, 212, 146, 255, 152, 212, 147, 255, 152, 212, 147, 255, 152, 212, 147, 255, 152, 213, 147, 255, 153, 213, 148, 255, 153, 213, 148, 255, 153, 213, 148, 255, 153, 213, 148, 255, 154, 213, 149, 255, 154, 213, 149, 255, 154, 213, 149, 255, 155, 214, 149, 255, 155, 214, 150, 255, 155, 214, 150, 255, 155, 214, 150, 255, 156, 214, 150, 255, 156, 214, 150, 255, 156, 214, 151, 255, 156, 215, 151, 255, 157, 215, 151, 255, 157, 215, 151, 255, 157, 215, 152, 255, 158, 215, 152, 255, 158, 215, 152, 255, 158, 215, 152, 255, 158, 215, 153, 255, 159, 216, 153, 255, 159, 216, 153, 255, 159, 216, 153, 255, 159, 216, 154, 255, 160, 216, 154, 255, 160, 216, 154, 255, 160, 216, 154, 255, 160, 217, 154, 255, 161, 217, 155, 255, 161, 217, 155, 255, 161, 217, 155, 255, 161, 217, 155, 255, 162, 217, 156, 255, 162, 217, 156, 255, 162, 217, 156, 255, 162, 217, 156, 255, 163, 217, 157, 255, 163, 218, 157, 255, 163, 218, 157, 255, 163, 218, 157, 255, 164, 218, 157, 255, 164, 218, 158, 255, 164, 218, 158, 255, 164, 218, 158, 255, 165, 218, 158, 255, 165, 218, 159, 255, 165, 218, 159, 255, 165, 219, 159, 255, 166, 219, 159, 255, 166, 219, 159, 255, 166, 219, 160, 255, 166, 219, 160, 255, 167, 219, 160, 255, 167, 219, 160, 255, 167, 219, 161, 255, 167, 219, 161, 255, 168, 219, 161, 255, 168, 220, 161, 255, 168, 220, 162, 255, 168, 220, 162, 255, 169, 220, 162, 255, 169, 220, 162, 255, 169, 220, 162, 255, 169, 220, 163, 255, 170, 220, 163, 255, 170, 220, 163, 255, 170, 220, 163, 255, 170, 221, 164, 255, 170, 221, 164, 255, 171, 221, 164, 255, 171, 221, 164, 255, 171, 221, 165, 255, 171, 221, 165, 255, 172, 221, 165, 255, 172, 221, 165, 255, 172, 221, 165, 255, 172, 221, 166, 255, 173, 222, 166, 255, 173, 222, 166, 255, 173, 222, 166, 255, 173, 222, 167, 255, 174, 222, 167, 255, 174, 222, 167, 255, 174, 222, 167, 255, 174, 222, 168, 255, 175, 222, 168, 255, 175, 222, 168, 255, 175, 223, 168, 255, 175, 223, 168, 255, 175, 223, 169, 255, 176, 223, 169, 255, 184, 226, 177, 255, 184, 226, 177, 255, 184, 226, 177, 255, 184, 226, 177, 255, 185, 227, 177, 255, 185, 227, 178, 255, 185, 227, 178, 255, 185, 227, 178, 255, 185, 227, 178, 255, 186, 227, 179, 255, 186, 227, 179, 255, 186, 227, 179, 255, 186, 227, 179, 255, 187, 227, 180, 255, 187, 228, 180, 255, 187, 228, 180, 255, 187, 228, 180, 255, 188, 228, 180, 255, 188, 228, 181, 255, 188, 228, 181, 255, 188, 228, 181, 255, 189, 228, 181, 255, 189, 228, 182, 255, 189, 228, 182, 255, 189, 229, 182, 255, 189, 229, 182, 255, 190, 229, 183, 255, 190, 229, 183, 255, 190, 229, 183, 255, 190, 229, 183, 255, 191, 229, 184, 255, 191, 229, 184, 255, 191, 229, 184, 255, 191, 229, 184, 255, 192, 230, 184, 255, 192, 230, 185, 255, 192, 230, 185, 255, 192, 230, 185, 255, 192, 230, 185, 255, 193, 230, 186, 255, 193, 230, 186, 255, 193, 230, 186, 255, 193, 230, 186, 255, 194, 230, 187, 255, 194, 231, 187, 255, 194, 231, 187, 255, 194, 231, 187, 255, 195, 231, 187, 255, 195, 231, 188, 255, 195, 231, 188, 255, 195, 231, 188, 255, 195, 231, 188, 255, 196, 231, 189, 255, 196, 231, 189, 255, 196, 232, 189, 255, 196, 232, 189, 255, 197, 232, 190, 255, 197, 232, 190, 255, 197, 232, 190, 255, 197, 232, 190, 255, 198, 232, 191, 255, 198, 232, 191, 255, 198, 232, 191, 255, 198, 232, 191, 255, 198, 233, 191, 255, 199, 233, 192, 255, 199, 233, 192, 255, 199, 233, 192, 255, 199, 233, 192, 255, 199, 233, 192, 255, 200, 233, 193, 255, 200, 233, 193, 255, 200, 233, 193, 255, 200, 233, 193, 255, 200, 233, 193, 255, 201, 233, 194, 255, 201, 233, 194, 255, 201, 233, 194, 255, 201, 234, 194, 255, 201, 234, 194, 255, 202, 234, 195, 255, 202, 234, 195, 255, 202, 234, 195, 255, 202, 234, 195, 255, 202, 234, 195, 255, 203, 234, 196, 255, 203, 234, 196, 255, 203, 234, 196, 255, 203, 234, 196, 255, 203, 234, 196, 255, 203, 234, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 197, 255, 204, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 198, 255, 205, 235, 199, 255, 206, 235, 199, 255, 206, 235, 199, 255, 206, 235, 199, 255, 206, 235, 199, 255, 206, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 200, 255, 207, 236, 201, 255, 207, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 208, 236, 202, 255, 208, 236, 202, 255, 209, 236, 202, 255, 209, 237, 202, 255, 209, 237, 202, 255, 209, 237, 203, 255, 209, 237, 203, 255, 210, 237, 203, 255, 210, 237, 203, 255, 210, 237, 203, 255, 210, 237, 204, 255, 210, 237, 204, 255, 210, 237, 204, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 217, 240, 211, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 219, 240, 213, 255, 219, 241, 213, 255, 219, 241, 213, 255, 219, 241, 213, 255, 219, 241, 213, 255, 219, 241, 214, 255, 220, 241, 214, 255, 220, 241, 214, 255, 220, 241, 214, 255, 220, 241, 214, 255, 220, 241, 215, 255, 221, 241, 215, 255, 221, 241, 215, 255, 221, 241, 215, 255, 221, 241, 215, 255, 221, 242, 216, 255, 222, 242, 216, 255, 222, 242, 216, 255, 222, 242, 216, 255, 222, 242, 216, 255, 222, 242, 217, 255, 222, 242, 217, 255, 223, 242, 217, 255, 223, 242, 217, 255, 223, 242, 217, 255, 223, 242, 218, 255, 223, 242, 218, 255, 224, 242, 218, 255, 224, 243, 218, 255, 224, 243, 218, 255, 224, 243, 219, 255, 224, 243, 219, 255, 224, 243, 219, 255, 225, 243, 219, 255, 225, 243, 219, 255, 225, 243, 220, 255, 225, 243, 220, 255, 225, 243, 220, 255, 226, 243, 220, 255, 226, 243, 220, 255, 226, 243, 221, 255, 226, 244, 221, 255, 226, 244, 221, 255, 226, 244, 221, 255, 227, 244, 221, 255, 227, 244, 222, 255, 227, 244, 222, 255, 227, 244, 222, 255, 227, 244, 222, 255, 228, 244, 222, 255, 228, 244, 223, 255, 228, 244, 223, 255, 228, 244, 223, 255, 228, 244, 223, 255, 228, 245, 223, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 226, 255, 230, 245, 226, 255, 231, 245, 226, 255, 231, 245, 226, 255, 231, 245, 226, 255, 231, 245, 226, 255, 231, 245, 226, 255, 231, 246, 226, 255, 231, 246, 227, 255, 231, 246, 227, 255, 231, 246, 227, 255, 232, 246, 227, 255, 232, 246, 227, 255, 232, 246, 227, 255, 232, 246, 227, 255, 232, 246, 228, 255, 232, 246, 228, 255, 232, 246, 228, 255, 232, 246, 228, 255, 233, 246, 228, 255, 233, 246, 228, 255, 233, 246, 228, 255, 233, 246, 228, 255, 233, 246, 229, 255, 233, 246, 229, 255, 233, 246, 229, 255, 233, 246, 229, 255, 233, 246, 229, 255, 234, 246, 229, 255, 234, 246, 229, 255, 234, 247, 229, 255, 234, 247, 230, 255, 234, 247, 230, 255, 234, 247, 230, 255, 234, 247, 230, 255, 234, 247, 230, 255, 234, 247, 230, 255, 235, 247, 230, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 236, 247, 232, 255, 236, 247, 232, 255, 239, 249, 236, 255, 239, 249, 236, 255, 240, 249, 236, 255, 240, 249, 236, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 241, 249, 237, 255, 241, 249, 237, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 241, 255, 243, 250, 241, 255, 243, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 246, 251, 243, 255, 246, 251, 243, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255
};
static const heatmap_colorscheme_t mixed = { mixed_data, sizeof(mixed_data)/sizeof(mixed_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Greens_mixed = &mixed;

static const unsigned char mixed_exp_data[] = {
    0, 0, 0, 0, 0, 68, 26, 0, 0, 70, 28, 24, 0, 72, 29, 49, 0, 75, 30, 74, 0, 77, 31, 99, 0, 80, 32, 124, 0, 82, 33, 149, 0, 93, 37, 174, 0, 95, 38, 199, 0, 98, 39, 224, 0, 100, 40, 249, 0, 102, 41, 255, 0, 105, 42, 255, 0, 107, 43, 255, 0, 109, 44, 255, 3, 111, 45, 255, 5, 112, 47, 255, 7, 114, 48, 255, 10, 116, 49, 255, 12, 117, 51, 255, 14, 119, 52, 255, 16, 120, 53, 255, 24, 128, 60, 255, 26, 129, 61, 255, 27, 131, 62, 255, 29, 132, 63, 255, 30, 134, 65, 255, 32, 135, 66, 255, 33, 137, 67, 255, 34, 138, 68, 255, 36, 140, 70, 255, 38, 141, 71, 255, 39, 143, 72, 255, 40, 144, 73, 255, 42, 146, 74, 255, 43, 147, 75, 255, 45, 149, 76, 255, 46, 150, 77, 255, 53, 158, 83, 255, 55, 159, 84, 255, 56, 161, 85, 255, 57, 162, 86, 255, 58, 164, 87, 255, 60, 165, 88, 255, 61, 166, 89, 255, 62, 168, 90, 255, 63, 169, 91, 255, 64, 170, 92, 255, 67, 171, 93, 255, 69, 173, 94, 255, 71, 174, 95, 255, 74, 174, 96, 255, 76, 175, 97, 255, 78, 176, 98, 255, 80, 177, 99, 255, 82, 178, 100, 255, 84, 179, 101, 255, 86, 180, 102, 255, 98, 186, 108, 255, 100, 187, 109, 255, 101, 188, 110, 255, 103, 189, 111, 255, 105, 190, 112, 255, 107, 191, 113, 255, 108, 192, 113, 255, 110, 192, 114, 255, 111, 193, 115, 255, 113, 194, 116, 255, 115, 195, 117, 255, 116, 196, 118, 255, 118, 196, 119, 255, 119, 197, 120, 255, 121, 198, 122, 255, 122, 199, 123, 255, 124, 199, 124, 255, 125, 200, 125, 255, 127, 201, 126, 255, 128, 201, 127, 255, 130, 202, 128, 255, 131, 202, 130, 255, 132, 203, 131, 255, 134, 204, 132, 255, 144, 209, 140, 255, 145, 209, 141, 255, 147, 210, 142, 255, 148, 210, 144, 255, 149, 211, 145, 255, 150, 212, 146, 255, 152, 212, 147, 255, 153, 213, 148, 255, 154, 213, 149, 255, 155, 214, 150, 255, 156, 214, 151, 255, 157, 215, 152, 255, 159, 216, 153, 255, 160, 216, 154, 255, 161, 217, 155, 255, 162, 217, 156, 255, 163, 217, 157, 255, 164, 218, 158, 255, 165, 218, 158, 255, 166, 219, 159, 255, 167, 219, 160, 255, 168, 219, 161, 255, 169, 220, 162, 255, 169, 220, 163, 255, 170, 221, 164, 255, 171, 221, 165, 255, 172, 221, 165, 255, 173, 222, 166, 255, 174, 222, 167, 255, 175, 222, 168, 255, 176, 223, 169, 255, 184, 226, 177, 255, 185, 227, 178, 255, 186, 227, 179, 255, 186, 227, 179, 255, 187, 228, 180, 255, 188, 228, 181, 255, 189, 228, 182, 255, 190, 229, 182, 255, 190, 229, 183, 255, 191, 229, 184, 255, 192, 230, 185, 255, 193, 230, 185, 255, 193, 230, 186, 255, 194, 231, 187, 255, 195, 231, 188, 255, 195, 231, 188, 255, 196, 231, 189, 255, 197, 232, 190, 255, 197, 232, 190, 255, 198, 232, 191, 255, 199, 233, 192, 255, 199, 233, 192, 255, 200, 233, 193, 255, 200, 233, 193, 255, 201, 233, 194, 255, 201, 234, 194, 255, 202, 234, 195, 255, 202, 234, 196, 255, 203, 234, 196, 255, 203, 234, 197, 255, 204, 235, 197, 255, 204, 235, 198, 255, 205, 235, 198, 255, 205, 235, 199, 255, 206, 235, 199, 255, 206, 236, 200, 255, 207, 236, 200, 255, 207, 236, 201, 255, 208, 236, 201, 255, 208, 236, 201, 255, 209, 236, 202, 255, 209, 237, 202, 255, 209, 237, 203, 255, 210, 237, 203, 255, 210, 237, 204, 255, 217, 240, 211, 255, 217, 240, 211, 255, 218, 240, 212, 255, 218, 240, 212, 255, 218, 240, 212, 255, 219, 241, 213, 255, 219, 241, 213, 255, 220, 241, 214, 255, 220, 241, 214, 255, 220, 241, 214, 255, 221, 241, 215, 255, 221, 241, 215, 255, 221, 242, 216, 255, 222, 242, 216, 255, 222, 242, 216, 255, 222, 242, 217, 255, 223, 242, 217, 255, 223, 242, 218, 255, 223, 242, 218, 255, 224, 243, 218, 255, 224, 243, 219, 255, 224, 243, 219, 255, 225, 243, 219, 255, 225, 243, 220, 255, 225, 243, 220, 255, 226, 243, 220, 255, 226, 244, 221, 255, 226, 244, 221, 255, 227, 244, 221, 255, 227, 244, 222, 255, 227, 244, 222, 255, 228, 244, 222, 255, 228, 244, 223, 255, 228, 244, 223, 255, 228, 244, 223, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 224, 255, 229, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 225, 255, 230, 245, 226, 255, 230, 245, 226, 255, 231, 245, 226, 255, 231, 245, 226, 255, 231, 245, 226, 255, 231, 245, 226, 255, 231, 246, 227, 255, 231, 246, 227, 255, 231, 246, 227, 255, 232, 246, 227, 255, 232, 246, 227, 255, 232, 246, 227, 255, 232, 246, 228, 255, 232, 246, 228, 255, 232, 246, 228, 255, 232, 246, 228, 255, 233, 246, 228, 255, 233, 246, 228, 255, 233, 246, 228, 255, 233, 246, 229, 255, 233, 246, 229, 255, 233, 246, 229, 255, 233, 246, 229, 255, 233, 246, 229, 255, 234, 246, 229, 255, 234, 246, 229, 255, 234, 247, 230, 255, 234, 247, 230, 255, 234, 247, 230, 255, 234, 247, 230, 255, 234, 247, 230, 255, 234, 247, 230, 255, 234, 247, 230, 255, 235, 247, 230, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 235, 247, 231, 255, 236, 247, 232, 255, 236, 247, 232, 255, 236, 247, 232, 255, 239, 249, 236, 255, 239, 249, 236, 255, 240, 249, 236, 255, 240, 249, 236, 255, 240, 249, 236, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 240, 249, 237, 255, 241, 249, 237, 255, 241, 249, 237, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 249, 238, 255, 241, 250, 238, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 239, 255, 242, 250, 240, 255, 242, 250, 240, 255, 242, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 240, 255, 243, 250, 241, 255, 243, 250, 241, 255, 243, 250, 241, 255, 243, 250, 241, 255, 243, 250, 241, 255, 243, 250, 241, 255, 243, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 250, 241, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 244, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 242, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 245, 251, 243, 255, 246, 251, 243, 255, 246, 251, 243, 255, 246, 251, 243, 255, 246, 251, 243, 255, 246, 251, 243, 255, 246, 251, 243, 255, 246, 251, 243, 255, 246, 251, 243, 255, 246, 251, 243, 255, 246, 251, 243, 255, 246, 251, 243, 255, 246, 251, 243, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 251, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255, 246, 252, 244, 255
};
static const heatmap_colorscheme_t mixed_exp = { mixed_exp_data, sizeof(mixed_exp_data)/sizeof(mixed_exp_data[0]/4) };
const heatmap_colorscheme_t* heatmap_cs_Greens_mixed_exp = &mixed_exp;

#ifdef __cplusplus
}
#endif
