function getFixtures() {
  // Before we can really start, we need to fill a bunch of buffers with data
  var plaintext = new Uint8Array([
    84, 104, 105, 115, 32, 115, 112, 101, 99, 105, 102, 105, 99, 97, 116, 105,
    111, 110, 32, 100, 101, 115, 99, 114, 105, 98, 101, 115, 32, 97, 32, 74, 97,
    118, 97, 83, 99, 114, 105, 112, 116, 32, 65, 80, 73, 32, 102, 111, 114, 32,
    112, 101, 114, 102, 111, 114, 109, 105, 110, 103, 32, 98, 97, 115, 105, 99,
    32, 99, 114, 121, 112, 116, 111, 103, 114, 97, 112, 104, 105, 99, 32, 111,
    112, 101, 114, 97, 116, 105, 111, 110, 115, 32, 105, 110, 32, 119, 101, 98,
    32, 97, 112, 112, 108, 105, 99, 97, 116, 105, 111, 110, 115, 44, 32, 115,
    117, 99, 104, 32, 97, 115, 32, 104, 97, 115, 104, 105, 110, 103, 44, 32,
    115, 105, 103, 110, 97, 116, 117, 114, 101, 32, 103, 101, 110, 101, 114, 97,
    116, 105, 111, 110, 32, 97, 110, 100, 32, 118, 101, 114, 105, 102, 105, 99,
    97, 116, 105, 111, 110, 44, 32, 97, 110, 100, 32, 101, 110, 99, 114, 121,
    112, 116, 105, 111, 110, 32, 97, 110, 100, 32, 100, 101, 99, 114, 121, 112,
    116, 105, 111, 110, 46, 32, 65, 100, 100, 105, 116, 105, 111, 110, 97, 108,
    108, 121, 44, 32, 105, 116, 32, 100, 101, 115, 99, 114, 105, 98, 101, 115,
    32, 97, 110, 32, 65, 80, 73, 32, 102, 111, 114, 32, 97, 112, 112, 108, 105,
    99, 97, 116, 105, 111, 110, 115, 32, 116, 111, 32, 103, 101, 110, 101, 114,
    97, 116, 101, 32, 97, 110, 100, 47, 111, 114, 32, 109, 97, 110, 97, 103,
    101, 32, 116, 104, 101, 32, 107, 101, 121, 105, 110, 103, 32, 109, 97, 116,
    101, 114, 105, 97, 108, 32, 110, 101, 99, 101, 115, 115, 97, 114, 121, 32,
    116, 111, 32, 112, 101, 114, 102, 111, 114, 109, 32, 116, 104, 101, 115,
    101, 32, 111, 112, 101, 114, 97, 116, 105, 111, 110, 115, 46, 32, 85, 115,
    101, 115, 32, 102, 111, 114, 32, 116, 104, 105, 115, 32, 65, 80, 73, 32,
    114, 97, 110, 103, 101, 32, 102, 114, 111, 109, 32, 117, 115, 101, 114, 32,
    111, 114, 32, 115, 101, 114, 118, 105, 99, 101, 32, 97, 117, 116, 104, 101,
    110, 116, 105, 99, 97, 116, 105, 111, 110, 44, 32, 100, 111, 99, 117, 109,
    101, 110, 116, 32, 111, 114, 32, 99, 111, 100, 101, 32, 115, 105, 103, 110,
    105, 110, 103, 44, 32, 97, 110, 100, 32, 116, 104, 101, 32, 99, 111, 110,
    102, 105, 100, 101, 110, 116, 105, 97, 108, 105, 116, 121, 32, 97, 110, 100,
    32, 105, 110, 116, 101, 103, 114, 105, 116, 121, 32, 111, 102, 32, 99, 111,
    109, 109, 117, 110, 105, 99, 97, 116, 105, 111, 110, 115, 46,
  ]);

  // We want some random key bytes of various sizes.
  // These were randomly generated from a script.
  var keyBytes = {
    128: new Uint8Array([
      222, 192, 212, 252, 191, 60, 71, 65, 200, 146, 218, 189, 28, 212, 192, 78,
    ]),
    192: new Uint8Array([
      208, 238, 131, 65, 63, 68, 196, 63, 186, 208, 61, 207, 166, 18, 99, 152,
      29, 109, 221, 95, 240, 30, 28, 246,
    ]),
    256: new Uint8Array([
      103, 105, 56, 35, 251, 29, 88, 7, 63, 145, 236, 233, 204, 58, 249, 16,
      229, 83, 38, 22, 164, 210, 123, 19, 235, 123, 116, 216, 0, 11, 191, 48,
    ]),
  };

  var iv = new Uint8Array([
    58, 146, 115, 42, 166, 234, 57, 191, 57, 134, 224, 199, 108, 116, 46,
  ]);

  var additionalData = new Uint8Array([
    84, 104, 101, 114, 101, 32, 97, 114, 101, 32, 55, 32, 102, 117, 114, 116,
    104, 101, 114, 32, 101, 100, 105, 116, 111, 114, 105, 97, 108, 32, 110, 111,
    116, 101, 115, 32, 105, 110, 32, 116, 104, 101, 32, 100, 111, 99, 117, 109,
    101, 110, 116, 46,
  ]);

  var ciphertext = {
    128: {
      64: new Uint8Array([
        65, 221, 187, 210, 119, 207, 141, 109, 144, 97, 82, 124, 60, 189, 176,
        2, 250, 48, 64, 29, 197, 22, 59, 96, 246, 211, 155, 184, 126, 116, 79,
        37, 168, 109, 191, 38, 77, 90, 74, 112, 222, 105, 173, 190, 182, 226,
        244, 47, 130, 191, 207, 190, 105, 186, 153, 58, 132, 212, 108, 156, 108,
        30, 56, 180, 7, 133, 144, 169, 249, 120, 191, 16, 40, 13, 157, 127, 170,
        134, 193, 12, 39, 84, 117, 13, 68, 26, 4, 52, 188, 51, 30, 55, 171, 181,
        255, 252, 12, 238, 46, 197, 114, 255, 125, 171, 6, 162, 40, 42, 217,
        221, 127, 164, 14, 171, 249, 105, 12, 133, 246, 205, 161, 97, 238, 208,
        179, 30, 161, 182, 134, 100, 112, 205, 93, 101, 69, 254, 253, 201, 244,
        67, 2, 87, 172, 247, 144, 141, 88, 80, 236, 188, 190, 73, 179, 253, 211,
        142, 98, 141, 16, 97, 166, 2, 71, 224, 232, 44, 238, 82, 33, 16, 32,
        224, 111, 191, 89, 157, 99, 127, 28, 95, 175, 15, 86, 10, 44, 180, 127,
        200, 162, 37, 138, 69, 78, 119, 165, 96, 98, 107, 211, 122, 21, 49, 124,
        60, 156, 38, 20, 22, 196, 86, 20, 182, 173, 23, 42, 42, 26, 213, 84, 21,
        160, 156, 96, 20, 234, 208, 177, 44, 112, 110, 165, 233, 20, 56, 123,
        110, 129, 57, 158, 148, 98, 241, 47, 148, 113, 198, 10, 80, 16, 221, 91,
        8, 192, 194, 190, 183, 113, 67, 134, 234, 239, 20, 108, 150, 83, 106,
        209, 112, 93, 196, 12, 135, 2, 177, 151, 168, 46, 202, 197, 22, 24, 48,
        105, 76, 218, 21, 229, 45, 127, 109, 93, 38, 189, 215, 123, 110, 23,
        110, 94, 232, 46, 167, 50, 5, 212, 120, 69, 230, 35, 149, 228, 24, 115,
        134, 10, 187, 73, 79, 197, 47, 5, 200, 142, 166, 159, 51, 154, 199, 178,
        88, 127, 240, 228, 141, 20, 122, 191, 173, 66, 120, 130, 223, 180, 218,
        107, 134, 224, 251, 127, 180, 17, 196, 223, 182, 230, 5, 217, 23, 146,
        3, 251, 129, 27, 162, 223, 19, 72, 108, 117, 51, 77, 53, 21, 158, 135,
        114, 157, 8, 166, 80, 246, 162, 103, 61, 116, 188, 30, 201, 112, 239,
        13, 244, 46, 123, 193, 206, 91, 17, 188, 78, 81, 21, 226, 218, 56, 177,
        139, 17, 4, 94, 165, 250, 207, 170, 141, 211, 247, 201, 101, 122, 198,
        121, 99, 24, 177, 98, 188, 192, 252, 96, 181, 110, 111, 154, 144, 57,
        141, 114, 50, 228, 192, 154, 123, 241, 143, 78, 250, 156, 140, 128, 195,
        151, 145, 153, 130, 43, 154, 34, 187, 242, 243, 55, 91, 154, 149, 193,
        214, 82, 249, 212, 79, 131, 230, 179, 4, 251, 6, 135, 210,
      ]),
      96: new Uint8Array([
        116, 195, 75, 212, 107, 179, 95, 161, 75, 160, 249, 225, 187, 238, 165,
        13, 225, 89, 223, 89, 247, 241, 11, 92, 196, 16, 218, 185, 132, 72, 201,
        90, 151, 176, 56, 167, 227, 75, 251, 171, 9, 230, 136, 101, 165, 140,
        144, 22, 130, 178, 45, 119, 40, 202, 73, 204, 59, 237, 19, 47, 69, 34,
        127, 34, 196, 150, 65, 6, 136, 178, 159, 166, 234, 195, 139, 124, 71,
        183, 154, 189, 142, 34, 209, 19, 109, 149, 154, 26, 36, 158, 109, 31,
        190, 39, 74, 118, 167, 66, 245, 31, 194, 58, 64, 46, 213, 32, 51, 61,
        99, 255, 236, 134, 87, 67, 205, 192, 77, 30, 212, 51, 205, 55, 48, 97,
        58, 122, 86, 165, 33, 32, 26, 107, 122, 32, 144, 192, 102, 53, 27, 207,
        166, 61, 8, 83, 123, 162, 237, 209, 52, 220, 100, 99, 252, 157, 115, 97,
        137, 98, 13, 37, 66, 141, 94, 27, 132, 24, 161, 6, 146, 159, 64, 240,
        12, 236, 45, 211, 121, 194, 184, 143, 35, 72, 204, 231, 168, 226, 36,
        45, 74, 47, 14, 6, 145, 68, 119, 196, 6, 33, 184, 155, 10, 103, 94, 180,
        175, 13, 58, 121, 37, 97, 80, 149, 175, 240, 167, 3, 254, 122, 3, 118,
        188, 137, 32, 147, 123, 245, 29, 189, 97, 44, 140, 137, 54, 145, 241,
        216, 160, 47, 140, 30, 149, 239, 122, 103, 54, 19, 187, 73, 59, 34, 32,
        43, 35, 220, 167, 180, 220, 124, 110, 51, 23, 64, 127, 6, 30, 38, 106,
        45, 42, 110, 9, 180, 158, 251, 255, 129, 18, 243, 116, 251, 159, 139,
        229, 108, 48, 105, 120, 222, 118, 220, 127, 69, 198, 116, 126, 157, 164,
        161, 225, 120, 220, 253, 158, 92, 159, 214, 175, 116, 80, 57, 117, 10,
        174, 133, 166, 182, 43, 186, 233, 10, 174, 82, 7, 161, 197, 165, 60, 70,
        113, 150, 15, 32, 165, 11, 7, 160, 110, 61, 1, 45, 216, 51, 129, 171,
        156, 35, 46, 21, 160, 21, 217, 135, 223, 231, 180, 30, 163, 75, 251,
        151, 13, 2, 165, 71, 12, 38, 185, 208, 103, 132, 136, 73, 173, 99, 67,
        169, 126, 185, 180, 61, 216, 206, 192, 69, 228, 190, 244, 233, 172, 97,
        32, 74, 219, 254, 70, 177, 179, 196, 75, 157, 11, 108, 94, 240, 84, 26,
        219, 200, 255, 236, 109, 139, 188, 99, 38, 221, 10, 173, 108, 25, 42,
        87, 1, 15, 171, 197, 255, 190, 222, 21, 27, 162, 150, 52, 79, 82, 61,
        156, 95, 231, 170, 247, 189, 177, 91, 62, 24, 26, 66, 113, 207, 66, 208,
        101, 215, 18, 106, 161, 240, 66, 216, 91, 12, 247, 50, 232, 243, 96,
        153, 226, 0, 85, 234, 218, 24, 209, 91, 40, 119,
      ]),
      128: new Uint8Array([
        49, 92, 208, 197, 89, 61, 226, 4, 124, 46, 215, 121, 228, 211, 234, 42,
        228, 175, 236, 139, 48, 88, 75, 81, 194, 242, 144, 113, 49, 107, 153,
        91, 135, 221, 210, 102, 120, 174, 103, 144, 201, 223, 73, 220, 52, 117,
        71, 100, 200, 29, 53, 86, 15, 223, 21, 208, 205, 235, 143, 137, 20, 119,
        193, 77, 202, 117, 62, 20, 39, 157, 85, 48, 135, 76, 115, 241, 39, 71,
        58, 175, 227, 190, 64, 21, 64, 94, 46, 23, 236, 68, 228, 232, 9, 173,
        189, 162, 99, 0, 228, 110, 126, 8, 201, 183, 37, 172, 191, 149, 98, 96,
        190, 93, 21, 108, 250, 83, 149, 235, 38, 47, 205, 15, 126, 188, 69, 200,
        178, 132, 63, 116, 9, 89, 227, 110, 115, 250, 82, 41, 127, 44, 44, 95,
        2, 188, 67, 31, 123, 23, 121, 60, 11, 57, 146, 245, 14, 63, 131, 212,
        70, 39, 237, 148, 226, 126, 245, 4, 174, 239, 64, 127, 108, 246, 211,
        172, 76, 129, 133, 114, 144, 243, 157, 85, 126, 67, 101, 193, 205, 115,
        147, 154, 82, 92, 32, 82, 7, 40, 163, 152, 135, 62, 137, 29, 117, 164,
        82, 220, 169, 224, 143, 118, 130, 116, 210, 192, 45, 21, 202, 180, 252,
        72, 223, 37, 224, 154, 14, 52, 252, 153, 243, 241, 101, 228, 169, 188,
        91, 20, 119, 49, 215, 112, 180, 244, 102, 26, 123, 94, 250, 63, 36, 156,
        254, 72, 225, 33, 180, 108, 96, 144, 43, 26, 44, 147, 195, 58, 74, 188,
        48, 178, 233, 158, 184, 251, 207, 70, 42, 124, 191, 10, 142, 13, 130,
        222, 97, 24, 216, 13, 111, 188, 209, 145, 9, 81, 32, 53, 159, 247, 165,
        109, 23, 212, 131, 80, 125, 44, 237, 63, 104, 111, 84, 12, 22, 195, 48,
        171, 1, 221, 172, 65, 132, 75, 54, 235, 129, 152, 248, 227, 81, 170,
        220, 45, 168, 254, 108, 166, 239, 192, 71, 199, 119, 252, 101, 90, 159,
        133, 248, 214, 245, 83, 8, 217, 202, 215, 29, 69, 73, 250, 186, 230,
        158, 38, 213, 179, 92, 183, 241, 197, 186, 114, 90, 108, 0, 246, 194,
        242, 123, 127, 244, 6, 161, 3, 238, 127, 234, 245, 30, 79, 93, 202, 103,
        93, 90, 123, 42, 105, 133, 230, 80, 159, 209, 198, 122, 153, 200, 38, 1,
        119, 89, 40, 42, 162, 183, 5, 77, 10, 161, 143, 128, 251, 104, 4, 132,
        172, 252, 146, 144, 5, 183, 31, 140, 54, 31, 155, 234, 110, 129, 41, 12,
        125, 231, 187, 49, 210, 196, 213, 85, 155, 135, 129, 33, 96, 71, 253,
        244, 140, 117, 80, 36, 107, 236, 198, 170, 93, 149, 112, 64, 167, 32,
        143, 89, 143, 151, 253, 118, 59, 152, 246, 197, 148, 87,
      ]),
    },
    192: {
      64: new Uint8Array([
        230, 126, 210, 64, 27, 223, 123, 87, 122, 27, 240, 255, 220, 9, 217,
        113, 209, 54, 104, 143, 75, 65, 22, 34, 143, 217, 125, 37, 22, 29, 228,
        59, 123, 35, 39, 168, 216, 34, 178, 27, 23, 2, 108, 156, 74, 59, 68, 37,
        72, 191, 103, 170, 5, 2, 135, 227, 184, 211, 164, 153, 218, 48, 90, 37,
        136, 121, 86, 64, 4, 82, 145, 246, 235, 198, 169, 107, 229, 27, 247,
        230, 135, 150, 159, 182, 144, 41, 179, 62, 165, 94, 254, 201, 0, 154,
        65, 65, 216, 72, 6, 168, 73, 12, 74, 128, 150, 168, 38, 163, 62, 77,
        179, 88, 120, 191, 70, 185, 188, 14, 91, 116, 185, 128, 135, 150, 50,
        123, 200, 159, 100, 17, 39, 252, 28, 205, 178, 33, 89, 38, 52, 123, 62,
        85, 53, 99, 7, 143, 251, 194, 35, 153, 127, 170, 170, 196, 49, 26, 173,
        5, 190, 15, 185, 34, 3, 254, 169, 95, 254, 109, 107, 7, 254, 149, 189,
        54, 172, 21, 89, 57, 250, 142, 107, 52, 143, 25, 83, 242, 125, 164, 108,
        123, 135, 38, 72, 139, 33, 67, 246, 22, 71, 216, 1, 128, 238, 244, 183,
        144, 106, 177, 152, 169, 193, 97, 57, 218, 121, 53, 200, 85, 61, 26,
        156, 185, 74, 142, 12, 182, 112, 60, 214, 31, 147, 104, 74, 50, 68, 47,
        1, 245, 149, 208, 28, 213, 73, 244, 216, 102, 65, 94, 64, 216, 224, 236,
        101, 112, 27, 197, 173, 24, 57, 113, 99, 177, 142, 1, 171, 72, 254, 171,
        22, 70, 158, 151, 38, 219, 190, 107, 118, 120, 18, 39, 200, 17, 44, 250,
        121, 78, 49, 44, 187, 223, 134, 150, 207, 123, 250, 209, 250, 91, 203,
        131, 236, 131, 82, 165, 175, 246, 8, 55, 98, 135, 105, 141, 207, 131,
        169, 92, 148, 234, 13, 33, 215, 126, 121, 79, 174, 229, 42, 135, 172,
        199, 29, 142, 254, 73, 147, 110, 82, 107, 73, 122, 38, 106, 133, 28, 33,
        99, 115, 142, 73, 102, 122, 194, 151, 243, 104, 200, 122, 52, 201, 180,
        5, 195, 223, 19, 221, 195, 38, 62, 238, 66, 197, 180, 8, 194, 249, 139,
        184, 87, 205, 207, 79, 160, 235, 137, 193, 81, 49, 20, 218, 226, 249,
        32, 197, 193, 143, 173, 135, 146, 152, 198, 189, 21, 80, 161, 225, 20,
        44, 28, 87, 151, 222, 180, 191, 147, 89, 79, 159, 46, 8, 174, 242, 173,
        54, 58, 108, 112, 51, 95, 90, 140, 162, 50, 162, 242, 239, 220, 190, 76,
        78, 7, 156, 25, 190, 195, 71, 140, 32, 133, 98, 48, 203, 145, 214, 207,
        212, 109, 186, 12, 122, 209, 88, 201, 225, 247, 228, 89, 217, 124, 40,
        136, 40, 105, 54, 45, 243, 34, 202, 122, 55,
      ]),
      96: new Uint8Array([
        132, 13, 203, 226, 200, 159, 255, 134, 178, 251, 192, 7, 168, 139, 69,
        151, 15, 76, 167, 58, 233, 112, 100, 150, 84, 45, 29, 94, 122, 99, 230,
        41, 34, 122, 29, 128, 62, 131, 131, 106, 56, 178, 85, 246, 149, 62, 58,
        73, 131, 69, 95, 9, 125, 68, 134, 101, 107, 127, 164, 64, 79, 128, 216,
        94, 211, 163, 140, 197, 201, 174, 95, 47, 215, 67, 28, 93, 125, 87, 5,
        157, 157, 150, 235, 54, 190, 253, 190, 151, 39, 71, 138, 188, 196, 55,
        214, 194, 216, 197, 193, 30, 18, 55, 117, 168, 203, 123, 197, 84, 190,
        4, 135, 13, 212, 108, 59, 14, 8, 255, 49, 166, 157, 253, 216, 103, 74,
        152, 68, 179, 21, 124, 56, 98, 2, 13, 56, 133, 185, 239, 108, 246, 173,
        114, 194, 183, 157, 166, 170, 61, 249, 240, 253, 78, 107, 244, 251, 114,
        90, 201, 3, 64, 5, 68, 164, 70, 2, 139, 27, 75, 229, 60, 168, 15, 109,
        217, 93, 38, 14, 122, 225, 245, 113, 185, 37, 61, 8, 153, 60, 225, 6,
        49, 248, 101, 16, 162, 55, 41, 79, 191, 79, 0, 104, 167, 171, 175, 96,
        69, 116, 225, 44, 4, 117, 255, 82, 168, 255, 95, 62, 39, 77, 251, 211,
        42, 221, 90, 192, 142, 52, 240, 119, 4, 26, 0, 136, 187, 8, 92, 46, 69,
        217, 107, 92, 192, 206, 122, 228, 115, 123, 224, 235, 27, 204, 72, 15,
        246, 243, 172, 141, 129, 129, 96, 120, 167, 208, 186, 170, 16, 3, 10,
        146, 100, 95, 28, 41, 163, 211, 40, 77, 187, 217, 141, 147, 141, 215,
        101, 50, 10, 225, 22, 102, 148, 115, 220, 235, 159, 136, 0, 245, 201,
        45, 174, 140, 128, 60, 57, 238, 33, 71, 145, 195, 187, 98, 115, 79, 70,
        85, 11, 10, 37, 89, 30, 59, 241, 150, 21, 20, 158, 15, 111, 55, 227,
        138, 234, 113, 237, 16, 92, 32, 85, 173, 79, 80, 151, 1, 202, 148, 4,
        247, 4, 19, 114, 17, 83, 60, 174, 13, 242, 255, 77, 103, 112, 220, 175,
        143, 73, 255, 164, 32, 209, 165, 7, 17, 51, 95, 98, 98, 9, 170, 136,
        179, 179, 122, 180, 115, 60, 76, 92, 124, 97, 134, 34, 209, 138, 173,
        52, 144, 198, 210, 65, 240, 232, 194, 102, 215, 57, 209, 249, 162, 186,
        251, 107, 194, 55, 93, 49, 158, 141, 151, 29, 85, 178, 187, 73, 174,
        206, 197, 135, 7, 117, 76, 208, 59, 37, 168, 196, 150, 125, 82, 32, 101,
        229, 47, 20, 231, 224, 208, 205, 103, 39, 136, 197, 8, 66, 25, 19, 91,
        157, 123, 213, 142, 207, 53, 34, 100, 146, 196, 181, 54, 115, 242, 134,
        71, 153, 64, 32, 151, 37, 181, 179, 131,
      ]),
      128: new Uint8Array([
        172, 222, 17, 53, 142, 131, 16, 112, 148, 160, 79, 191, 5, 172, 129,
        112, 79, 90, 10, 162, 240, 209, 201, 207, 100, 52, 153, 61, 37, 216,
        137, 35, 142, 99, 209, 82, 244, 65, 66, 25, 82, 51, 177, 215, 205, 186,
        26, 231, 35, 77, 183, 158, 2, 85, 85, 54, 45, 173, 171, 64, 55, 163, 85,
        156, 195, 233, 202, 181, 242, 4, 201, 192, 184, 81, 229, 4, 65, 89, 83,
        58, 140, 233, 220, 30, 221, 24, 104, 155, 113, 179, 164, 194, 143, 100,
        108, 255, 133, 158, 186, 81, 246, 19, 213, 152, 20, 181, 156, 221, 80,
        155, 52, 165, 110, 110, 51, 98, 218, 67, 126, 70, 74, 25, 101, 181, 54,
        32, 62, 22, 38, 243, 218, 217, 224, 49, 15, 181, 96, 177, 93, 36, 218,
        19, 142, 25, 12, 20, 66, 122, 72, 96, 182, 69, 194, 143, 173, 72, 132,
        40, 97, 0, 98, 206, 214, 118, 234, 32, 185, 173, 65, 104, 220, 81, 128,
        207, 186, 60, 227, 171, 80, 196, 67, 237, 218, 103, 16, 154, 18, 58, 29,
        124, 86, 161, 216, 59, 205, 122, 23, 166, 22, 136, 80, 67, 228, 132, 20,
        100, 235, 125, 56, 231, 10, 29, 111, 249, 1, 125, 59, 173, 25, 60, 107,
        118, 35, 211, 93, 252, 189, 135, 5, 251, 160, 170, 121, 198, 203, 242,
        108, 154, 143, 143, 167, 77, 27, 202, 162, 58, 219, 159, 208, 74, 116,
        146, 8, 227, 145, 32, 231, 145, 78, 29, 110, 79, 246, 106, 218, 5, 202,
        4, 79, 69, 112, 139, 36, 137, 77, 132, 15, 26, 125, 187, 3, 98, 149,
        172, 11, 201, 242, 212, 5, 244, 210, 63, 197, 160, 216, 194, 35, 74,
        116, 53, 127, 11, 70, 69, 25, 195, 157, 75, 169, 240, 184, 236, 131,
        104, 243, 12, 32, 139, 246, 20, 22, 149, 253, 137, 103, 11, 199, 85,
        145, 88, 152, 31, 102, 8, 226, 185, 115, 210, 153, 241, 105, 41, 164,
        65, 210, 247, 28, 185, 216, 26, 74, 32, 208, 20, 254, 201, 173, 45, 192,
        243, 151, 156, 22, 29, 4, 250, 59, 15, 125, 112, 38, 218, 230, 89, 182,
        216, 251, 141, 86, 65, 147, 78, 171, 220, 123, 79, 14, 28, 73, 35, 227,
        214, 61, 118, 91, 56, 182, 171, 190, 0, 196, 183, 205, 224, 179, 29,
        123, 79, 67, 248, 156, 250, 173, 92, 32, 89, 252, 20, 112, 250, 219,
        187, 51, 109, 173, 20, 19, 88, 149, 206, 102, 150, 251, 139, 137, 104,
        179, 29, 128, 165, 228, 14, 55, 184, 85, 73, 78, 198, 112, 137, 133,
        132, 223, 49, 171, 100, 40, 177, 97, 153, 153, 50, 86, 82, 153, 23, 227,
        55, 16, 239, 224, 74, 239, 208, 80, 64, 238, 36, 64,
      ]),
    },
    256: {
      64: new Uint8Array([
        42, 122, 195, 47, 242, 151, 101, 162, 101, 255, 99, 154, 224, 195, 92,
        248, 62, 224, 73, 134, 218, 18, 207, 64, 34, 188, 37, 139, 135, 132,
        178, 80, 244, 149, 22, 190, 205, 14, 120, 36, 241, 73, 196, 230, 144,
        48, 10, 52, 227, 132, 142, 37, 199, 193, 167, 242, 146, 172, 125, 190,
        111, 107, 29, 218, 95, 10, 24, 162, 250, 237, 42, 240, 107, 214, 253,
        11, 18, 236, 167, 248, 233, 98, 122, 74, 94, 29, 90, 98, 107, 98, 178,
        148, 102, 238, 93, 28, 197, 119, 140, 62, 205, 204, 229, 84, 198, 168,
        170, 47, 97, 127, 232, 162, 156, 85, 46, 2, 81, 96, 153, 67, 23, 223,
        201, 64, 215, 8, 152, 238, 39, 205, 242, 222, 161, 125, 81, 100, 166,
        103, 191, 70, 4, 24, 126, 204, 204, 216, 77, 210, 39, 126, 68, 208, 31,
        221, 153, 21, 166, 245, 12, 139, 238, 215, 21, 68, 91, 59, 106, 205, 20,
        138, 164, 216, 235, 18, 139, 238, 23, 220, 166, 247, 54, 166, 185, 102,
        218, 77, 20, 69, 145, 81, 157, 32, 62, 167, 232, 193, 81, 221, 5, 138,
        93, 240, 94, 9, 223, 96, 46, 65, 167, 231, 28, 47, 16, 48, 87, 239, 185,
        72, 21, 132, 227, 206, 251, 37, 166, 50, 118, 197, 248, 64, 129, 84, 25,
        184, 74, 102, 126, 62, 175, 219, 69, 233, 83, 180, 112, 231, 104, 17,
        162, 120, 19, 146, 230, 211, 181, 187, 121, 151, 110, 83, 152, 88, 224,
        81, 234, 167, 191, 180, 145, 69, 42, 97, 189, 59, 32, 36, 121, 23, 106,
        2, 198, 208, 200, 232, 197, 127, 104, 238, 30, 49, 37, 220, 153, 25, 36,
        96, 53, 253, 20, 59, 122, 72, 50, 197, 16, 9, 102, 190, 188, 95, 113,
        255, 253, 136, 247, 39, 35, 43, 124, 93, 159, 52, 248, 12, 4, 233, 216,
        253, 170, 123, 111, 76, 224, 35, 113, 53, 126, 194, 172, 229, 216, 163,
        177, 55, 225, 31, 242, 219, 59, 104, 84, 95, 230, 173, 139, 102, 217,
        206, 170, 79, 220, 33, 216, 100, 24, 54, 225, 138, 241, 184, 180, 190,
        65, 101, 64, 209, 84, 82, 107, 99, 199, 188, 126, 85, 237, 106, 85, 97,
        109, 152, 114, 68, 214, 13, 215, 208, 77, 228, 125, 36, 113, 143, 40,
        104, 105, 42, 160, 138, 201, 58, 173, 97, 31, 73, 96, 220, 218, 63, 101,
        131, 161, 99, 36, 107, 70, 232, 143, 233, 64, 109, 3, 89, 80, 79, 147,
        223, 186, 180, 232, 99, 137, 47, 130, 130, 227, 174, 161, 131, 211, 5,
        6, 169, 210, 68, 49, 152, 210, 70, 210, 75, 46, 133, 24, 138, 63, 41,
        254, 46, 92, 29, 148, 139, 150, 124, 53, 154, 40, 125, 184,
      ]),
      96: new Uint8Array([
        8, 102, 85, 24, 18, 25, 224, 27, 71, 136, 174, 49, 44, 70, 3, 134, 50,
        142, 118, 190, 26, 134, 96, 28, 29, 151, 90, 212, 124, 33, 86, 73, 247,
        172, 101, 73, 99, 51, 28, 123, 101, 20, 186, 236, 249, 17, 89, 105, 48,
        128, 151, 50, 93, 151, 46, 113, 98, 89, 193, 181, 91, 95, 77, 224, 62,
        103, 85, 227, 225, 150, 74, 186, 111, 210, 191, 96, 139, 219, 197, 202,
        185, 156, 118, 95, 230, 43, 186, 92, 133, 85, 90, 107, 176, 121, 164,
        25, 232, 22, 79, 98, 21, 37, 150, 122, 151, 22, 49, 221, 149, 228, 165,
        53, 163, 157, 218, 40, 128, 247, 125, 116, 42, 252, 80, 143, 44, 79, 52,
        153, 221, 254, 115, 231, 255, 29, 249, 235, 60, 149, 212, 14, 103, 143,
        239, 39, 57, 183, 23, 139, 190, 146, 207, 84, 170, 117, 27, 160, 109,
        217, 118, 197, 56, 14, 228, 108, 59, 11, 166, 84, 46, 207, 87, 109, 212,
        113, 6, 158, 49, 252, 112, 38, 95, 253, 59, 18, 195, 124, 108, 60, 230,
        138, 103, 199, 158, 34, 140, 2, 60, 104, 93, 15, 127, 13, 213, 72, 82,
        242, 70, 51, 188, 219, 123, 148, 125, 0, 226, 119, 218, 135, 74, 219, 0,
        116, 129, 230, 49, 133, 186, 228, 114, 170, 152, 222, 231, 60, 85, 229,
        146, 76, 34, 92, 57, 161, 211, 106, 223, 251, 16, 31, 42, 163, 190, 19,
        67, 237, 78, 82, 242, 135, 152, 140, 12, 34, 232, 215, 56, 117, 225, 92,
        29, 56, 249, 12, 136, 44, 195, 115, 175, 86, 176, 251, 246, 149, 17, 67,
        18, 226, 215, 52, 126, 140, 119, 205, 9, 138, 185, 11, 21, 210, 215, 52,
        234, 13, 171, 13, 168, 71, 178, 24, 175, 209, 164, 182, 90, 132, 104,
        88, 175, 129, 25, 53, 51, 132, 43, 225, 82, 12, 125, 177, 8, 68, 184,
        168, 135, 79, 127, 160, 112, 18, 117, 137, 175, 135, 23, 122, 238, 110,
        224, 32, 177, 162, 2, 200, 170, 62, 139, 183, 96, 210, 132, 22, 230,
        197, 166, 4, 127, 186, 4, 11, 147, 125, 123, 31, 71, 220, 206, 25, 91,
        135, 176, 55, 150, 148, 159, 73, 142, 137, 109, 184, 172, 143, 223, 118,
        220, 21, 92, 22, 144, 145, 204, 222, 164, 40, 56, 144, 253, 200, 219,
        70, 159, 251, 89, 13, 27, 62, 211, 44, 4, 89, 34, 6, 81, 123, 142, 144,
        63, 122, 74, 121, 66, 98, 160, 226, 178, 184, 13, 56, 212, 177, 162,
        214, 107, 239, 112, 67, 97, 211, 100, 38, 48, 89, 55, 43, 173, 74, 81,
        247, 72, 196, 31, 152, 132, 167, 132, 232, 240, 73, 225, 252, 186, 103,
        65, 197, 95, 79, 190, 202, 199, 182, 30,
      ]),
      128: new Uint8Array([
        247, 183, 56, 230, 246, 46, 162, 70, 247, 246, 214, 170, 243, 1, 197,
        73, 188, 188, 253, 79, 5, 63, 235, 32, 61, 2, 135, 174, 66, 13, 110, 77,
        89, 249, 180, 203, 225, 161, 112, 6, 217, 62, 96, 222, 238, 42, 76, 81,
        41, 12, 187, 140, 225, 49, 193, 165, 51, 125, 79, 95, 79, 140, 193, 53,
        147, 58, 73, 206, 75, 28, 178, 255, 124, 220, 141, 248, 11, 130, 211,
        148, 36, 115, 66, 133, 114, 219, 41, 90, 201, 225, 240, 25, 233, 239,
        110, 175, 233, 207, 223, 13, 129, 245, 124, 77, 173, 19, 62, 7, 22, 55,
        79, 56, 148, 81, 213, 239, 255, 23, 132, 225, 207, 130, 195, 45, 115,
        237, 36, 105, 106, 95, 62, 250, 183, 23, 62, 172, 87, 15, 139, 60, 13,
        8, 12, 60, 212, 69, 2, 137, 206, 157, 5, 5, 208, 88, 239, 38, 66, 209,
        89, 249, 233, 204, 234, 243, 150, 62, 39, 239, 6, 147, 24, 223, 89, 200,
        28, 71, 113, 82, 111, 158, 97, 80, 166, 158, 193, 37, 61, 243, 226, 36,
        74, 98, 100, 80, 23, 116, 2, 197, 166, 215, 15, 212, 200, 39, 158, 192,
        97, 41, 120, 126, 200, 10, 14, 201, 47, 150, 155, 118, 5, 119, 69, 169,
        122, 101, 0, 53, 174, 213, 241, 113, 111, 45, 227, 192, 153, 57, 59,
        148, 204, 203, 4, 114, 173, 122, 35, 128, 86, 74, 117, 43, 249, 245,
        245, 189, 222, 38, 98, 160, 211, 192, 65, 35, 5, 104, 72, 228, 83, 6,
        63, 157, 104, 226, 100, 205, 173, 67, 195, 174, 136, 151, 121, 2, 185,
        9, 32, 177, 78, 69, 118, 135, 126, 133, 188, 174, 167, 71, 145, 26, 48,
        23, 115, 144, 53, 124, 5, 36, 76, 244, 32, 116, 35, 155, 107, 193, 161,
        41, 81, 122, 111, 52, 74, 213, 130, 0, 60, 106, 213, 206, 3, 31, 163,
        46, 89, 163, 125, 9, 166, 34, 140, 58, 197, 28, 161, 107, 214, 237, 192,
        235, 113, 62, 222, 48, 124, 237, 102, 8, 215, 70, 116, 112, 201, 21,
        188, 99, 168, 0, 245, 141, 97, 163, 240, 234, 230, 42, 134, 77, 250, 9,
        30, 73, 136, 108, 100, 91, 54, 193, 19, 242, 218, 174, 129, 149, 149,
        56, 220, 168, 136, 149, 165, 196, 193, 214, 9, 189, 178, 121, 125, 238,
        225, 150, 81, 114, 215, 244, 2, 171, 123, 45, 83, 175, 65, 120, 125, 65,
        98, 66, 122, 8, 253, 183, 81, 93, 13, 71, 147, 163, 245, 198, 78, 141,
        200, 3, 1, 1, 60, 34, 46, 52, 46, 213, 222, 143, 177, 236, 188, 27, 12,
        196, 226, 219, 63, 126, 245, 17, 169, 83, 29, 86, 47, 251, 205, 223, 97,
        164, 34, 187, 82, 137, 186,
      ]),
    },
  };

  var tag = {
    128: {
      64: new Uint8Array([85, 92, 121, 149, 117, 105, 131, 236]),
      96: new Uint8Array([
        39, 4, 154, 219, 88, 182, 182, 27, 184, 126, 226, 69,
      ]),
      128: new Uint8Array([
        190, 170, 111, 11, 63, 177, 149, 125, 124, 144, 202, 221, 51, 245, 203,
        188,
      ]),
    },
    192: {
      64: new Uint8Array([100, 170, 171, 3, 209, 173, 29, 9]),
      96: new Uint8Array([
        235, 102, 97, 102, 35, 247, 179, 20, 48, 178, 86, 104,
      ]),
      128: new Uint8Array([
        228, 42, 50, 235, 55, 252, 87, 200, 249, 71, 204, 140, 90, 9, 38, 109,
      ]),
    },
    256: {
      64: new Uint8Array([88, 161, 48, 15, 218, 241, 79, 9]),
      96: new Uint8Array([
        123, 79, 227, 34, 149, 144, 168, 116, 29, 123, 134, 54,
      ]),
      128: new Uint8Array([
        143, 242, 94, 93, 210, 173, 212, 13, 233, 94, 15, 187, 5, 111, 216, 142,
      ]),
    },
  };

  var tag_with_empty_ad = {
    128: {
      64: new Uint8Array([29, 208, 61, 213, 245, 103, 78, 0]),
      96: new Uint8Array([
        111, 136, 222, 155, 216, 184, 123, 247, 168, 80, 240, 223,
      ]),
      128: new Uint8Array([
        246, 38, 43, 75, 191, 191, 88, 145, 108, 190, 216, 71, 41, 68, 90, 105,
      ]),
    },
    192: {
      64: new Uint8Array([169, 228, 25, 72, 206, 76, 237, 60]),
      96: new Uint8Array([38, 40, 211, 45, 60, 22, 67, 33, 0, 223, 249, 228]),
      128: new Uint8Array([
        41, 100, 128, 160, 40, 29, 167, 253, 201, 42, 99, 0, 110, 206, 121, 229,
      ]),
    },
    256: {
      64: new Uint8Array([207, 100, 186, 166, 40, 99, 3, 95]),
      96: new Uint8Array([
        236, 138, 105, 139, 103, 2, 228, 34, 208, 41, 194, 207,
      ]),
      128: new Uint8Array([
        24, 55, 212, 244, 32, 63, 152, 91, 36, 12, 75, 66, 69, 145, 236, 130,
      ]),
    },
  };

  return {
    plaintext,
    keyBytes,
    iv,
    additionalData,
    tag,
    tag_with_empty_ad,
    ciphertext,
  };
}
