// This file was generated by `prost-build` using a temporary build.rs file
// with the following contents:
//
// fn main() {
//     prost_build::compile_protos(&["src/stability_report.proto"], &["src/"]).unwrap();
// }
//
// With the following proto file in the src directory:
// https://source.chromium.org/chromium/chromium/src/+/main:components/stability_report/stability_report.proto;drc=6d7dcaddf6fd4270adeaca0113a772a9285a694b
// The generated file was pulled from the output directory and the unused code
// was removed for clarity.

/// The state of a process.
/// Next id: 8
///
/// Fields that were removed in <https://crrev.com/c/4265975.>
/// reserved 1, 2, 5, 6;
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ProcessState {
    /// The identifier of the process.
    #[prost(int64, optional, tag = "3")]
    pub process_id: ::core::option::Option<i64>,
    #[prost(message, optional, tag = "4")]
    pub memory_state: ::core::option::Option<process_state::MemoryState>,
    #[prost(message, optional, tag = "7")]
    pub file_system_state: ::core::option::Option<process_state::FileSystemState>,
}
/// Nested message and enum types in `ProcessState`.
pub mod process_state {
    /// Records the state of process memory at the time of crash.
    /// Next id: 6
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct MemoryState {
        #[prost(message, optional, tag = "1")]
        pub windows_memory: ::core::option::Option<memory_state::WindowsMemory>,
    }
    /// Nested message and enum types in `MemoryState`.
    pub mod memory_state {
        #[derive(Clone, Copy, PartialEq, ::prost::Message)]
        pub struct WindowsMemory {
            /// The private byte usage of the process. Unit is 4K pages.
            #[prost(uint32, optional, tag = "1")]
            pub process_private_usage: ::core::option::Option<u32>,
            /// The peak working set usage of the process. Unit is 4K pages.
            #[prost(uint32, optional, tag = "2")]
            pub process_peak_workingset_size: ::core::option::Option<u32>,
            /// The peak pagefile usage of the process. Unit is 4K pages.
            #[prost(uint32, optional, tag = "3")]
            pub process_peak_pagefile_usage: ::core::option::Option<u32>,
            /// The allocation request that caused OOM bytes.
            #[prost(uint32, optional, tag = "4")]
            pub process_allocation_attempt: ::core::option::Option<u32>,
        }
    }
    /// Records the state of the file system at the time of crash.
    /// Next id: 3
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct FileSystemState {
        #[prost(message, optional, tag = "1")]
        pub posix_file_system_state:
            ::core::option::Option<file_system_state::PosixFileSystemState>,
        #[prost(message, optional, tag = "2")]
        pub windows_file_system_state:
            ::core::option::Option<file_system_state::WindowsFileSystemState>,
    }
    /// Nested message and enum types in `FileSystemState`.
    pub mod file_system_state {
        #[derive(Clone, Copy, PartialEq, ::prost::Message)]
        pub struct PosixFileSystemState {
            /// The number of open file descriptors in the crashing process.
            #[prost(uint32, optional, tag = "1")]
            pub open_file_descriptors: ::core::option::Option<u32>,
        }
        #[derive(Clone, Copy, PartialEq, ::prost::Message)]
        pub struct WindowsFileSystemState {
            /// The number of open handles in the process.
            #[prost(uint32, optional, tag = "1")]
            pub process_handle_count: ::core::option::Option<u32>,
        }
    }
}
/// Records the state of system memory at the time of crash.
/// Next id: 2
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct SystemMemoryState {
    #[prost(message, optional, tag = "1")]
    pub windows_memory: ::core::option::Option<system_memory_state::WindowsMemory>,
}
/// Nested message and enum types in `SystemMemoryState`.
pub mod system_memory_state {
    #[derive(Clone, Copy, PartialEq, ::prost::Message)]
    pub struct WindowsMemory {
        /// The system commit limit. Unit is number of 4K pages.
        #[prost(uint32, optional, tag = "1")]
        pub system_commit_limit: ::core::option::Option<u32>,
        /// The amount of system commit remaining. Unit is number of 4K pages.
        #[prost(uint32, optional, tag = "2")]
        pub system_commit_remaining: ::core::option::Option<u32>,
        /// The current number of open handles.
        #[prost(uint32, optional, tag = "3")]
        pub system_handle_count: ::core::option::Option<u32>,
    }
}
/// A stability report contains information pertaining to the execution of a
/// single logical instance of a "chrome browser". It is comprised of information
/// about the system state and about the chrome browser's processes.
/// Next id: 9
///
/// Fields that were removed in <https://crrev.com/c/4265975.>
/// reserved 1, 3 to 6, 8;
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StabilityReport {
    /// State pertaining to Chrome's processes.
    #[prost(message, repeated, tag = "2")]
    pub process_states: ::prost::alloc::vec::Vec<ProcessState>,
    /// System-wide resource usage.
    #[prost(message, optional, tag = "7")]
    pub system_memory_state: ::core::option::Option<SystemMemoryState>,
}
