use serde::Serialize;
use utoipa::openapi::security::{HttpAuthScheme, HttpBuilder, SecurityScheme};

#[derive(Debug, Serialize)]
pub struct OpenApiAuth;

impl utoipa::Modify for OpenApiAuth {
    fn modify(&self, openapi: &mut utoipa::openapi::OpenApi) {
        if let Some(schema) = openapi.components.as_mut() {
            schema.add_security_scheme(
                "Bearer",
                SecurityScheme::Http(
                    HttpBuilder::new()
                        .scheme(HttpAuthScheme::Bearer)
                        .bearer_format("Uuidv4, string or JWT")
                        .description(Some(
"An API key is a token that you provide when making API calls. Include the token in a header parameter called `Authorization`.
Example: `Authorization: Bearer 8fece4405662dd830e4cb265e7e047aab2e79672a760a12712d2a263c9003509`"))
                        .build(),
                ),
            );
        }
    }
}
