/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */
#include <aws/crt/Api.h>
#include <aws/crt/crypto/HKDF.h>
#include <aws/testing/aws_test_harness.h>

static int s_TestHKDFPiping(struct aws_allocator *allocator, void *)
{
    Aws::Crt::ApiHandle apiHandle(allocator);

    uint8_t ikm[] = {0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
                     0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b};
    Aws::Crt::ByteCursor ikm_cur = aws_byte_cursor_from_array(ikm, sizeof(ikm));

    uint8_t salt[] = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c};
    Aws::Crt::ByteCursor salt_cur = aws_byte_cursor_from_array(salt, sizeof(salt));

    uint8_t info[] = {0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9};
    Aws::Crt::ByteCursor info_cur = aws_byte_cursor_from_array(info, sizeof(info));

    uint8_t output[64] = {0};
    Aws::Crt::ByteBuf ret = Aws::Crt::ByteBufFromEmptyArray(output, sizeof(output));

    ASSERT_TRUE(Aws::Crt::Crypto::DeriveSHA512HMACHKDF(allocator, ikm_cur, salt_cur, info_cur, ret, 42));

    uint8_t expected[] = {0x83, 0x23, 0x90, 0x08, 0x6c, 0xda, 0x71, 0xfb, 0x47, 0x62, 0x5b, 0xb5, 0xce, 0xb1,
                          0x68, 0xe4, 0xc8, 0xe2, 0x6a, 0x1a, 0x16, 0xed, 0x34, 0xd9, 0xfc, 0x7f, 0xe9, 0x2c,
                          0x14, 0x81, 0x57, 0x93, 0x38, 0xda, 0x36, 0x2c, 0xb8, 0xd9, 0xf9, 0x25, 0xd7, 0xcb};

    ASSERT_BIN_ARRAYS_EQUALS(ret.buffer, ret.len, expected, sizeof(expected));

    return AWS_OP_SUCCESS;
}
AWS_TEST_CASE(HKDFPiping, s_TestHKDFPiping)
