# @HEADER
# *****************************************************************************
#            TriBITS: Tribal Build, Integrate, and Test System
#
# Copyright 2013-2016 NTESS and the TriBITS contributors.
# SPDX-License-Identifier: BSD-3-Clause
# *****************************************************************************
# @HEADER

##############################################################################
#
# CMake variable for use by Trilinos/RTOp clients.
#
# Do not edit: This file was generated automatically by CMake.
#
##############################################################################

if(CMAKE_VERSION VERSION_LESS 3.3)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE
    "RTOp requires CMake 3.3 or later for 'if (... IN_LIST ...)'"
    )
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND FALSE)
  return()
endif()
cmake_minimum_required(VERSION 3.3...3.23.0)

## ---------------------------------------------------------------------------
## Compilers used by Trilinos/RTOp build
## ---------------------------------------------------------------------------

set(RTOp_CXX_COMPILER "C:/msys64/clangarm64/bin/clang++.exe")

set(RTOp_C_COMPILER "C:/msys64/clangarm64/bin/clang.exe")

set(RTOp_Fortran_COMPILER "C:/msys64/clangarm64/bin/flang.exe")
# Deprecated!
set(RTOp_FORTRAN_COMPILER "C:/msys64/clangarm64/bin/flang.exe") 


## ---------------------------------------------------------------------------
## Compiler flags used by Trilinos/RTOp build
## ---------------------------------------------------------------------------

## Give the build type
set(RTOp_CMAKE_BUILD_TYPE "Release")

## Set compiler flags, including those determined by build type
set(RTOp_CXX_FLAGS [[ ]])

set(RTOp_C_FLAGS [[-O2 -pipe -Wp,-D_FORTIFY_SOURCE=2 -fstack-protector-strong -Wp,-D__USE_MINGW_ANSI_STDIO=1 ]])

set(RTOp_Fortran_FLAGS [[ ]])
# Deprecated
set(RTOp_FORTRAN_FLAGS [[ ]])

## Extra link flags (e.g., specification of fortran libraries)
set(RTOp_EXTRA_LD_FLAGS [[]])

## This is the command-line entry used for setting rpaths. In a build
## with static libraries it will be empty.
set(RTOp_SHARED_LIB_RPATH_COMMAND "/clangarm64/lib")
set(RTOp_BUILD_SHARED_LIBS "ON")

set(RTOp_LINKER C:/msys64/clangarm64/bin/ld.lld.exe)
set(RTOp_AR C:/msys64/clangarm64/bin/llvm-ar.exe)

## ---------------------------------------------------------------------------
## Set library specifications and paths
## ---------------------------------------------------------------------------

## Base install location (if not in the build tree)
set(RTOp_INSTALL_DIR "/clangarm64")

## List of package libraries
set(RTOp_LIBRARIES RTOp::all_libs)

## ---------------------------------------------------------------------------
## MPI specific variables
##   These variables are provided to make it easier to get the mpi libraries
##   and includes on systems that do not use the mpi wrappers for compiling
## ---------------------------------------------------------------------------

set(RTOp_MPI_LIBRARIES "")
set(RTOp_MPI_LIBRARY_DIRS "")
set(RTOp_MPI_INCLUDE_DIRS "")
set(RTOp_MPI_EXEC "")
set(RTOp_MPI_EXEC_MAX_NUMPROCS "")
set(RTOp_MPI_EXEC_NUMPROCS_FLAG "")

## ---------------------------------------------------------------------------
## Set useful general variables
## ---------------------------------------------------------------------------

# Enables/Disables for upstream package dependencies
set(RTOp_ENABLE_TeuchosCore ON)
set(RTOp_ENABLE_TeuchosComm ON)
set(RTOp_ENABLE_TeuchosNumerics ON)

# Exported cache variables
set(RTOp_ENABLE_DEBUG "OFF")
set(HAVE_RTOP_DEBUG "OFF")
set(RTOp_ENABLE_EXPLICIT_INSTANTIATION "ON")
set(HAVE_RTOP_EXPLICIT_INSTANTIATION "ON")

# Include configuration of dependent packages
if (NOT TARGET TeuchosCore::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../TeuchosCore/TeuchosCoreConfig.cmake")
endif()
if (NOT TARGET TeuchosComm::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../TeuchosComm/TeuchosCommConfig.cmake")
endif()
if (NOT TARGET TeuchosNumerics::all_libs)
  include("${CMAKE_CURRENT_LIST_DIR}/../TeuchosNumerics/TeuchosNumericsConfig.cmake")
endif()

# Import RTOp targets
include("${CMAKE_CURRENT_LIST_DIR}/RTOpTargets.cmake")

# Standard TriBITS-compliant external package variables
set(RTOp_IS_TRIBITS_COMPLIANT TRUE)
set(RTOp_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")
set(RTOp_TRIBITS_COMPLIANT_PACKAGE_CONFIG_FILE_DIR "${CMAKE_CURRENT_LIST_DIR}")


## ----------------------------------------------------------------------------
## Create deprecated non-namespaced library targets for backwards compatibility
## ----------------------------------------------------------------------------

set(RTOp_EXPORTED_PACKAGE_LIBS_NAMES "rtop")

foreach(libname IN LISTS RTOp_EXPORTED_PACKAGE_LIBS_NAMES)
  if (NOT TARGET ${libname})
    add_library(${libname} INTERFACE IMPORTED)
    target_link_libraries(${libname}
       INTERFACE RTOp::${libname})
    set(deprecationMessage
      "WARNING: The non-namespaced target '${libname}' is deprecated!"
      "  If always using newer versions of the project 'Trilinos', then use the"
      " new namespaced target 'RTOp::${libname}', or better yet,"
      " 'RTOp::all_libs' to be less sensitive to changes in the definition"
      " of targets in the package 'RTOp'.  Or, to maintain compatibility with"
      " older or newer versions the project 'Trilinos', instead link against the"
      " libraries specified by the variable 'RTOp_LIBRARIES'."
      )
    string(REPLACE ";" "" deprecationMessage "${deprecationMessage}")
    set_target_properties(${libname}
      PROPERTIES DEPRECATION "${deprecationMessage}" )
  endif()
endforeach()
