%feature("docstring") OT::ImportanceSamplingExperiment
"Importance Sampling experiment.

Available constructors:
    ImportanceSamplingExperiment(*importanceDistribution*)

    ImportanceSamplingExperiment(*importanceDistribution, size*)

    ImportanceSamplingExperiment(*initialDistribution, importanceDistribution, size*)

Parameters
----------
initialDistribution : :class:`~openturns.Distribution`
    Distribution :math:`\\mu` which is the initial distribution used to generate the
    set of input data.
size : positive int
    Number of points that will be generated in the experiment.
importanceDistribution : :class:`~openturns.Distribution`
    Distribution :math:`p` according to which the points of the 
    experiments will be generated with the Importance Sampling technique.

Notes
-----
ImportanceSamplingExperiment is a random weighted design of experiments to get a sample 
:math:`(X_i)_{1 \\leq i \\leq size}`
independently according to the distribution :math:`\\mu`. 
The sample is generated from the importance distribution :math:`p` and each realization is weighted by   
:math:`\\frac{\\mu(X_i)}{p(X_i)}`

See also
--------
WeightedExperiment

Examples
--------
>>> import openturns as ot
>>> ot.RandomGenerator.SetSeed(0)
>>> distribution = ot.ComposedDistribution([ot.Uniform(0, 1)] * 2)
>>> importanceDistribution = ot.ComposedDistribution([ot.Uniform(0, 1)] * 2)
>>> experiment = ot.ImportanceSamplingExperiment(distribution, importanceDistribution, 5)
>>> print(experiment.generate())
    [ X0        X1        ]
0 : [ 0.629877  0.882805  ]
1 : [ 0.135276  0.0325028 ]
2 : [ 0.347057  0.969423  ]
3 : [ 0.92068   0.50304   ]
4 : [ 0.0632061 0.292757  ]"

// ---------------------------------------------------------------------

%feature("docstring") OT::WeightedExperiment::getImportanceDistribution
"Accessor to the importance distribution.

Returns
-------
importanceDistribution : :class:`~openturns.Distribution`
    Distribution :math:`p` according to which the points of the design of
    experiments will be generated with the Importance Sampling technique."
