
# COPYRIGHT (C) 2021-2024 Nicotine+ Contributors
#
# GNU GENERAL PUBLIC LICENSE
#    Version 3, 29 June 2007
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import sys

def load_module():

    try:
        import pynicotine

    except ImportError:
        print("""Cannot find the pynicotine module.
Perhaps it is installed in a folder which is not in Python's module search
path. There could be a version mismatch between the Python version that was
used to build the application binary package and the version you try to run
the application with.""")
        return 1

    return pynicotine.run()


if __name__ == "__main__":
    sys.exit(load_module())
