/* libsoup-3.0.vapi generated by vapigen.EXE, do not modify. */

[CCode (cprefix = "Soup", gir_namespace = "Soup", gir_version = "3.0", lower_case_cprefix = "soup_")]
namespace Soup {
	namespace Form {
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static GLib.HashTable<weak string,weak string> decode (string encoded_form);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static GLib.HashTable<weak string,weak string>? decode_multipart (owned Soup.Multipart multipart, string? file_control_name, out string filename, out string content_type, out GLib.Bytes file);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static string encode (...);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static string encode_datalist (GLib.Datalist<string> form_data_set);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static string encode_hash (GLib.HashTable<string,string> form_data_set);
		[CCode (cheader_filename = "libsoup/soup.h")]
		public static string encode_valist (string first_field, va_list args);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_get_type ()")]
	public abstract class Auth : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Auth ();
		public virtual void authenticate (string username, string password);
		public virtual bool can_authenticate ();
		public void cancel ();
		public unowned string get_authority ();
		public virtual string get_authorization (Soup.Message msg);
		public string get_info ();
		public virtual GLib.SList<string> get_protection_space (GLib.Uri source_uri);
		public unowned string get_realm ();
		public unowned string get_scheme_name ();
		public virtual bool is_ready (Soup.Message msg);
		public static Soup.Auth? @new (GLib.Type type, Soup.Message msg, string auth_header);
		public virtual bool update (Soup.Message msg, GLib.HashTable<void*,void*> auth_header);
		[NoAccessorMethod]
		public string authority { owned get; set; }
		[NoAccessorMethod]
		public virtual bool is_authenticated { get; }
		[NoAccessorMethod]
		public bool is_cancelled { get; }
		[NoAccessorMethod]
		public bool is_for_proxy { get; set; }
		[NoAccessorMethod]
		public string realm { owned get; set; }
		public string scheme_name { get; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_basic_get_type ()")]
	public sealed class AuthBasic : Soup.Auth {
		[CCode (has_construct_function = false)]
		protected AuthBasic ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_digest_get_type ()")]
	public sealed class AuthDigest : Soup.Auth {
		[CCode (has_construct_function = false)]
		protected AuthDigest ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_domain_get_type ()")]
	public abstract class AuthDomain : GLib.Object {
		[CCode (has_construct_function = false)]
		protected AuthDomain ();
		[NoWrapper]
		public virtual string accepts (Soup.ServerMessage msg, string header);
		[CCode (cname = "soup_auth_domain_accepts")]
		public string? accepts_authorization (Soup.ServerMessage msg);
		public void add_path (string path);
		public virtual string challenge (Soup.ServerMessage msg);
		public virtual bool check_password (Soup.ServerMessage msg, string username, string password);
		public bool covers (Soup.ServerMessage msg);
		public unowned string get_realm ();
		public void remove_path (string path);
		public void set_filter (owned Soup.AuthDomainFilter filter);
		public void set_generic_auth_callback (owned Soup.AuthDomainGenericAuthCallback auth_callback);
		[NoAccessorMethod]
		public Soup.AuthDomainFilter filter { get; set; }
		[NoAccessorMethod]
		public void* filter_data { get; set; }
		[NoAccessorMethod]
		public Soup.AuthDomainGenericAuthCallback generic_auth_callback { get; set; }
		[NoAccessorMethod]
		public void* generic_auth_data { get; set; }
		[NoAccessorMethod]
		public bool proxy { get; construct; }
		public string realm { get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_domain_basic_get_type ()")]
	public sealed class AuthDomainBasic : Soup.AuthDomain {
		[CCode (has_construct_function = false, type = "SoupAuthDomain*")]
		public AuthDomainBasic (string optname1, ...);
		public void set_auth_callback (owned Soup.AuthDomainBasicAuthCallback callback);
		[NoAccessorMethod]
		public Soup.AuthDomainBasicAuthCallback auth_callback { get; set; }
		[NoAccessorMethod]
		public void* auth_data { get; set; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_domain_digest_get_type ()")]
	public sealed class AuthDomainDigest : Soup.AuthDomain {
		[CCode (has_construct_function = false, type = "SoupAuthDomain*")]
		public AuthDomainDigest (string optname1, ...);
		public static string encode_password (string username, string realm, string password);
		public void set_auth_callback (owned Soup.AuthDomainDigestAuthCallback callback);
		[NoAccessorMethod]
		public Soup.AuthDomainDigestAuthCallback auth_callback { get; set; }
		[NoAccessorMethod]
		public void* auth_data { get; set; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_manager_get_type ()")]
	public sealed class AuthManager : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		protected AuthManager ();
		public void clear_cached_credentials ();
		public void use_auth (GLib.Uri uri, Soup.Auth auth);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_ntlm_get_type ()")]
	public sealed class AuthNTLM : Soup.Auth {
		[CCode (has_construct_function = false)]
		protected AuthNTLM ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_auth_negotiate_get_type ()")]
	public sealed class AuthNegotiate : Soup.Auth {
		[CCode (has_construct_function = false)]
		protected AuthNegotiate ();
		public static bool supported ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_cache_get_type ()")]
	public class Cache : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		public Cache (string? cache_dir, Soup.CacheType cache_type);
		public void clear ();
		public void dump ();
		public void flush ();
		[NoWrapper]
		public virtual Soup.Cacheability get_cacheability (Soup.Message msg);
		public uint get_max_size ();
		public void load ();
		public void set_max_size (uint max_size);
		[NoAccessorMethod]
		public string cache_dir { owned get; construct; }
		[NoAccessorMethod]
		public Soup.CacheType cache_type { get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_content_decoder_get_type ()")]
	public sealed class ContentDecoder : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		protected ContentDecoder ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_content_sniffer_get_type ()")]
	public sealed class ContentSniffer : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		public ContentSniffer ();
		public string sniff (Soup.Message msg, GLib.Bytes buffer, out GLib.HashTable<string,string>? @params);
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_cookie_get_type ()")]
	[Compact]
	public class Cookie {
		[CCode (has_construct_function = false)]
		public Cookie (string name, string value, string domain, string path, int max_age);
		public bool applies_to_uri (GLib.Uri uri);
		public Soup.Cookie copy ();
		public bool domain_matches (string host);
		public bool equal (Soup.Cookie cookie2);
		public void free ();
		public unowned string get_domain ();
		public unowned GLib.DateTime? get_expires ();
		public bool get_http_only ();
		public unowned string get_name ();
		public unowned string get_path ();
		public Soup.SameSitePolicy get_same_site_policy ();
		public bool get_secure ();
		public unowned string get_value ();
		public static Soup.Cookie? parse (string header, GLib.Uri? origin);
		public void set_domain (string domain);
		public void set_expires (GLib.DateTime expires);
		public void set_http_only (bool http_only);
		public void set_max_age (int max_age);
		public void set_name (string name);
		public void set_path (string path);
		public void set_same_site_policy (Soup.SameSitePolicy policy);
		public void set_secure (bool secure);
		public void set_value (string value);
		public string to_cookie_header ();
		public string to_set_cookie_header ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_cookie_jar_get_type ()")]
	public class CookieJar : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		public CookieJar ();
		public void add_cookie (owned Soup.Cookie cookie);
		public void add_cookie_full (owned Soup.Cookie cookie, GLib.Uri? uri, GLib.Uri? first_party);
		public void add_cookie_with_first_party (GLib.Uri first_party, owned Soup.Cookie cookie);
		public GLib.SList<Soup.Cookie> all_cookies ();
		public void delete_cookie (Soup.Cookie cookie);
		public Soup.CookieJarAcceptPolicy get_accept_policy ();
		public GLib.SList<Soup.Cookie> get_cookie_list (GLib.Uri uri, bool for_http);
		public GLib.SList<Soup.Cookie> get_cookie_list_with_same_site_info (GLib.Uri uri, GLib.Uri? top_level, GLib.Uri? site_for_cookies, bool for_http, bool is_safe_method, bool is_top_level_navigation);
		public string? get_cookies (GLib.Uri uri, bool for_http);
		public virtual bool is_persistent ();
		[NoWrapper]
		public virtual void save ();
		public void set_accept_policy (Soup.CookieJarAcceptPolicy policy);
		public void set_cookie (GLib.Uri uri, string cookie);
		public void set_cookie_with_first_party (GLib.Uri uri, GLib.Uri first_party, string cookie);
		public Soup.CookieJarAcceptPolicy accept_policy { get; set; }
		[NoAccessorMethod]
		public bool read_only { get; construct; }
		public virtual signal void changed (Soup.Cookie? old_cookie, Soup.Cookie? new_cookie);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_cookie_jar_db_get_type ()")]
	public sealed class CookieJarDB : Soup.CookieJar, Soup.SessionFeature {
		[CCode (has_construct_function = false, type = "SoupCookieJar*")]
		public CookieJarDB (string filename, bool read_only);
		[NoAccessorMethod]
		public string filename { owned get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_cookie_jar_text_get_type ()")]
	public sealed class CookieJarText : Soup.CookieJar, Soup.SessionFeature {
		[CCode (has_construct_function = false, type = "SoupCookieJar*")]
		public CookieJarText (string filename, bool read_only);
		[NoAccessorMethod]
		public string filename { owned get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_hsts_enforcer_get_type ()")]
	public class HSTSEnforcer : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		public HSTSEnforcer ();
		public GLib.List<string> get_domains (bool session_policies);
		public GLib.List<Soup.HSTSPolicy> get_policies (bool session_policies);
		public virtual bool has_valid_policy (string domain);
		public virtual bool is_persistent ();
		public void set_policy (Soup.HSTSPolicy policy);
		public void set_session_policy (string domain, bool include_subdomains);
		public virtual signal void changed (Soup.HSTSPolicy old_policy, Soup.HSTSPolicy new_policy);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_hsts_enforcer_db_get_type ()")]
	public sealed class HSTSEnforcerDB : Soup.HSTSEnforcer, Soup.SessionFeature {
		[CCode (has_construct_function = false, type = "SoupHSTSEnforcer*")]
		public HSTSEnforcerDB (string filename);
		[NoAccessorMethod]
		public string filename { owned get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_hsts_policy_get_type ()")]
	[Compact]
	public class HSTSPolicy {
		[CCode (has_construct_function = false)]
		public HSTSPolicy (string domain, ulong max_age, bool include_subdomains);
		public Soup.HSTSPolicy copy ();
		public bool equal (Soup.HSTSPolicy policy2);
		[DestroysInstance]
		public void free ();
		[CCode (has_construct_function = false)]
		public HSTSPolicy.from_response (Soup.Message msg);
		[CCode (has_construct_function = false)]
		public HSTSPolicy.full (string domain, ulong max_age, GLib.DateTime expires, bool include_subdomains);
		public unowned string get_domain ();
		public GLib.DateTime get_expires ();
		public ulong get_max_age ();
		public bool includes_subdomains ();
		public bool is_expired ();
		public bool is_session_policy ();
		[CCode (has_construct_function = false)]
		public HSTSPolicy.session_policy (string domain, bool include_subdomains);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_logger_get_type ()")]
	public sealed class Logger : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		public Logger (Soup.LoggerLogLevel level);
		public int get_max_body_size ();
		public void set_max_body_size (int max_body_size);
		public void set_printer (owned Soup.LoggerPrinter printer);
		public void set_request_filter (owned Soup.LoggerFilter request_filter);
		public void set_response_filter (owned Soup.LoggerFilter response_filter);
		[NoAccessorMethod]
		public Soup.LoggerLogLevel level { get; set; }
		public int max_body_size { get; set construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_message_get_type ()")]
	public sealed class Message : GLib.Object {
		[CCode (has_construct_function = false)]
		public Message (string method, string uri_string);
		public void add_flags (Soup.MessageFlags flags);
		public uint add_header_handler (string @signal, string header, GLib.Callback callback, void* user_data);
		public uint add_status_code_handler (string @signal, uint status_code, GLib.Callback callback, void* user_data);
		public void disable_feature (GLib.Type feature_type);
		[CCode (has_construct_function = false)]
		public Message.from_encoded_form (string method, string uri_string, owned string encoded_form);
		[CCode (has_construct_function = false)]
		public Message.from_multipart (string uri_string, Soup.Multipart multipart);
		[CCode (has_construct_function = false)]
		public Message.from_uri (string method, GLib.Uri uri);
		public uint64 get_connection_id ();
		public unowned GLib.Uri get_first_party ();
		public Soup.MessageFlags get_flags ();
		[Version (since = "3.4")]
		public bool get_force_http1 ();
		public Soup.HTTPVersion get_http_version ();
		public bool get_is_options_ping ();
		public bool get_is_top_level_navigation ();
		public unowned string get_method ();
		public unowned Soup.MessageMetrics? get_metrics ();
		public Soup.MessagePriority get_priority ();
		public unowned string? get_reason_phrase ();
		public unowned GLib.SocketAddress? get_remote_address ();
		public unowned Soup.MessageHeaders get_request_headers ();
		public unowned Soup.MessageHeaders get_response_headers ();
		public unowned GLib.Uri get_site_for_cookies ();
		public Soup.Status get_status ();
		public unowned string get_tls_ciphersuite_name ();
		public unowned GLib.TlsCertificate? get_tls_peer_certificate ();
		public GLib.TlsCertificateFlags get_tls_peer_certificate_errors ();
		public GLib.TlsProtocolVersion get_tls_protocol_version ();
		public unowned GLib.Uri get_uri ();
		public bool is_feature_disabled (GLib.Type feature_type);
		public bool is_keepalive ();
		[CCode (has_construct_function = false)]
		public Message.options_ping (GLib.Uri base_uri);
		public bool query_flags (Soup.MessageFlags flags);
		public void remove_flags (Soup.MessageFlags flags);
		public void set_first_party (GLib.Uri first_party);
		public void set_flags (Soup.MessageFlags flags);
		[Version (since = "3.4")]
		public void set_force_http1 (bool value);
		public void set_is_options_ping (bool is_options_ping);
		public void set_is_top_level_navigation (bool is_top_level_navigation);
		public void set_method (string method);
		public void set_priority (Soup.MessagePriority priority);
		public void set_request_body (string? content_type, GLib.InputStream? stream, ssize_t content_length);
		public void set_request_body_from_bytes (string? content_type, GLib.Bytes? bytes);
		public void set_site_for_cookies (GLib.Uri? site_for_cookies);
		public void set_tls_client_certificate (GLib.TlsCertificate? certificate);
		public void set_uri (GLib.Uri uri);
		public void tls_client_certificate_password_request_complete ();
		public GLib.Uri first_party { get; set; }
		public Soup.MessageFlags flags { get; set; }
		public Soup.HTTPVersion http_version { get; }
		public bool is_options_ping { get; set; }
		public bool is_top_level_navigation { get; set; }
		public string method { get; set; }
		public Soup.MessagePriority priority { get; set; }
		public string reason_phrase { get; }
		public GLib.SocketAddress remote_address { get; }
		public Soup.MessageHeaders request_headers { get; }
		public Soup.MessageHeaders response_headers { get; }
		public GLib.Uri site_for_cookies { get; set; }
		[NoAccessorMethod]
		public uint status_code { get; }
		public string tls_ciphersuite_name { get; }
		public GLib.TlsCertificate tls_peer_certificate { get; }
		public GLib.TlsCertificateFlags tls_peer_certificate_errors { get; }
		public GLib.TlsProtocolVersion tls_protocol_version { get; }
		public GLib.Uri uri { get; set; }
		public signal bool accept_certificate (GLib.TlsCertificate tls_peer_certificate, GLib.TlsCertificateFlags tls_peer_errors);
		public signal bool authenticate (Soup.Auth auth, bool retrying);
		public signal void content_sniffed (string type, GLib.HashTable<string,string> @params);
		public signal void finished ();
		public signal void got_body ();
		[Version (since = "3.4")]
		public signal void got_body_data (uint chunk_size);
		public signal void got_headers ();
		public signal void got_informational ();
		public signal void hsts_enforced ();
		public signal void network_event (GLib.SocketClientEvent event, GLib.IOStream connection);
		public signal bool request_certificate (GLib.TlsClientConnection tls_connection);
		public signal bool request_certificate_password (GLib.TlsPassword tls_password);
		public signal void restarted ();
		public signal void starting ();
		public signal void wrote_body ();
		public signal void wrote_body_data (uint chunk_size);
		public signal void wrote_headers ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", ref_function = "soup_message_body_ref", type_id = "soup_message_body_get_type ()", unref_function = "soup_message_body_unref")]
	[Compact]
	public class MessageBody {
		[CCode (array_length_cname = "length", array_length_type = "gint64")]
		public weak uint8[] data;
		public int64 length;
		[CCode (has_construct_function = false)]
		public MessageBody ();
		[Version (deprecated = true, deprecated_since = "2.32", replacement = "MessageBody.append_take")]
		public void append (Soup.MemoryUse use, [CCode (array_length_cname = "length", array_length_pos = 2.1, array_length_type = "gsize")] uint8[] data);
		public void append_bytes (GLib.Bytes buffer);
		public void append_take ([CCode (array_length_cname = "length", array_length_pos = 1.1, array_length_type = "gsize")] owned uint8[] data);
		public void complete ();
		public GLib.Bytes flatten ();
		public bool get_accumulate ();
		public GLib.Bytes? get_chunk (int64 offset);
		public void got_chunk (GLib.Bytes chunk);
		public Soup.MessageBody @ref ();
		public void set_accumulate (bool accumulate);
		public void truncate ();
		public void unref ();
		public void wrote_chunk (GLib.Bytes chunk);
	}
	[CCode (cheader_filename = "libsoup/soup.h", ref_function = "soup_message_headers_ref", type_id = "soup_message_headers_get_type ()", unref_function = "soup_message_headers_unref")]
	[Compact]
	public class MessageHeaders {
		[CCode (has_construct_function = false)]
		public MessageHeaders (Soup.MessageHeadersType type);
		public void append (string name, string value);
		public void clean_connection_headers ();
		public void clear ();
		public void @foreach (Soup.MessageHeadersForeachFunc func);
		public void free_ranges (Soup.Range ranges);
		public bool get_content_disposition (out string disposition, out GLib.HashTable<string,string> @params);
		public int64 get_content_length ();
		public bool get_content_range (out int64 start, out int64 end, out int64 total_length);
		public unowned string? get_content_type (out GLib.HashTable<string,string> @params);
		public Soup.Encoding get_encoding ();
		public Soup.Expectation get_expectations ();
		public Soup.MessageHeadersType get_headers_type ();
		public unowned string? get_list (string name);
		public unowned string? get_one (string name);
		public bool get_ranges (int64 total_length, [CCode (array_length_cname = "length", array_length_pos = 2.1)] out Soup.Range[] ranges);
		public bool header_contains (string name, string token);
		public bool header_equals (string name, string value);
		public Soup.MessageHeaders @ref ();
		public void remove (string name);
		public void replace (string name, string value);
		public void set_content_disposition (string disposition, GLib.HashTable<string,string>? @params);
		public void set_content_length (int64 content_length);
		public void set_content_range (int64 start, int64 end, int64 total_length);
		public void set_content_type (string content_type, GLib.HashTable<string,string>? @params);
		public void set_encoding (Soup.Encoding encoding);
		public void set_expectations (Soup.Expectation expectations);
		public void set_range (int64 start, int64 end);
		public void set_ranges (Soup.Range ranges, int length);
		public void unref ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_message_metrics_get_type ()")]
	[Compact]
	public class MessageMetrics {
		public Soup.MessageMetrics copy ();
		public void free ();
		public uint64 get_connect_end ();
		public uint64 get_connect_start ();
		public uint64 get_dns_end ();
		public uint64 get_dns_start ();
		public uint64 get_fetch_start ();
		public uint64 get_request_body_bytes_sent ();
		public uint64 get_request_body_size ();
		public uint64 get_request_header_bytes_sent ();
		public uint64 get_request_start ();
		public uint64 get_response_body_bytes_received ();
		public uint64 get_response_body_size ();
		public uint64 get_response_end ();
		public uint64 get_response_header_bytes_received ();
		public uint64 get_response_start ();
		public uint64 get_tls_start ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "soup_multipart_get_type ()")]
	[Compact]
	public class Multipart {
		[CCode (has_construct_function = false)]
		public Multipart (string mime_type);
		public void append_form_file (string control_name, string? filename, string? content_type, GLib.Bytes body);
		public void append_form_string (string control_name, string data);
		public void append_part (Soup.MessageHeaders headers, GLib.Bytes body);
		public void free ();
		[CCode (has_construct_function = false)]
		public Multipart.from_message (Soup.MessageHeaders headers, GLib.Bytes body);
		public int get_length ();
		public bool get_part (int part, out unowned Soup.MessageHeaders headers, out unowned GLib.Bytes body);
		public void to_message (Soup.MessageHeaders dest_headers, out GLib.Bytes dest_body);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_multipart_input_stream_get_type ()")]
	public sealed class MultipartInputStream : GLib.FilterInputStream, GLib.PollableInputStream {
		[CCode (has_construct_function = false)]
		public MultipartInputStream (Soup.Message msg, GLib.InputStream base_stream);
		public unowned Soup.MessageHeaders? get_headers ();
		public GLib.InputStream? next_part (GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async GLib.InputStream? next_part_async (int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoAccessorMethod]
		public Soup.Message message { owned get; construct; }
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_server_get_type ()")]
	public class Server : GLib.Object {
		[CCode (has_construct_function = false)]
		public Server (string optname1, ...);
		public bool accept_iostream (GLib.IOStream stream, GLib.SocketAddress? local_addr, GLib.SocketAddress? remote_addr) throws GLib.Error;
		public void add_auth_domain (Soup.AuthDomain auth_domain);
		public void add_early_handler (string? path, owned Soup.ServerCallback callback);
		public void add_handler (string? path, owned Soup.ServerCallback callback);
		public void add_websocket_extension (GLib.Type extension_type);
		public void add_websocket_handler (string? path, string? origin, [CCode (array_length = false, array_null_terminated = true)] string[]? protocols, owned Soup.ServerWebsocketCallback callback);
		public void disconnect ();
		public GLib.SList<weak GLib.Socket> get_listeners ();
		public GLib.TlsAuthenticationMode get_tls_auth_mode ();
		public unowned GLib.TlsCertificate? get_tls_certificate ();
		public unowned GLib.TlsDatabase? get_tls_database ();
		public GLib.SList<GLib.Uri> get_uris ();
		public bool is_https ();
		public bool listen (GLib.SocketAddress address, Soup.ServerListenOptions options) throws GLib.Error;
		public bool listen_all (uint port, Soup.ServerListenOptions options) throws GLib.Error;
		public bool listen_local (uint port, Soup.ServerListenOptions options) throws GLib.Error;
		public bool listen_socket (GLib.Socket socket, Soup.ServerListenOptions options) throws GLib.Error;
		[Version (deprecated = true, deprecated_since = "3.2")]
		public void pause_message (Soup.ServerMessage msg);
		public void remove_auth_domain (Soup.AuthDomain auth_domain);
		public void remove_handler (string path);
		public void remove_websocket_extension (GLib.Type extension_type);
		public void set_tls_auth_mode (GLib.TlsAuthenticationMode mode);
		public void set_tls_certificate (GLib.TlsCertificate certificate);
		public void set_tls_database (GLib.TlsDatabase tls_database);
		[Version (deprecated = true, deprecated_since = "3.2")]
		public void unpause_message (Soup.ServerMessage msg);
		[NoAccessorMethod]
		public bool raw_paths { get; construct; }
		[NoAccessorMethod]
		public string server_header { owned get; set construct; }
		public GLib.TlsAuthenticationMode tls_auth_mode { get; set construct; }
		public GLib.TlsCertificate tls_certificate { get; set construct; }
		public GLib.TlsDatabase tls_database { get; set construct; }
		public virtual signal void request_aborted (Soup.ServerMessage msg);
		public virtual signal void request_finished (Soup.ServerMessage msg);
		public virtual signal void request_read (Soup.ServerMessage msg);
		public virtual signal void request_started (Soup.ServerMessage msg);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_server_message_get_type ()")]
	public sealed class ServerMessage : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ServerMessage ();
		public Soup.HTTPVersion get_http_version ();
		public unowned GLib.SocketAddress? get_local_address ();
		public unowned string get_method ();
		public unowned string? get_reason_phrase ();
		public unowned GLib.SocketAddress? get_remote_address ();
		public unowned string? get_remote_host ();
		public unowned Soup.MessageBody get_request_body ();
		public unowned Soup.MessageHeaders get_request_headers ();
		public unowned Soup.MessageBody get_response_body ();
		public unowned Soup.MessageHeaders get_response_headers ();
		public unowned GLib.Socket? get_socket ();
		public uint get_status ();
		[Version (since = "3.2")]
		public unowned GLib.TlsCertificate? get_tls_peer_certificate ();
		[Version (since = "3.2")]
		public GLib.TlsCertificateFlags get_tls_peer_certificate_errors ();
		public unowned GLib.Uri get_uri ();
		public bool is_options_ping ();
		[Version (since = "3.2")]
		public void pause ();
		public void set_http_version (Soup.HTTPVersion version);
		public void set_redirect (uint status_code, string redirect_uri);
		public void set_response (string? content_type, Soup.MemoryUse resp_use, [CCode (array_length_cname = "resp_length", array_length_pos = 3.1, array_length_type = "gsize")] uint8[]? resp_body);
		public void set_status (uint status_code, string? reason_phrase);
		public GLib.IOStream steal_connection ();
		[Version (since = "3.2")]
		public void unpause ();
		[Version (since = "3.2")]
		public GLib.TlsCertificate tls_peer_certificate { get; }
		[Version (since = "3.2")]
		public GLib.TlsCertificateFlags tls_peer_certificate_errors { get; }
		public signal bool accept_certificate (GLib.TlsCertificate tls_peer_certificate, GLib.TlsCertificateFlags tls_peer_errors);
		public signal void connected ();
		public signal void disconnected ();
		public signal void finished ();
		public signal void got_body ();
		public signal void got_chunk (GLib.Bytes chunk);
		public signal void got_headers ();
		public signal void wrote_body ();
		public signal void wrote_body_data (uint chunk_size);
		public signal void wrote_chunk ();
		public signal void wrote_headers ();
		public signal void wrote_informational ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_session_get_type ()")]
	public class Session : GLib.Object {
		[CCode (has_construct_function = false)]
		public Session ();
		public void abort ();
		public void add_feature (Soup.SessionFeature feature);
		public void add_feature_by_type (GLib.Type feature_type);
		public unowned string? get_accept_language ();
		public bool get_accept_language_auto ();
		public unowned Soup.Message? get_async_result_message (GLib.AsyncResult result);
		public unowned Soup.SessionFeature? get_feature (GLib.Type feature_type);
		public unowned Soup.SessionFeature? get_feature_for_message (GLib.Type feature_type, Soup.Message msg);
		public uint get_idle_timeout ();
		public unowned GLib.InetSocketAddress? get_local_address ();
		public uint get_max_conns ();
		public uint get_max_conns_per_host ();
		public unowned GLib.ProxyResolver? get_proxy_resolver ();
		public unowned GLib.SocketConnectable? get_remote_connectable ();
		public uint get_timeout ();
		public unowned GLib.TlsDatabase? get_tls_database ();
		public unowned GLib.TlsInteraction? get_tls_interaction ();
		public unowned string? get_user_agent ();
		public bool has_feature (GLib.Type feature_type);
		public async bool preconnect_async (Soup.Message msg, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		public void remove_feature (Soup.SessionFeature feature);
		public void remove_feature_by_type (GLib.Type feature_type);
		public GLib.InputStream send (Soup.Message msg, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public GLib.Bytes send_and_read (Soup.Message msg, GLib.Cancellable? cancellable = null) throws GLib.Error;
		public async GLib.Bytes send_and_read_async (Soup.Message msg, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		[Version (since = "3.4")]
		public ssize_t send_and_splice (Soup.Message msg, GLib.OutputStream out_stream, GLib.OutputStreamSpliceFlags flags, GLib.Cancellable? cancellable = null) throws GLib.Error;
		[Version (since = "3.4")]
		public async ssize_t send_and_splice_async (Soup.Message msg, GLib.OutputStream out_stream, GLib.OutputStreamSpliceFlags flags, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		public async GLib.InputStream send_async (Soup.Message msg, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_accept_language (string accept_language);
		public void set_accept_language_auto (bool accept_language_auto);
		public void set_idle_timeout (uint timeout);
		public void set_proxy_resolver (GLib.ProxyResolver? proxy_resolver);
		public void set_timeout (uint timeout);
		public void set_tls_database (GLib.TlsDatabase? tls_database);
		public void set_tls_interaction (GLib.TlsInteraction? tls_interaction);
		public void set_user_agent (string user_agent);
		public async Soup.WebsocketConnection websocket_connect_async (Soup.Message msg, string? origin, [CCode (array_length = false, array_null_terminated = true)] string[]? protocols, int io_priority, GLib.Cancellable? cancellable) throws GLib.Error;
		[CCode (has_construct_function = false)]
		public Session.with_options (string optname1, ...);
		public string accept_language { get; set; }
		public bool accept_language_auto { get; set; }
		public uint idle_timeout { get; set; }
		public GLib.InetSocketAddress local_address { get; construct; }
		public int max_conns { get; construct; }
		public int max_conns_per_host { get; construct; }
		public GLib.ProxyResolver proxy_resolver { get; set; }
		public GLib.SocketConnectable remote_connectable { get; construct; }
		public uint timeout { get; set; }
		public GLib.TlsDatabase tls_database { get; set; }
		public GLib.TlsInteraction tls_interaction { get; set; }
		public string user_agent { get; set; }
		public virtual signal void request_queued (Soup.Message msg);
		public virtual signal void request_unqueued (Soup.Message msg);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_websocket_connection_get_type ()")]
	public sealed class WebsocketConnection : GLib.Object {
		[CCode (has_construct_function = false)]
		public WebsocketConnection (GLib.IOStream stream, GLib.Uri uri, Soup.WebsocketConnectionType type, string? origin, string? protocol, owned GLib.List<Soup.WebsocketExtension> extensions);
		public void close (ushort code, string? data);
		public ushort get_close_code ();
		public unowned string get_close_data ();
		public Soup.WebsocketConnectionType get_connection_type ();
		public unowned GLib.List<Soup.WebsocketExtension> get_extensions ();
		public unowned GLib.IOStream get_io_stream ();
		public uint get_keepalive_interval ();
		[Version (since = "3.6")]
		public uint get_keepalive_pong_timeout ();
		public uint64 get_max_incoming_payload_size ();
		public unowned string? get_origin ();
		public unowned string? get_protocol ();
		public Soup.WebsocketState get_state ();
		public unowned GLib.Uri get_uri ();
		public void send_binary ([CCode (array_length_cname = "length", array_length_pos = 1.1, array_length_type = "gsize")] uint8[]? data);
		public void send_message (Soup.WebsocketDataType type, GLib.Bytes message);
		public void send_text (string text);
		public void set_keepalive_interval (uint interval);
		[Version (since = "3.6")]
		public void set_keepalive_pong_timeout (uint pong_timeout);
		public void set_max_incoming_payload_size (uint64 max_incoming_payload_size);
		public Soup.WebsocketConnectionType connection_type { get; construct; }
		public void* extensions { get; construct; }
		public GLib.IOStream io_stream { get; construct; }
		public uint keepalive_interval { get; set construct; }
		[Version (since = "3.6")]
		public uint keepalive_pong_timeout { get; set construct; }
		public uint64 max_incoming_payload_size { get; set construct; }
		public string origin { get; construct; }
		public string protocol { get; construct; }
		public Soup.WebsocketState state { get; }
		public GLib.Uri uri { get; construct; }
		public signal void closed ();
		public signal void closing ();
		public signal void error (GLib.Error error);
		public signal void message (int type, GLib.Bytes message);
		public signal void pong (GLib.Bytes message);
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_websocket_extension_get_type ()")]
	public abstract class WebsocketExtension : GLib.Object {
		[CCode (has_construct_function = false)]
		protected WebsocketExtension ();
		public virtual bool configure (Soup.WebsocketConnectionType connection_type, GLib.HashTable<void*,void*>? @params) throws GLib.Error;
		public virtual string? get_request_params ();
		public virtual string? get_response_params ();
		public virtual GLib.Bytes process_incoming_message (ref uint8 header, owned GLib.Bytes payload) throws GLib.Error;
		public virtual GLib.Bytes process_outgoing_message (ref uint8 header, owned GLib.Bytes payload) throws GLib.Error;
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_websocket_extension_deflate_get_type ()")]
	public sealed class WebsocketExtensionDeflate : Soup.WebsocketExtension {
		[CCode (has_construct_function = false)]
		protected WebsocketExtensionDeflate ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_id = "soup_websocket_extension_manager_get_type ()")]
	public sealed class WebsocketExtensionManager : GLib.Object, Soup.SessionFeature {
		[CCode (has_construct_function = false)]
		protected WebsocketExtensionManager ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", type_cname = "SoupSessionFeatureInterface", type_id = "soup_session_feature_get_type ()")]
	public interface SessionFeature : GLib.Object {
	}
	[CCode (cheader_filename = "libsoup/soup.h", has_type_id = false)]
	public struct MessageHeadersIter {
		public void init (Soup.MessageHeaders hdrs);
		public static bool next (ref Soup.MessageHeadersIter iter, out unowned string name, out unowned string value);
	}
	[CCode (cheader_filename = "libsoup/soup.h", has_type_id = false)]
	public struct Range {
		public int64 start;
		public int64 end;
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_CACHE_", type_id = "soup_cache_type_get_type ()")]
	public enum CacheType {
		SINGLE_USER,
		SHARED
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_CACHE_", type_id = "soup_cacheability_get_type ()")]
	[Flags]
	public enum Cacheability {
		CACHEABLE,
		UNCACHEABLE,
		INVALIDATES,
		VALIDATES
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_COOKIE_JAR_ACCEPT_", type_id = "soup_cookie_jar_accept_policy_get_type ()")]
	public enum CookieJarAcceptPolicy {
		ALWAYS,
		NEVER,
		NO_THIRD_PARTY,
		GRANDFATHERED_THIRD_PARTY
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_DATE_", type_id = "soup_date_format_get_type ()")]
	public enum DateFormat {
		HTTP,
		COOKIE
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_ENCODING_", type_id = "soup_encoding_get_type ()")]
	public enum Encoding {
		UNRECOGNIZED,
		NONE,
		CONTENT_LENGTH,
		EOF,
		CHUNKED,
		BYTERANGES
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_EXPECTATION_", type_id = "soup_expectation_get_type ()")]
	[Flags]
	public enum Expectation {
		UNRECOGNIZED,
		CONTINUE
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_HTTP_", type_id = "soup_http_version_get_type ()")]
	public enum HTTPVersion {
		@1_0,
		@1_1,
		@2_0
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_LOGGER_LOG_", type_id = "soup_logger_log_level_get_type ()")]
	public enum LoggerLogLevel {
		NONE,
		MINIMAL,
		HEADERS,
		BODY
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_MEMORY_", type_id = "soup_memory_use_get_type ()")]
	public enum MemoryUse {
		STATIC,
		TAKE,
		COPY
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_MESSAGE_", type_id = "soup_message_flags_get_type ()")]
	[Flags]
	public enum MessageFlags {
		NO_REDIRECT,
		NEW_CONNECTION,
		IDEMPOTENT,
		DO_NOT_USE_AUTH_CACHE,
		COLLECT_METRICS
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_MESSAGE_HEADERS_", type_id = "soup_message_headers_type_get_type ()")]
	public enum MessageHeadersType {
		REQUEST,
		RESPONSE,
		MULTIPART
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_MESSAGE_PRIORITY_", type_id = "soup_message_priority_get_type ()")]
	public enum MessagePriority {
		VERY_LOW,
		LOW,
		NORMAL,
		HIGH,
		VERY_HIGH
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_SAME_SITE_POLICY_", type_id = "soup_same_site_policy_get_type ()")]
	public enum SameSitePolicy {
		NONE,
		LAX,
		STRICT
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_SERVER_LISTEN_", type_id = "soup_server_listen_options_get_type ()")]
	[Flags]
	public enum ServerListenOptions {
		HTTPS,
		IPV4_ONLY,
		IPV6_ONLY
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_STATUS_", type_id = "soup_status_get_type ()")]
	public enum Status {
		NONE,
		CONTINUE,
		SWITCHING_PROTOCOLS,
		PROCESSING,
		OK,
		CREATED,
		ACCEPTED,
		NON_AUTHORITATIVE,
		NO_CONTENT,
		RESET_CONTENT,
		PARTIAL_CONTENT,
		MULTI_STATUS,
		MULTIPLE_CHOICES,
		MOVED_PERMANENTLY,
		FOUND,
		MOVED_TEMPORARILY,
		SEE_OTHER,
		NOT_MODIFIED,
		USE_PROXY,
		NOT_APPEARING_IN_THIS_PROTOCOL,
		TEMPORARY_REDIRECT,
		PERMANENT_REDIRECT,
		BAD_REQUEST,
		UNAUTHORIZED,
		PAYMENT_REQUIRED,
		FORBIDDEN,
		NOT_FOUND,
		METHOD_NOT_ALLOWED,
		NOT_ACCEPTABLE,
		PROXY_AUTHENTICATION_REQUIRED,
		PROXY_UNAUTHORIZED,
		REQUEST_TIMEOUT,
		CONFLICT,
		GONE,
		LENGTH_REQUIRED,
		PRECONDITION_FAILED,
		REQUEST_ENTITY_TOO_LARGE,
		REQUEST_URI_TOO_LONG,
		UNSUPPORTED_MEDIA_TYPE,
		REQUESTED_RANGE_NOT_SATISFIABLE,
		INVALID_RANGE,
		EXPECTATION_FAILED,
		MISDIRECTED_REQUEST,
		UNPROCESSABLE_ENTITY,
		LOCKED,
		FAILED_DEPENDENCY,
		INTERNAL_SERVER_ERROR,
		NOT_IMPLEMENTED,
		BAD_GATEWAY,
		SERVICE_UNAVAILABLE,
		GATEWAY_TIMEOUT,
		HTTP_VERSION_NOT_SUPPORTED,
		INSUFFICIENT_STORAGE,
		NOT_EXTENDED;
		public static unowned string get_phrase (uint status_code);
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_URI_", type_id = "soup_uri_component_get_type ()")]
	public enum URIComponent {
		NONE,
		SCHEME,
		USER,
		PASSWORD,
		AUTH_PARAMS,
		HOST,
		PORT,
		PATH,
		QUERY,
		FRAGMENT
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_WEBSOCKET_CLOSE_", type_id = "soup_websocket_close_code_get_type ()")]
	public enum WebsocketCloseCode {
		NORMAL,
		GOING_AWAY,
		PROTOCOL_ERROR,
		UNSUPPORTED_DATA,
		NO_STATUS,
		ABNORMAL,
		BAD_DATA,
		POLICY_VIOLATION,
		TOO_BIG,
		NO_EXTENSION,
		SERVER_ERROR,
		TLS_HANDSHAKE
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_WEBSOCKET_CONNECTION_", type_id = "soup_websocket_connection_type_get_type ()")]
	public enum WebsocketConnectionType {
		UNKNOWN,
		CLIENT,
		SERVER
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_WEBSOCKET_DATA_", type_id = "soup_websocket_data_type_get_type ()")]
	public enum WebsocketDataType {
		TEXT,
		BINARY
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_WEBSOCKET_STATE_", type_id = "soup_websocket_state_get_type ()")]
	public enum WebsocketState {
		OPEN,
		CLOSING,
		CLOSED
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_SESSION_ERROR_", type_id = "soup_session_error_get_type ()")]
	public errordomain SessionError {
		PARSING,
		ENCODING,
		TOO_MANY_REDIRECTS,
		TOO_MANY_RESTARTS,
		REDIRECT_NO_LOCATION,
		REDIRECT_BAD_URI,
		MESSAGE_ALREADY_IN_QUEUE;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_TLD_ERROR_", type_id = "soup_tld_error_get_type ()")]
	public errordomain TLDError {
		INVALID_HOSTNAME,
		IS_IP_ADDRESS,
		NOT_ENOUGH_DOMAINS,
		NO_BASE_DOMAIN,
		NO_PSL_DATA;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", cprefix = "SOUP_WEBSOCKET_ERROR_", type_id = "soup_websocket_error_get_type ()")]
	public errordomain WebsocketError {
		FAILED,
		NOT_WEBSOCKET,
		BAD_HANDSHAKE,
		BAD_ORIGIN;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 4.9)]
	public delegate bool AuthDomainBasicAuthCallback (Soup.AuthDomainBasic domain, Soup.ServerMessage msg, string username, string password);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 3.9)]
	public delegate string? AuthDomainDigestAuthCallback (Soup.AuthDomainDigest domain, Soup.ServerMessage msg, string username);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 2.9)]
	public delegate bool AuthDomainFilter (Soup.AuthDomain domain, Soup.ServerMessage msg);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 3.9)]
	public delegate bool AuthDomainGenericAuthCallback (Soup.AuthDomain domain, Soup.ServerMessage msg, string username);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 2.9)]
	public delegate Soup.LoggerLogLevel LoggerFilter (Soup.Logger logger, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 4.9)]
	public delegate void LoggerPrinter (Soup.Logger logger, Soup.LoggerLogLevel level, char direction, string data);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 2.9)]
	public delegate void MessageHeadersForeachFunc (string name, string value);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 4.9)]
	public delegate void ServerCallback (Soup.Server server, Soup.ServerMessage msg, string path, GLib.HashTable<string,string>? query);
	[CCode (cheader_filename = "libsoup/soup.h", instance_pos = 4.9)]
	public delegate void ServerWebsocketCallback (Soup.Server server, Soup.ServerMessage msg, string path, Soup.WebsocketConnection connection);
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_MAX_AGE_ONE_DAY")]
	public const int COOKIE_MAX_AGE_ONE_DAY;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_MAX_AGE_ONE_HOUR")]
	public const int COOKIE_MAX_AGE_ONE_HOUR;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_MAX_AGE_ONE_WEEK")]
	public const int COOKIE_MAX_AGE_ONE_WEEK;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_COOKIE_MAX_AGE_ONE_YEAR")]
	public const int COOKIE_MAX_AGE_ONE_YEAR;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_FORM_MIME_TYPE_MULTIPART")]
	public const string FORM_MIME_TYPE_MULTIPART;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_FORM_MIME_TYPE_URLENCODED")]
	public const string FORM_MIME_TYPE_URLENCODED;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_HSTS_POLICY_MAX_AGE_PAST")]
	public const int HSTS_POLICY_MAX_AGE_PAST;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_HTTP_URI_FLAGS")]
	public const int HTTP_URI_FLAGS;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MAJOR_VERSION")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MICRO_VERSION")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_MINOR_VERSION")]
	public const int MINOR_VERSION;
	[CCode (cheader_filename = "libsoup/soup.h", cname = "SOUP_VERSION_MIN_REQUIRED")]
	public const int VERSION_MIN_REQUIRED;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool check_version (uint major, uint minor, uint micro);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Version (replacement = "Cookie.parse")]
	public static Soup.Cookie? cookie_parse (string header, GLib.Uri? origin);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.SList<Soup.Cookie> cookies_from_request (Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.SList<Soup.Cookie> cookies_from_response (Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static string cookies_to_cookie_header (GLib.SList<Soup.Cookie> cookies);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void cookies_to_request (GLib.SList<Soup.Cookie> cookies, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void cookies_to_response (GLib.SList<Soup.Cookie> cookies, Soup.Message msg);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.DateTime? date_time_new_from_http_string (string date_string);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static string date_time_to_string (GLib.DateTime date, Soup.DateFormat format);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static uint get_major_version ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static uint get_micro_version ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static uint get_minor_version ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool header_contains (string header, string token);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void header_free_param_list (GLib.HashTable<string,string> param_list);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void header_g_string_append_param (GLib.StringBuilder string, string name, string? value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void header_g_string_append_param_quoted (GLib.StringBuilder string, string name, string value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.SList<string> header_parse_list (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.HashTable<string,string> header_parse_param_list (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.HashTable<string,string>? header_parse_param_list_strict (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.SList<string> header_parse_quality_list (string header, out GLib.SList<string> unacceptable);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.HashTable<string,string> header_parse_semi_param_list (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.HashTable<string,string>? header_parse_semi_param_list_strict (string header);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool headers_parse (string str, int len, Soup.MessageHeaders dest);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static uint headers_parse_request (string str, int len, Soup.MessageHeaders req_headers, out string req_method, out string req_path, out Soup.HTTPVersion ver);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool headers_parse_response (string str, int len, Soup.MessageHeaders headers, out Soup.HTTPVersion ver, out uint status_code, out string reason_phrase);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool headers_parse_status_line (string status_line, out Soup.HTTPVersion ver, out uint status_code, out string reason_phrase);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Version (replacement = "MessageHeadersIter.init")]
	public static void message_headers_iter_init (out Soup.MessageHeadersIter iter, Soup.MessageHeaders hdrs);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Version (replacement = "MessageHeadersIter.next")]
	public static bool message_headers_iter_next (ref Soup.MessageHeadersIter iter, out unowned string name, out unowned string value);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Version (replacement = "SessionError.quark")]
	public static GLib.Quark session_error_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Version (replacement = "Status.get_phrase")]
	public static unowned string status_get_phrase (uint status_code);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool tld_domain_is_public_suffix (string domain);
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Version (replacement = "TLDError.quark")]
	public static GLib.Quark tld_error_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static unowned string tld_get_base_domain (string hostname) throws GLib.Error;
	[CCode (cheader_filename = "libsoup/soup.h", sentinel = "SOUP_URI_NONE")]
	public static GLib.Uri uri_copy (GLib.Uri uri, ...);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static GLib.Bytes uri_decode_data_uri (string uri, out string? content_type);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool uri_equal (GLib.Uri uri1, GLib.Uri uri2);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static void websocket_client_prepare_handshake (Soup.Message msg, string? origin, [CCode (array_length = false, array_null_terminated = true)] string[]? protocols, GLib.GenericArray<GLib.TypeClass>? supported_extensions);
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool websocket_client_verify_handshake (Soup.Message msg, GLib.GenericArray<GLib.TypeClass>? supported_extensions, out GLib.List<Soup.WebsocketExtension> accepted_extensions) throws GLib.Error;
	[CCode (cheader_filename = "libsoup/soup.h")]
	[Version (replacement = "WebsocketError.quark")]
	public static GLib.Quark websocket_error_quark ();
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool websocket_server_check_handshake (Soup.ServerMessage msg, string? origin, [CCode (array_length = false, array_null_terminated = true)] string[]? protocols, GLib.GenericArray<GLib.TypeClass>? supported_extensions) throws GLib.Error;
	[CCode (cheader_filename = "libsoup/soup.h")]
	public static bool websocket_server_process_handshake (Soup.ServerMessage msg, string? expected_origin, [CCode (array_length = false, array_null_terminated = true)] string[]? protocols, GLib.GenericArray<GLib.TypeClass>? supported_extensions, out GLib.List<Soup.WebsocketExtension> accepted_extensions);
}
