/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.UIManager;
import org.netbeans.api.actions.Openable;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.Removable;
import org.netbeans.modules.search.ui.FileObjectPropertySet;
import org.netbeans.modules.search.ui.HideResultAction;
import org.netbeans.modules.search.ui.MoreAction;
import org.netbeans.modules.search.ui.OpenMatchingObjectsAction;
import org.netbeans.modules.search.ui.RefreshAction;
import org.netbeans.modules.search.ui.ReplaceCheckableNode;
import org.netbeans.modules.search.ui.ResultsOutlineSupport;
import org.netbeans.modules.search.ui.SelectInAction;
import org.netbeans.modules.search.ui.UiUtils;
import org.openide.awt.Actions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class MatchingObjectNode
extends AbstractNode
implements Removable {
    private static final String INVALID_ICON = "org/netbeans/modules/search/res/invalid.png";
    private static final String WARNING_ICON = "org/netbeans/modules/search/res/warning.gif";
    private static RequestProcessor RP = new RequestProcessor("MatchingObjectNode");
    private MatchingObject matchingObject;
    private Node original;
    private OrigNodeListener origNodeListener;
    private boolean valid = true;
    private PropertyChangeListener validityListener;
    private PropertyChangeListener selectionListener;
    private final boolean replacing;
    Node.PropertySet[] propertySets;

    public MatchingObjectNode(Node node, Children children, MatchingObject matchingObject, boolean bl) {
        this(node, children, matchingObject, new ReplaceCheckableNode(matchingObject, bl));
    }

    private MatchingObjectNode(Node node, Children children, MatchingObject matchingObject, ReplaceCheckableNode replaceCheckableNode) {
        super(children, MatchingObjectNode.createLookup(matchingObject, replaceCheckableNode));
        this.replacing = replaceCheckableNode.isCheckable();
        Parameters.notNull((CharSequence)"original", (Object)node);
        this.matchingObject = matchingObject;
        if (matchingObject.isObjectValid()) {
            this.original = node;
            this.setValidOriginal();
            this.origNodeListener = new OrigNodeListener();
            node.addNodeListener((NodeListener)this.origNodeListener);
        } else {
            this.setInvalidOriginal();
        }
        this.validityListener = new ValidityListener(matchingObject);
        matchingObject.addPropertyChangeListener("invalidityStatus", this.validityListener);
        this.selectionListener = new SelectionListener();
        matchingObject.addPropertyChangeListener(this.selectionListener);
    }

    private static Lookup createLookup(MatchingObject matchingObject, ReplaceCheckableNode replaceCheckableNode) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(matchingObject);
        arrayList.add(replaceCheckableNode);
        arrayList.add(matchingObject.getFileObject());
        arrayList.add(matchingObject.getDataObject());
        Openable openable = (Openable)matchingObject.getDataObject().getLookup().lookup(Openable.class);
        if (openable != null) {
            arrayList.add(openable);
        }
        return Lookups.fixed((Object[])arrayList.toArray());
    }

    public PasteType getDropType(Transferable transferable, int n, int n2) {
        return null;
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
    }

    public Transferable clipboardCopy() throws IOException {
        return this.original.clipboardCopy();
    }

    public Transferable clipboardCut() throws IOException {
        return this.original.clipboardCut();
    }

    public boolean canCopy() {
        return this.original.canCopy();
    }

    public boolean canCut() {
        return this.original.canCut();
    }

    public boolean canRename() {
        return this.original.canRename();
    }

    public void setName(String string) {
        this.original.setName(string);
    }

    public String getName() {
        return this.original.getName();
    }

    public Transferable drag() throws IOException {
        return UiUtils.DISABLE_TRANSFER;
    }

    public Image getIcon(int n) {
        if (this.valid) {
            return this.original.getIcon(n);
        }
        MatchingObject.InvalidityStatus invalidityStatus = this.matchingObject.getInvalidityStatus();
        String string = invalidityStatus == null || invalidityStatus == MatchingObject.InvalidityStatus.DELETED ? INVALID_ICON : WARNING_ICON;
        return ImageUtilities.loadImage((String)string);
    }

    public Action[] getActions(boolean bl) {
        if (!bl) {
            Action action = Actions.forID((String)"Edit", (String)"org.netbeans.modules.utilities.CopyPathToClipboard");
            return new Action[]{SystemAction.get(OpenMatchingObjectsAction.class), this.replacing && !this.matchingObject.isObjectValid() ? new RefreshAction(this.matchingObject) : null, null, action == null ? new CopyPathAction() : action, SystemAction.get(HideResultAction.class), null, SystemAction.get(SelectInAction.class), SystemAction.get(MoreAction.class)};
        }
        return new Action[0];
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public String getHtmlDisplayName() {
        if (this.valid) {
            return this.original.getHtmlDisplayName();
        }
        return this.getInvalidHtmlDisplayName();
    }

    public String getDisplayName() {
        return this.original.getDisplayName();
    }

    public String getShortDescription() {
        return this.matchingObject.getFileObject().getPath();
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenMatchingObjectsAction.class);
    }

    private void setValidOriginal() {
        this.fireIconChange();
        this.fireDisplayNameChange(null, null);
    }

    private void resetValidOriginal() {
        try {
            this.valid = true;
            this.original = this.matchingObject.getDataObject().getNodeDelegate();
            this.setValidOriginal();
        }
        catch (NullPointerException nullPointerException) {
            this.setInvalidOriginal();
        }
    }

    private void setInvalidOriginal() {
        if (!this.valid) {
            this.fireIconChange();
            return;
        }
        this.valid = false;
        if (this.origNodeListener != null && this.original != null) {
            this.original.removeNodeListener((NodeListener)this.origNodeListener);
            this.origNodeListener = null;
        }
        String string = this.original == null ? null : this.original.getDisplayName();
        this.original = new AbstractNode(Children.LEAF){

            public String getHtmlDisplayName() {
                return MatchingObjectNode.this.getInvalidHtmlDisplayName();
            }
        };
        this.original.setDisplayName(this.matchingObject.getFileObject().getNameExt());
        this.fireIconChange();
        this.fireDisplayNameChange(string, this.matchingObject.getFileObject().getNameExt());
    }

    public void clean() {
        if (this.original != null && this.origNodeListener != null && this.valid) {
            this.original.removeNodeListener((NodeListener)this.origNodeListener);
        }
        if (this.validityListener != null) {
            this.matchingObject.removePropertyChangeListener("invalidityStatus", this.validityListener);
            this.validityListener = null;
        }
        if (this.selectionListener != null) {
            this.matchingObject.removePropertyChangeListener("selected", this.selectionListener);
            this.selectionListener = null;
        }
    }

    private String getInvalidHtmlDisplayName() {
        Color color = UIManager.getColor("nb.search.sandbox.regexp.wrong");
        Color color2 = color == null ? Color.RED : color;
        String string = Integer.toHexString(color2.getRGB());
        String string2 = string.substring(2, 8);
        return "<html><font color='#" + string2 + "'>" + this.getDisplayName() + "</font></html>";
    }

    public synchronized Node.PropertySet[] getPropertySets() {
        if (this.propertySets == null) {
            Node.PropertySet propertySet;
            this.propertySets = new Node.PropertySet[2];
            this.propertySets[0] = propertySet = new Node.PropertySet(){

                public Node.Property<?>[] getProperties() {
                    Node.Property[] propertyArray = new Node.Property[]{new DetailsCountProperty()};
                    return propertyArray;
                }
            };
            this.propertySets[1] = new FileObjectPropertySet(this.matchingObject.getFileObject());
        }
        return this.propertySets;
    }

    @Override
    public void remove() {
        this.matchingObject.remove();
    }

    public boolean canDestroy() {
        return this.original.canDestroy();
    }

    public void destroy() throws IOException {
        this.original.destroy();
    }

    private void checkFileObjectValid() {
        FileObject fileObject = this.matchingObject.getFileObject();
        if (fileObject != null && fileObject.isValid()) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                this.matchingObject.updateDataObject(dataObject);
                this.valid = dataObject.isValid();
                if (this.valid) {
                    EventQueue.invokeLater(this::resetValidOriginal);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    private class SelectionListener
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MatchingObjectNode.this.fireIconChange();
            ResultsOutlineSupport.toggleParentSelected(MatchingObjectNode.this.getParentNode());
        }
    }

    private class ValidityListener
    implements PropertyChangeListener {
        private final MatchingObject matchingObject;

        public ValidityListener(MatchingObject matchingObject) {
            this.matchingObject = matchingObject;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EventQueue.invokeLater(() -> {
                if (this.matchingObject.getInvalidityStatus() == null) {
                    MatchingObjectNode.this.resetValidOriginal();
                    MatchingObjectNode.this.setChildren(this.matchingObject.getDetailsChildren(true));
                } else {
                    MatchingObjectNode.this.setInvalidOriginal();
                }
            });
        }
    }

    private class CopyPathAction
    extends AbstractAction {
        public CopyPathAction() {
            super(UiUtils.getText("LBL_CopyFilePathAction"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = FileUtil.toFile((FileObject)MatchingObjectNode.this.matchingObject.getFileObject());
            if (file != null) {
                Object object;
                String string = file.getPath();
                Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(ExClipboard.class);
                if (clipboard == null && (object = Toolkit.getDefaultToolkit()) != null) {
                    clipboard = ((Toolkit)object).getSystemClipboard();
                }
                if (clipboard != null) {
                    object = new StringSelection(string);
                    clipboard.setContents((Transferable)object, null);
                }
            }
        }
    }

    private class OrigNodeListener
    implements NodeListener {
        public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        }

        public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        }

        public void nodeDestroyed(NodeEvent nodeEvent) {
            EventQueue.invokeLater(() -> {
                MatchingObjectNode.this.setInvalidOriginal();
                RP.post(() -> MatchingObjectNode.this.checkFileObjectValid(), 2500);
            });
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MatchingObjectNode.this.setValidOriginal();
        }
    }

    private class DetailsCountProperty
    extends Node.Property<Integer> {
        public DetailsCountProperty() {
            super(Integer.class);
        }

        public boolean canRead() {
            return true;
        }

        public Integer getValue() throws IllegalAccessException, InvocationTargetException {
            return MatchingObjectNode.this.matchingObject.getDetailsCount();
        }

        public boolean canWrite() {
            return false;
        }

        public void setValue(Integer n) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            throw new UnsupportedOperationException();
        }

        public String getName() {
            return "detailsCount";
        }
    }
}

