\name{ComposeScaleSkewVersor3DTransform}
\alias{ComposeScaleSkewVersor3DTransform}
\title{ComposeScaleSkewVersor3DTransform}
\Rdversion{1.1}
\docType{class}
\description{
This transform applies a versor rotation and translation & scale/skew
to the space.
ComposeScaleSkewVersor3DTransform}
\details{
The transform can be described as: \eqn{ (\textbf{R}_v * \textbf{S} * \textbf{K})\textbf{x} } where \eqn{\textbf{R}_v} is the rotation matrix given the versor, where \eqn{\textbf{S}} is the diagonal scale matrix. where \eqn{\textbf{K}} is the upper triangle skew (shear) matrix.
See:
itk::ComposeScaleSkewVersor3DTransform
ComposeScaleSkewVersor3DTransform}
%C++ includes: sitkComposeScaleSkewVersor3DTransform.h
\section{Methods}{
\describe{
\item{ ComposeScaleSkewVersor3DTransform():}{}
\item{ ComposeScaleSkewVersor3DTransform(const ComposeScaleSkewVersor3DTransform &):}{}
\item{ ComposeScaleSkewVersor3DTransform(const std::vector< double > &scale, const std::vector< double > &skew, const std::vector< double > &axis, double angle, const std::vector< double > &translation=std::vector< double >(3, 0.0), const std::vector< double > &fixedCenter=std::vector< double >(3, 0.0)):}{}
\item{ ComposeScaleSkewVersor3DTransform(const std::vector< double > &scale, const std::vector< double > &skew, const std::vector< double > &versor, const std::vector< double > &translation=std::vector< double >(3, 0.0), const std::vector< double > &fixedCenter=std::vector< double >(3, 0.0)):}{}
\item{ ComposeScaleSkewVersor3DTransform(const Transform &):}{}
\item{std::vector< double > GetCenter() const:}{}
\item{std::vector< double > GetMatrix() const:}{}
\item{std::string GetName() const override:}{
Name of this class
}
\item{std::vector< double > GetScale() const:}{}
\item{std::vector< double > GetSkew() const:}{}
\item{std::vector< double > GetTranslation() const:}{}
\item{std::vector< double > GetVersor() const:}{}
\item{Self SetCenter(const std::vector< double > &params):}{
fixed parameter
}
\item{Self SetRotation(const std::vector< double > &axis, double angle):}{}
\item{Self SetRotation(const std::vector< double > &versor):}{
parameter
}
\item{Self SetScale(const std::vector< double > &scale):}{}
\item{Self SetSkew(const std::vector< double > &skew):}{}
\item{Self SetTranslation(const std::vector< double > &translation):}{}
\item{Self Translate(const std::vector< double > &offset):}{
additional methods
}
\item{ ~ComposeScaleSkewVersor3DTransform() override:}{}
}
}
