/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReader;
import org.opensearch.common.Nullable;
import org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.opensearch.common.lucene.index.OpenSearchLeafReader;
import org.opensearch.core.index.shard.ShardId;

public final class ShardUtils {
    private ShardUtils() {
    }

    @Nullable
    public static ShardId extractShardId(LeafReader reader) {
        OpenSearchLeafReader esReader = OpenSearchLeafReader.getOpenSearchLeafReader(reader);
        if (esReader != null) {
            assert (reader.getRefCount() > 0) : "OpenSearchLeafReader is already closed";
            return esReader.shardId();
        }
        return null;
    }

    @Nullable
    public static ShardId extractShardId(DirectoryReader reader) {
        OpenSearchDirectoryReader esReader = OpenSearchDirectoryReader.getOpenSearchDirectoryReader(reader);
        if (esReader != null) {
            return esReader.shardId();
        }
        throw new IllegalArgumentException("can't extract shard ID, can't unwrap OpenSearchDirectoryReader");
    }
}

