/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.KeywordValueLongI;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.XSKeyvalI;
import oracle.jdbc.driver.XSNamespaceI;
import oracle.jdbc.driver.XSPrincipalI;
import oracle.jdbc.driver.XSSecureIdI;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.XSKeyval;
import oracle.jdbc.internal.XSNamespace;
import oracle.jdbc.internal.XSPrincipal;
import oracle.jdbc.internal.XSSecureId;
import oracle.sql.TIMESTAMPTZ;

final class T4CTTIoxsatt
extends T4CTTIfun {
    private int opcode;
    private byte[] sessionId;
    private XSSecureId sidp;
    private byte[] cookie;
    private XSPrincipal username;
    private byte[][] disabledRolesBytes;
    private byte[][] enabledRolesBytes;
    private byte[][] externalRolesBytes;
    private XSNamespace[] namespaces;
    private XSNamespace[] cacheNamespace;
    private XSNamespace[] deleteNamespace;
    private TIMESTAMPTZ midTierTimestamp;
    private TIMESTAMPTZ authtime;
    private int roleVersion;
    private long inputFlag;
    private XSKeyval kv;
    private int[] roleVersionOutput;

    T4CTTIoxsatt(T4CConnection _conn) {
        super(_conn, (byte)3);
        this.setFunCode((short)180);
    }

    void doOXSATT(int opCode, byte[] sessionId, XSSecureId sidp, byte[] cookie, XSPrincipal username, String[] disabledRoles, String[] enabledRoles, String[] externalRoles, XSNamespace[] namespaces, XSNamespace[] cacheNamespace, XSNamespace[] deleteNamespace, TIMESTAMPTZ midTierTimestamp, TIMESTAMPTZ authtime, int roleVersion, long inputFlag, XSKeyval kv, int[] roleVersionOutput) throws IOException, SQLException {
        KeywordValueLong[] kvl;
        int i;
        this.opcode = opCode;
        this.sessionId = sessionId;
        this.sidp = sidp;
        this.cookie = cookie;
        this.username = username;
        if (username != null) {
            ((XSPrincipalI)username).doCharConversion(this.meg.conv);
        }
        if (disabledRoles != null && disabledRoles.length > 0) {
            this.disabledRolesBytes = new byte[disabledRoles.length][];
            for (i = 0; i < disabledRoles.length; ++i) {
                this.disabledRolesBytes[i] = (byte[])(disabledRoles[i] != null && disabledRoles[i].length() > 0 ? this.meg.conv.StringToCharBytes(disabledRoles[i]) : null);
            }
        } else {
            this.disabledRolesBytes = null;
        }
        if (enabledRoles != null && enabledRoles.length > 0) {
            this.enabledRolesBytes = new byte[enabledRoles.length][];
            for (i = 0; i < enabledRoles.length; ++i) {
                this.enabledRolesBytes[i] = (byte[])(enabledRoles[i] != null && enabledRoles[i].length() > 0 ? this.meg.conv.StringToCharBytes(enabledRoles[i]) : null);
            }
        } else {
            this.enabledRolesBytes = null;
        }
        if (externalRoles != null && externalRoles.length > 0) {
            this.externalRolesBytes = new byte[externalRoles.length][];
            for (i = 0; i < externalRoles.length; ++i) {
                this.externalRolesBytes[i] = (byte[])(externalRoles[i] != null && externalRoles[i].length() > 0 ? this.meg.conv.StringToCharBytes(externalRoles[i]) : null);
            }
        } else {
            this.externalRolesBytes = null;
        }
        this.namespaces = namespaces;
        if (namespaces != null) {
            for (i = 0; i < namespaces.length; ++i) {
                ((XSNamespaceI)namespaces[i]).doCharConversion(this.meg.conv);
            }
        }
        this.cacheNamespace = cacheNamespace;
        if (cacheNamespace != null) {
            for (i = 0; i < cacheNamespace.length; ++i) {
                ((XSNamespaceI)cacheNamespace[i]).doCharConversion(this.meg.conv);
            }
        }
        this.deleteNamespace = deleteNamespace;
        if (deleteNamespace != null) {
            for (i = 0; i < deleteNamespace.length; ++i) {
                ((XSNamespaceI)deleteNamespace[i]).doCharConversion(this.meg.conv);
            }
        }
        this.midTierTimestamp = midTierTimestamp;
        this.authtime = authtime;
        this.roleVersion = roleVersion;
        this.inputFlag = inputFlag;
        this.kv = kv;
        if (kv != null && (kvl = kv.getKeyval()) != null) {
            for (int i2 = 0; i2 < kvl.length; ++i2) {
                ((KeywordValueLongI)kvl[i2]).doCharConversion(this.meg.conv);
            }
        }
        this.roleVersionOutput = roleVersionOutput;
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        int i;
        this.meg.marshalUB4(this.opcode);
        boolean sendSessionId = false;
        if (this.sessionId != null && this.sessionId.length > 0) {
            sendSessionId = true;
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.sessionId.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        boolean sendSidp = false;
        if (this.sidp != null) {
            sendSidp = true;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        boolean sendcookie = false;
        if (this.cookie != null && this.cookie.length > 0) {
            sendcookie = true;
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.cookie.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        boolean sendUsername = false;
        if (this.username == null) {
            this.meg.marshalNULLPTR();
        } else {
            sendUsername = true;
            this.meg.marshalPTR();
        }
        if (this.disabledRolesBytes != null && this.disabledRolesBytes.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.disabledRolesBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.enabledRolesBytes != null && this.enabledRolesBytes.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.enabledRolesBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        if (this.externalRolesBytes != null && this.externalRolesBytes.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalUB4(this.externalRolesBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalUB4(0L);
        }
        boolean sendNamespaces = false;
        this.meg.marshalPTR();
        if (this.namespaces != null && this.namespaces.length > 0) {
            sendNamespaces = true;
            this.meg.marshalUB4(this.namespaces.length);
        } else {
            this.meg.marshalUB4(0L);
        }
        boolean sendCacheNamespace = false;
        this.meg.marshalPTR();
        if (this.cacheNamespace != null && this.cacheNamespace.length > 0) {
            sendCacheNamespace = true;
            this.meg.marshalUB4(this.cacheNamespace.length);
        } else {
            this.meg.marshalUB4(0L);
        }
        boolean sendDeleteNamespace = false;
        this.meg.marshalPTR();
        if (this.deleteNamespace != null && this.deleteNamespace.length > 0) {
            sendDeleteNamespace = true;
            this.meg.marshalUB4(this.deleteNamespace.length);
        } else {
            this.meg.marshalUB4(0L);
        }
        if (this.midTierTimestamp != null) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (this.authtime != null) {
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        this.meg.marshalPTR();
        this.meg.marshalUB4(this.inputFlag);
        boolean sendKv = false;
        if (this.kv != null) {
            sendKv = true;
            this.meg.marshalPTR();
        } else {
            this.meg.marshalNULLPTR();
        }
        if (sendSessionId) {
            this.meg.marshalB1Array(this.sessionId);
        }
        if (sendSidp) {
            ((XSSecureIdI)this.sidp).marshal(this.meg);
        }
        if (sendcookie) {
            this.meg.marshalB1Array(this.cookie);
        }
        if (sendUsername) {
            ((XSPrincipalI)this.username).marshal(this.meg);
        }
        if (this.disabledRolesBytes != null && this.disabledRolesBytes.length > 0) {
            for (i = 0; i < this.disabledRolesBytes.length; ++i) {
                if (this.disabledRolesBytes[i] == null) {
                    this.meg.marshalUB4(0L);
                    continue;
                }
                this.meg.marshalUB4(this.disabledRolesBytes[i].length);
                this.meg.marshalCLR(this.disabledRolesBytes[i], this.disabledRolesBytes[i].length);
            }
        }
        if (this.enabledRolesBytes != null && this.enabledRolesBytes.length > 0) {
            for (i = 0; i < this.enabledRolesBytes.length; ++i) {
                if (this.enabledRolesBytes[i] == null) {
                    this.meg.marshalUB4(0L);
                    continue;
                }
                this.meg.marshalUB4(this.enabledRolesBytes[i].length);
                this.meg.marshalCLR(this.enabledRolesBytes[i], this.enabledRolesBytes[i].length);
            }
        }
        if (this.externalRolesBytes != null && this.externalRolesBytes.length > 0) {
            for (i = 0; i < this.externalRolesBytes.length; ++i) {
                if (this.externalRolesBytes[i] == null) {
                    this.meg.marshalUB4(0L);
                    continue;
                }
                this.meg.marshalUB4(this.externalRolesBytes[i].length);
                this.meg.marshalCLR(this.externalRolesBytes[i], this.externalRolesBytes[i].length);
            }
        }
        if (sendNamespaces) {
            for (i = 0; i < this.namespaces.length; ++i) {
                ((XSNamespaceI)this.namespaces[i]).marshal(this.meg);
            }
        }
        if (sendCacheNamespace) {
            for (i = 0; i < this.cacheNamespace.length; ++i) {
                ((XSNamespaceI)this.cacheNamespace[i]).marshal(this.meg);
            }
        }
        if (sendDeleteNamespace) {
            for (i = 0; i < this.deleteNamespace.length; ++i) {
                ((XSNamespaceI)this.deleteNamespace[i]).marshal(this.meg);
            }
        }
        if (this.midTierTimestamp != null) {
            this.meg.marshalB1Array(this.midTierTimestamp.getBytes());
        }
        if (this.authtime != null) {
            this.meg.marshalB1Array(this.authtime.getBytes());
        }
        this.meg.marshalUB4(this.roleVersion);
        if (sendKv) {
            ((XSKeyvalI)this.kv).marshal(this.meg);
        }
    }

    @Override
    void readRPA() throws SQLException, IOException {
        int roleOut = (int)this.meg.unmarshalUB4();
        if (this.roleVersionOutput != null && this.roleVersionOutput.length == 1) {
            this.roleVersionOutput[0] = roleOut;
        }
    }
}

