/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.osmand.IProgress;
import net.osmand.plus.GPXUtilities;
import net.osmand.plus.OsmAndFormatter;
import net.osmand.plus.OsmandSettings;
import net.osmand.plus.activities.SavingTrackHelper;
import net.osmand.plus.helpers.GpxUiHelper;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.R;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GpxSelectionHelper {
    private static final String CURRENT_TRACK = "currentTrack";
    private static final String FILE = "file";
    private static final String COLOR = "color";
    private OsmWindow app;
    private List<SelectedGpxFile> selectedGPXFiles = new ArrayList<SelectedGpxFile>();
    private SavingTrackHelper savingTrackHelper;

    public GpxSelectionHelper(OsmWindow osmandApplication, SavingTrackHelper trackHelper) {
        this.app = osmandApplication;
        this.savingTrackHelper = trackHelper;
    }

    public void clearAllGpxFileToShow() {
        this.selectedGPXFiles.clear();
        this.saveCurrentSelections();
    }

    public boolean isShowingAnyGpxFiles() {
        return !this.selectedGPXFiles.isEmpty();
    }

    public List<SelectedGpxFile> getSelectedGPXFiles() {
        return this.selectedGPXFiles;
    }

    public SelectedGpxFile getSelectedGPXFile(GPXUtilities.WptPt point) {
        for (SelectedGpxFile g : this.selectedGPXFiles) {
            if (!g.getGpxFile().points.contains(point)) continue;
            return g;
        }
        return null;
    }

    public final String getString(int resId, Object ... formatArgs) {
        return this.app.getString(resId, formatArgs);
    }

    public List<GpxDisplayGroup> collectDisplayGroups(GPXUtilities.GPXFile g) {
        GpxDisplayGroup group;
        int k;
        ArrayList<GpxDisplayGroup> dg = new ArrayList<GpxDisplayGroup>();
        String name = g.path;
        if (g.showCurrentTrack) {
            name = this.getString(1662, new Object[0]);
        } else {
            int i = name.lastIndexOf(47);
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            if ((i = name.lastIndexOf(92)) >= 0) {
                name = name.substring(i + 1);
            }
            if (name.endsWith(".gpx")) {
                name = name.substring(0, name.length() - 4);
            }
            name = name.replace('_', ' ');
        }
        if (g.tracks.size() > 0) {
            k = 1;
            for (GPXUtilities.Track t : g.tracks) {
                group = new GpxDisplayGroup(g);
                group.gpxName = name;
                group.color = t.getColor(g.getColor(0));
                group.setType(GpxDisplayItemType.TRACK_SEGMENT);
                group.setTrack(t);
                String ks = k++ + "";
                group.setName(this.getString(1506, name, g.tracks.size() == 1 ? "" : ks));
                String d = "";
                if (t.name != null && t.name.length() > 0) {
                    d = t.name + " " + d;
                }
                group.setDescription(d);
                dg.add(group);
                GpxSelectionHelper.processGroupTrack(this.app, group);
            }
        }
        if (g.routes.size() > 0) {
            k = 0;
            for (GPXUtilities.Route route : g.routes) {
                group = new GpxDisplayGroup(g);
                group.gpxName = name;
                group.setType(GpxDisplayItemType.TRACK_ROUTE_POINTS);
                String d = this.getString(1501, name, route.points.size());
                if (route.name != null && route.name.length() > 0) {
                    d = route.name + " " + d;
                }
                group.setDescription(d);
                String ks = k++ + "";
                group.setName(this.getString(1504, name, g.routes.size() == 1 ? "" : ks));
                dg.add(group);
                List<GpxDisplayItem> list = group.getModifiableList();
                int t = 0;
                for (GPXUtilities.WptPt r : route.points) {
                    GpxDisplayItem item = new GpxDisplayItem();
                    item.group = group;
                    item.description = r.desc;
                    item.expanded = true;
                    item.name = r.name;
                    ++t;
                    if (Algorithms.isEmpty(item.name)) {
                        item.name = this.getString(1502, t + "");
                    }
                    item.locationStart = r;
                    item.locationEnd = r;
                    list.add(item);
                }
            }
        }
        if (g.points.size() > 0) {
            GpxDisplayGroup group2 = new GpxDisplayGroup(g);
            group2.gpxName = name;
            group2.setType(GpxDisplayItemType.TRACK_POINTS);
            group2.setDescription(this.getString(1501, g.points.size()));
            group2.setName(this.getString(1505, name));
            dg.add(group2);
            List<GpxDisplayItem> list = group2.getModifiableList();
            int k2 = 0;
            for (GPXUtilities.WptPt r : g.points) {
                GpxDisplayItem item = new GpxDisplayItem();
                item.group = group2;
                item.description = r.desc;
                item.name = r.name;
                ++k2;
                if (Algorithms.isEmpty(item.name)) {
                    item.name = this.getString(1502, k2 + "");
                }
                item.expanded = true;
                item.locationStart = r;
                item.locationEnd = r;
                list.add(item);
            }
        }
        return dg;
    }

    private static void processGroupTrack(OsmWindow app, GpxDisplayGroup group) {
        List<GpxDisplayItem> list = group.getModifiableList();
        String timeSpanClr = Algorithms.colorToString(app.getResources().getColor(R.color.gpx_time_span_color));
        String speedClr = Algorithms.colorToString(app.getResources().getColor(R.color.gpx_speed));
        String ascClr = Algorithms.colorToString(app.getResources().getColor(R.color.gpx_altitude_asc));
        String descClr = Algorithms.colorToString(app.getResources().getColor(R.color.gpx_altitude_desc));
        String distanceClr = Algorithms.colorToString(app.getResources().getColor(R.color.gpx_distance_color));
        float eleThreshold = 3.0f;
        for (GPXUtilities.TrkSegment r : ((GpxDisplayGroup)group).track.segments) {
            GPXUtilities.GPXTrackAnalysis[] as;
            if (r.points.size() == 0) continue;
            boolean split = true;
            if (group.splitDistance > 0.0) {
                as = r.splitByDistance(group.splitDistance).toArray(new GPXUtilities.GPXTrackAnalysis[0]);
            } else if (group.splitTime > 0) {
                as = r.splitByTime(group.splitTime).toArray(new GPXUtilities.GPXTrackAnalysis[0]);
            } else {
                split = false;
                as = new GPXUtilities.GPXTrackAnalysis[]{GPXUtilities.GPXTrackAnalysis.segment(0L, r)};
            }
            for (GPXUtilities.GPXTrackAnalysis analysis : as) {
                GpxDisplayItem item = new GpxDisplayItem();
                item.group = group;
                if (split) {
                    item.splitMetric = analysis.metricEnd;
                    item.secondarySplitMetric = analysis.secondaryMetricEnd;
                    item.splitName = GpxSelectionHelper.formatSplitName(analysis.metricEnd, group, app);
                    item.splitName = item.splitName + " (" + GpxSelectionHelper.formatSecondarySplitName(analysis.secondaryMetricEnd, group, app) + ") ";
                }
                item.description = GpxUiHelper.getDescription(app, analysis, true);
                item.analysis = analysis;
                String name = "";
                if (!group.isSplitDistance()) {
                    name = name + GpxUiHelper.getColorValue(distanceClr, OsmAndFormatter.getFormattedDistance(analysis.totalDistance, app));
                }
                if (!(analysis.timeSpan <= 0L && analysis.timeMoving <= 0L || group.isSplitTime())) {
                    long tm = analysis.timeMoving;
                    if (tm == 0L) {
                        tm = analysis.timeSpan;
                    }
                    if (name.length() != 0) {
                        name = name + ", ";
                    }
                    name = name + GpxUiHelper.getColorValue(timeSpanClr, Algorithms.formatDuration((int)(tm / 1000L)));
                }
                if (analysis.isSpeedSpecified()) {
                    if (name.length() != 0) {
                        name = name + ", ";
                    }
                    name = name + GpxUiHelper.getColorValue(speedClr, OsmAndFormatter.getFormattedSpeed(analysis.avgSpeed, app));
                }
                if (analysis.isElevationSpecified()) {
                    if (name.length() != 0) {
                        name = name + ", ";
                    }
                    name = name + GpxUiHelper.getColorValue(descClr, OsmAndFormatter.getFormattedAlt(analysis.minElevation, app));
                    name = name + " - ";
                    name = name + GpxUiHelper.getColorValue(ascClr, OsmAndFormatter.getFormattedAlt(analysis.maxElevation, app));
                }
                if (analysis.isElevationSpecified() && (analysis.diffElevationUp > 3.0 || analysis.diffElevationDown > 3.0)) {
                    if (name.length() != 0) {
                        name = name + ", ";
                    }
                    if (analysis.diffElevationDown > 3.0) {
                        name = name + GpxUiHelper.getColorValue(descClr, " \u2193 " + OsmAndFormatter.getFormattedAlt(analysis.diffElevationDown, app));
                    }
                    if (analysis.diffElevationUp > 3.0) {
                        name = name + GpxUiHelper.getColorValue(ascClr, " \u2191 " + OsmAndFormatter.getFormattedAlt(analysis.diffElevationUp, app));
                    }
                }
                item.name = name;
                item.locationStart = analysis.locationStart;
                item.locationEnd = analysis.locationEnd;
                list.add(item);
            }
        }
    }

    private static String formatSecondarySplitName(double metricEnd, GpxDisplayGroup group, OsmWindow app) {
        if (group.isSplitDistance()) {
            return Algorithms.formatDuration((int)metricEnd);
        }
        return OsmAndFormatter.getFormattedDistance((float)metricEnd, app);
    }

    private static String formatSplitName(double metricEnd, GpxDisplayGroup group, OsmWindow app) {
        if (group.isSplitDistance()) {
            OsmandSettings.MetricsConstants mc = app.getSettings().METRIC_SYSTEM.get();
            if (mc == OsmandSettings.MetricsConstants.KILOMETERS_AND_METERS) {
                int rem100;
                double sd = group.getSplitDistance();
                int digits = sd < 100.0 ? 2 : (sd < 1000.0 ? 1 : 0);
                int rem1000 = (int)(metricEnd + 0.5) % 1000;
                if (rem1000 > 1 && digits < 1) {
                    digits = 1;
                }
                if ((rem100 = (int)(metricEnd + 0.5) % 100) > 1 && digits < 2) {
                    digits = 2;
                }
                return OsmAndFormatter.getFormattedRoundDistanceKm((float)metricEnd, digits, app);
            }
            return OsmAndFormatter.getFormattedDistance((float)metricEnd, app);
        }
        return Algorithms.formatDuration((int)metricEnd);
    }

    public SelectedGpxFile getSelectedFileByPath(String path) {
        for (SelectedGpxFile s : this.selectedGPXFiles) {
            if (!s.getGpxFile().path.equals(path)) continue;
            return s;
        }
        return null;
    }

    public SelectedGpxFile getSelectedFileByName(String path) {
        for (SelectedGpxFile s : this.selectedGPXFiles) {
            if (!s.getGpxFile().path.endsWith(File.separator + path)) continue;
            return s;
        }
        return null;
    }

    public SelectedGpxFile getSelectedCurrentRecordingTrack() {
        for (SelectedGpxFile s : this.selectedGPXFiles) {
            if (!s.isShowCurrentTrack()) continue;
            return s;
        }
        return null;
    }

    public void setGpxFileToDisplay(GPXUtilities.GPXFile ... gpxs) {
        for (GPXUtilities.GPXFile gpx : gpxs) {
            boolean show = true;
            this.selectGpxFileImpl(gpx, show, false);
        }
        this.saveCurrentSelections();
    }

    public void loadGPXTracks(IProgress p) {
        String load = this.app.getSettings().SELECTED_GPX.get();
        if (!Algorithms.isEmpty(load)) {
            try {
                JSONArray ar = new JSONArray(load);
                boolean save = false;
                for (int i = 0; i < ar.length(); ++i) {
                    JSONObject obj = ar.getJSONObject(i);
                    if (obj.has(FILE)) {
                        File fl = new File(obj.getString(FILE));
                        if (p != null) {
                            p.startTask(this.getString(1312, fl.getName()), -1);
                        }
                        GPXUtilities.GPXFile gpx = GPXUtilities.loadGPXFile(this.app, fl);
                        if (obj.has(COLOR)) {
                            int clr = Algorithms.parseColor(obj.getString(COLOR));
                            gpx.setColor(clr);
                        }
                        if (gpx.warning != null) {
                            save = true;
                            continue;
                        }
                        this.selectGpxFile(gpx, true, false);
                        continue;
                    }
                    if (!obj.has(CURRENT_TRACK)) continue;
                    this.selectedGPXFiles.add(this.savingTrackHelper.getCurrentTrack());
                }
                if (save) {
                    this.saveCurrentSelections();
                }
            }
            catch (Exception e) {
                this.app.getSettings().SELECTED_GPX.set("");
                e.printStackTrace();
            }
        }
    }

    private void saveCurrentSelections() {
        JSONArray ar = new JSONArray();
        for (SelectedGpxFile s : this.selectedGPXFiles) {
            if (s.gpxFile == null || s.notShowNavigationDialog) continue;
            JSONObject obj = new JSONObject();
            try {
                if (s.isShowCurrentTrack()) {
                    obj.put(CURRENT_TRACK, true);
                } else if (!Algorithms.isEmpty(((SelectedGpxFile)s).gpxFile.path)) {
                    obj.put(FILE, (Object)((SelectedGpxFile)s).gpxFile.path);
                    if (s.gpxFile.getColor(0) != 0) {
                        obj.put(COLOR, (Object)Algorithms.colorToString(s.gpxFile.getColor(0)));
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            ar.put((Object)obj);
        }
        this.app.getSettings().SELECTED_GPX.set(ar.toString());
    }

    private SelectedGpxFile selectGpxFileImpl(GPXUtilities.GPXFile gpx, boolean show, boolean notShowNavigationDialog) {
        SelectedGpxFile sf;
        boolean displayed = false;
        if (gpx != null && gpx.showCurrentTrack) {
            sf = this.savingTrackHelper.getCurrentTrack();
            sf.notShowNavigationDialog = notShowNavigationDialog;
            displayed = this.selectedGPXFiles.contains(sf);
        } else {
            sf = this.getSelectedFileByPath(gpx.path);
            boolean bl = displayed = sf != null;
            if (show && sf == null) {
                sf = new SelectedGpxFile();
                sf.setGpxFile(gpx);
                sf.notShowNavigationDialog = notShowNavigationDialog;
            }
        }
        if (displayed != show) {
            if (show) {
                this.selectedGPXFiles.add(sf);
            } else {
                this.selectedGPXFiles.remove(sf);
            }
        }
        return sf;
    }

    public SelectedGpxFile selectGpxFile(GPXUtilities.GPXFile gpx, boolean show, boolean notShowNavigationDialog) {
        SelectedGpxFile sf = this.selectGpxFileImpl(gpx, show, notShowNavigationDialog);
        this.saveCurrentSelections();
        return sf;
    }

    public static class GpxDisplayItem {
        public GPXUtilities.GPXTrackAnalysis analysis;
        public GpxDisplayGroup group;
        public GPXUtilities.WptPt locationStart;
        public GPXUtilities.WptPt locationEnd;
        public double splitMetric = -1.0;
        public double secondarySplitMetric = -1.0;
        public String splitName;
        public String name;
        public String description;
        public String url;
        public BufferedImage image;
        public boolean expanded;
    }

    public static class GpxDisplayGroup {
        private GpxDisplayItemType type = GpxDisplayItemType.TRACK_SEGMENT;
        private List<GpxDisplayItem> list = new ArrayList<GpxDisplayItem>();
        private GPXUtilities.GPXFile gpx;
        private String gpxName;
        private String name;
        private String description;
        private GPXUtilities.Track track;
        private double splitDistance = -1.0;
        private int splitTime = -1;
        private int color;

        public GpxDisplayGroup(GPXUtilities.GPXFile gpx) {
            this.gpx = gpx;
        }

        public void setTrack(GPXUtilities.Track track) {
            this.track = track;
        }

        public GPXUtilities.GPXFile getGpx() {
            return this.gpx;
        }

        public GPXUtilities.Track getTrack() {
            return this.track;
        }

        public GpxDisplayGroup cloneInstance() {
            GpxDisplayGroup group = new GpxDisplayGroup(this.gpx);
            group.type = this.type;
            group.name = this.name;
            group.description = this.description;
            group.track = this.track;
            group.list = new ArrayList<GpxDisplayItem>(this.list);
            return group;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGpxName() {
            return this.gpxName;
        }

        public String getName() {
            return this.name;
        }

        public List<GpxDisplayItem> getModifiableList() {
            return this.list;
        }

        public GpxDisplayItemType getType() {
            return this.type;
        }

        public void setType(GpxDisplayItemType type) {
            this.type = type;
        }

        public boolean isSplitDistance() {
            return this.splitDistance > 0.0;
        }

        public double getSplitDistance() {
            return this.splitDistance;
        }

        public boolean isSplitTime() {
            return this.splitTime > 0;
        }

        public int getSplitTime() {
            return this.splitTime;
        }

        public String getGroupName() {
            return this.name;
        }

        public void noSplit(OsmWindow app) {
            this.list.clear();
            this.splitDistance = -1.0;
            this.splitTime = -1;
            GpxSelectionHelper.processGroupTrack(app, this);
        }

        public void splitByDistance(OsmWindow app, double meters) {
            this.list.clear();
            this.splitDistance = meters;
            this.splitTime = -1;
            GpxSelectionHelper.processGroupTrack(app, this);
        }

        public void splitByTime(OsmWindow app, int seconds) {
            this.list.clear();
            this.splitDistance = -1.0;
            this.splitTime = seconds;
            GpxSelectionHelper.processGroupTrack(app, this);
        }

        public int getColor() {
            return this.color;
        }
    }

    public static enum GpxDisplayItemType {
        TRACK_SEGMENT,
        TRACK_POINTS,
        TRACK_ROUTE_POINTS;

    }

    public static class SelectedGpxFile {
        public boolean notShowNavigationDialog = false;
        private boolean showCurrentTrack;
        private GPXUtilities.GPXFile gpxFile;
        private int color;
        private GPXUtilities.GPXTrackAnalysis trackAnalysis;
        private long modifiedTime = -1L;
        private List<GPXUtilities.TrkSegment> processedPointsToDisplay = new ArrayList<GPXUtilities.TrkSegment>();
        private boolean routePoints;
        private List<GpxDisplayGroup> displayGroups;

        public void setGpxFile(GPXUtilities.GPXFile gpxFile) {
            this.gpxFile = gpxFile;
            if (gpxFile.tracks.size() > 0) {
                this.color = gpxFile.tracks.get(0).getColor(0);
            }
            this.processPoints();
        }

        public GPXUtilities.GPXTrackAnalysis getTrackAnalysis() {
            if (this.modifiedTime != this.gpxFile.modifiedTime) {
                this.update();
            }
            return this.trackAnalysis;
        }

        private void update() {
            this.modifiedTime = this.gpxFile.modifiedTime;
            this.trackAnalysis = this.gpxFile.getAnalysis(Algorithms.isEmpty(this.gpxFile.path) ? System.currentTimeMillis() : new File(this.gpxFile.path).lastModified());
            this.displayGroups = null;
        }

        public void processPoints() {
            this.update();
            this.processedPointsToDisplay = this.gpxFile.proccessPoints();
            if (this.processedPointsToDisplay.isEmpty()) {
                this.processedPointsToDisplay = this.gpxFile.processRoutePoints();
                this.routePoints = !this.processedPointsToDisplay.isEmpty();
            }
        }

        public boolean isRoutePoints() {
            return this.routePoints;
        }

        public List<GPXUtilities.TrkSegment> getPointsToDisplay() {
            return this.processedPointsToDisplay;
        }

        public List<GPXUtilities.TrkSegment> getModifiablePointsToDisplay() {
            return this.processedPointsToDisplay;
        }

        public GPXUtilities.GPXFile getGpxFile() {
            return this.gpxFile;
        }

        public GPXUtilities.GPXFile getModifiableGpxFile() {
            return this.gpxFile;
        }

        public boolean isShowCurrentTrack() {
            return this.showCurrentTrack;
        }

        public void setShowCurrentTrack(boolean showCurrentTrack) {
            this.showCurrentTrack = showCurrentTrack;
        }

        public int getColor() {
            return this.color;
        }

        public List<GpxDisplayGroup> getDisplayGroups() {
            if (this.modifiedTime != this.gpxFile.modifiedTime) {
                this.update();
            }
            return this.displayGroups;
        }

        public void setDisplayGroups(List<GpxDisplayGroup> displayGroups) {
            if (this.modifiedTime != this.gpxFile.modifiedTime) {
                this.update();
            }
            this.displayGroups = displayGroups;
        }
    }
}

