/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.io.IOException;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class WhitespaceTokenStream
extends FilterObjectStream<TokenSample, String> {
    public WhitespaceTokenStream(ObjectStream<TokenSample> tokens) {
        super(tokens);
    }

    @Override
    public String read() throws IOException {
        TokenSample tokenSample = (TokenSample)this.samples.read();
        if (tokenSample != null) {
            StringBuilder whitespaceSeparatedTokenString = new StringBuilder();
            for (Span token : tokenSample.getTokenSpans()) {
                whitespaceSeparatedTokenString.append(token.getCoveredText(tokenSample.getText()));
                whitespaceSeparatedTokenString.append(' ');
            }
            if (whitespaceSeparatedTokenString.length() > 0) {
                whitespaceSeparatedTokenString.setLength(whitespaceSeparatedTokenString.length() - 1);
            }
            return whitespaceSeparatedTokenString.toString();
        }
        return null;
    }
}

