/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerInterceptors<K, V>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ConsumerInterceptors.class);
    private final List<Plugin<ConsumerInterceptor<K, V>>> interceptorPlugins;

    public ConsumerInterceptors(List<ConsumerInterceptor<K, V>> interceptors, Metrics metrics) {
        this.interceptorPlugins = Plugin.wrapInstances(interceptors, metrics, "interceptor.classes");
    }

    public boolean isEmpty() {
        return this.interceptorPlugins.isEmpty();
    }

    public ConsumerRecords<K, V> onConsume(ConsumerRecords<K, V> records) {
        ConsumerRecords<K, V> interceptRecords = records;
        for (Plugin<ConsumerInterceptor<K, V>> interceptorPlugin : this.interceptorPlugins) {
            try {
                interceptRecords = interceptorPlugin.get().onConsume(interceptRecords);
            }
            catch (Exception e) {
                log.warn("Error executing interceptor onConsume callback", (Throwable)e);
            }
        }
        return interceptRecords;
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
        for (Plugin<ConsumerInterceptor<K, V>> interceptorPlugin : this.interceptorPlugins) {
            try {
                interceptorPlugin.get().onCommit(offsets);
            }
            catch (Exception e) {
                log.warn("Error executing interceptor onCommit callback", (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        for (Plugin<ConsumerInterceptor<K, V>> interceptorPlugin : this.interceptorPlugins) {
            try {
                interceptorPlugin.close();
            }
            catch (Exception e) {
                log.error("Failed to close consumer interceptor ", (Throwable)e);
            }
        }
    }
}

