# Distributed under the OSI-approved BSD 3-Clause License.
# See https://cmake.org/licensing for details.

#[=======================================================================[.rst:
glib-2.0
--------

Finds the glib-2.0 library.

Imported Targets
^^^^^^^^^^^^^^^^

This module was generated by "generate_find_module" and provides the following IMPORTED targets, if found:

``glib-2.0::glib-2.0``
  The glib-2.0 library

Result Variables
^^^^^^^^^^^^^^^^

This will define the following variables:

``glib-2.0_FOUND``
  True if the system has the glib-2.0 library.
``glib-2.0_VERSION``
  The version of the glib-2.0 library which was found.
``glib-2.0_INCLUDE_DIRS``
  Include directories needed to use glib-2.0.
``glib-2.0_LIBRARIES``
  Libraries needed to link to glib-2.0.

Cache Variables
^^^^^^^^^^^^^^^

The following cache variables may also be set:

``glib-2.0_INCLUDE_DIR``
  The directory containing ``glib.h``.
``glib-2.0_LIBRARY``
  The path to the glib-2.0 library.

#]=======================================================================]

set(VERBOSE_FIND_MODULE OFF CACHE BOOL "Enable to print debug infos in the generated Find[...].cmake files")

find_package(PkgConfig)
pkg_check_modules(PC_glib-2.0 QUIET glib-2.0)
find_path(glib-2.0_INCLUDE_DIR NAMES glib.h
    HINTS  
    PATHS  ${PC_glib-2.0_INCLUDE_DIRS}
    PATH_SUFFIXES glib
    
    
    
    
    
    
      
)

find_library(glib-2.0_LIBRARY NAMES glib-2.0
    HINTS 
    PATHS  ${PC_glib-2.0_LIBRARY_DIRS}
    PATH_SUFFIXES 
    
    
    
    
    
    
      
)

set(Foo_VERSION ${PC_glib-2.0_VERSION})
set(Foo_VERSION_STRING ${Foo_VERSION})

if(${VERBOSE_FIND_MODULE})
    message(STATUS "Running Findglib-2.0.cmake")
    if(${PC_glib-2.0_FOUND})
        message(STATUS "   Found PkgConfig module with name 'glib-2.0':")
        message(STATUS "       glib-2.0_LIBRARIES: ${PC_glib-2.0_LIBRARIES}")
        message(STATUS "       glib-2.0_LIBRARY_DIRS: ${PC_glib-2.0_LIBRARY_DIRS}")
        message(STATUS "       glib-2.0_LDFLAGS: ${PC_glib-2.0_LDFLAGS}")
        message(STATUS "       glib-2.0_LDFLAGS_OTHER: ${PC_glib-2.0_LDFLAGS_OTHER}")
        message(STATUS "       glib-2.0_INCLUDE_DIRS: ${PC_glib-2.0_INCLUDE_DIRS}")
        message(STATUS "       glib-2.0_CFLAGS: ${PC_glib-2.0_CFLAGS}")
        message(STATUS "       glib-2.0_CFLAGS_OTHER: ${PC_glib-2.0_CFLAGS_OTHER}")
    else()
        message(STATUS "   No PkgConfig module found with name 'glib-2.0'")
    endif()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(glib-2.0 FOUND_VAR glib-2.0_FOUND REQUIRED_VARS glib-2.0_LIBRARY glib-2.0_INCLUDE_DIR VERSION_VAR glib-2.0_VERSION)

if(glib-2.0_FOUND)
    set(glib-2.0_LIBRARIES ${glib-2.0_LIBRARY})
    if(PC_glib-2.0_INCLUDE_DIRS)
        set(glib-2.0_INCLUDE_DIRS ${PC_glib-2.0_INCLUDE_DIRS})
    else()
        set(glib-2.0_INCLUDE_DIRS ${glib-2.0_INCLUDE_DIR})
    endif()
    set(glib-2.0_DEFINITIONS ${PC_glib-2.0_CFLAGS_OTHER})
endif()

if(glib-2.0_FOUND AND NOT TARGET glib-2.0::glib-2.0)
    add_library(glib-2.0::glib-2.0 UNKNOWN IMPORTED)
    set_target_properties(glib-2.0::glib-2.0 PROPERTIES IMPORTED_LOCATION "${glib-2.0_LIBRARY}" INTERFACE_COMPILE_OPTIONS "${PC_glib-2.0_CFLAGS_OTHER}" INTERFACE_INCLUDE_DIRECTORIES "${glib-2.0_INCLUDE_DIRS}")
    if(${VERBOSE_FIND_MODULE})
        message(STATUS "   Creating IMPORTED target 'glib-2.0::glib-2.0':")
        message(STATUS "       IMPORTED_LOCATION: ${glib-2.0_LIBRARY}")
        message(STATUS "       INTERFACE_COMPILE_OPTIONS: ${PC_glib-2.0_CFLAGS_OTHER}")
        message(STATUS "       INTERFACE_INCLUDE_DIRECTORIES: ${glib-2.0_INCLUDE_DIRS}")
    endif()
endif()

mark_as_advanced(
  glib-2.0_INCLUDE_DIR
  glib-2.0_LIBRARY
)
