/*
 * Decompiled with CFR 0.152.
 */
package com.password4j;

import com.password4j.BadParametersException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyReader {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyReader.class);
    private static final String FILE_NAME = "psw4j.properties";
    private static final String CONFIGURATION_KEY = "psw4j.configuration";
    private static final String MESSAGE = "{}. Default value is used ({}). Please set property {} in your psw4j.properties file.";
    protected static Properties properties;

    private PropertyReader() {
    }

    static int readInt(String key, int defaultValue, String message) {
        String str = PropertyReader.readString(key);
        if (str == null) {
            LOG.warn(MESSAGE, new Object[]{message, defaultValue, key});
            return defaultValue;
        }
        return Integer.parseInt(str);
    }

    static boolean readBoolean(String key, boolean defaultValue) {
        String str = PropertyReader.readString(key);
        if (str == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(str);
    }

    static String readString(String key, String defaultValue, String message) {
        String value = PropertyReader.readString(key);
        if (value == null) {
            LOG.warn(MESSAGE, new Object[]{message, defaultValue, key});
            return defaultValue;
        }
        return value;
    }

    static char readChar(String key, char defaultValue, String message) {
        String str = PropertyReader.readString(key);
        if (str == null) {
            LOG.warn(MESSAGE, new Object[]{message, Character.valueOf(defaultValue), key});
            return defaultValue;
        }
        return str.charAt(0);
    }

    static char readChar(String key, char defaultValue) {
        String str = PropertyReader.readString(key);
        if (str == null) {
            return defaultValue;
        }
        return str.charAt(0);
    }

    private static String readString(String key) {
        if (key == null) {
            throw new BadParametersException("Key cannot be null");
        }
        if (properties != null) {
            return properties.getProperty(key);
        }
        return null;
    }

    static void init() {
        String customPath = null;
        try {
            customPath = System.getProperty(CONFIGURATION_KEY, null);
        }
        catch (AccessControlException ex) {
            LOG.debug("Cannot access configuration key property", (Throwable)ex);
        }
        InputStream in = null;
        Properties props = new Properties();
        try {
            in = customPath == null || customPath.isEmpty() ? PropertyReader.getResource("/psw4j.properties") : PropertyReader.getResource(customPath);
        }
        catch (AccessControlException ex) {
            LOG.debug("Cannot access properties file", (Throwable)ex);
            props.setProperty("global.banner", "false");
        }
        if (in != null) {
            try {
                props.load(in);
            }
            catch (IOException iOException) {}
        } else {
            LOG.debug("Cannot find any properties file.");
        }
        properties = props;
    }

    static InputStream getResource(String resource) {
        InputStream in;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null && (in = classLoader.getResourceAsStream(resource)) != null) {
                return in;
            }
            classLoader = PropertyReader.class.getClassLoader();
            if (classLoader != null && (in = classLoader.getResourceAsStream(resource)) != null) {
                return in;
            }
        }
        catch (Exception e) {
            LOG.warn("", (Throwable)e);
        }
        in = ClassLoader.getSystemResourceAsStream(resource);
        if (in != null) {
            return in;
        }
        try {
            return new FileInputStream(resource);
        }
        catch (FileNotFoundException e) {
            return PropertyReader.class.getResourceAsStream(resource);
        }
    }

    static {
        PropertyReader.init();
    }
}

