/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNStreamData;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNPath
extends DBNPathBase
implements DBNStreamData {
    private static final Log log = Log.getLog(DBNPath.class);
    private Path path;

    public DBNPath(DBNNode parentNode, Path path) {
        super(parentNode);
        this.path = path;
    }

    @Override
    public boolean isDisposed() {
        return this.path == null || super.isDisposed();
    }

    @Override
    public synchronized Path getPath() {
        return this.path;
    }

    @Override
    protected void setPath(Path path) {
        this.path = path;
    }

    @Override
    protected void dispose(boolean reflect) {
        this.path = null;
        super.dispose(reflect);
    }

    @Override
    @NotNull
    public String getNodeType() {
        return DBNNode.NodePathType.dbvfs.name() + (this.isDirectory() ? ".folder" : ".file");
    }

    @Override
    @NotNull
    public String getNodeTypeLabel() {
        return this.isDirectory() ? ModelMessages.fs_folder : ModelMessages.fs_file;
    }

    @Override
    @Nullable
    public String getNodeDescription() {
        return null;
    }

    @Override
    @NotNull
    public String getNodeTargetName() {
        return super.getNodeTargetName();
    }

    @Override
    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        return super.refreshNode(monitor, source);
    }

    @Override
    protected boolean isTheSameFileSystem(DBNNode node) {
        if (node instanceof DBNPath) {
            DBNPath pn = (DBNPath)node;
            return this.path.getFileSystem().equals(pn.path.getFileSystem());
        }
        return super.isTheSameFileSystem(node);
    }

    @Override
    public boolean supportsStreamData() {
        return !this.isDirectory();
    }

    @Override
    public long getStreamSize() throws IOException {
        return Files.size(this.path);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        if (this.isDirectory()) {
            return null;
        }
        return Files.newInputStream(this.path, new OpenOption[0]);
    }
}

