/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.search.DocValueFormat;

@PublicApi(since="1.0.0")
public class SearchSortValuesAndFormats
implements Writeable {
    private final Object[] rawSortValues;
    private final Object[] formattedSortValues;
    private final DocValueFormat[] sortValueFormats;

    public SearchSortValuesAndFormats(Object[] rawSortValues, DocValueFormat[] sortValueFormats) {
        assert (rawSortValues.length == sortValueFormats.length);
        this.rawSortValues = rawSortValues;
        this.sortValueFormats = sortValueFormats;
        this.formattedSortValues = Arrays.copyOf(rawSortValues, rawSortValues.length);
        for (int i = 0; i < rawSortValues.length; ++i) {
            Object sortValue;
            Object object = sortValue = rawSortValues[i];
            int n = 0;
            this.formattedSortValues[i] = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BytesRef.class, Long.class, BigInteger.class, Double.class, Float.class, Integer.class}, (Object)object, n)) {
                case 0 -> {
                    BytesRef bytesRef = (BytesRef)object;
                    yield sortValueFormats[i].format(bytesRef);
                }
                case 1 -> {
                    Long longValue = (Long)object;
                    yield sortValueFormats[i].format(longValue);
                }
                case 2 -> {
                    BigInteger bigInteger = (BigInteger)object;
                    yield sortValueFormats[i].format(bigInteger);
                }
                case 3 -> {
                    Double doubleValue = (Double)object;
                    yield sortValueFormats[i].format(doubleValue);
                }
                case 4 -> {
                    Float ignored = (Float)object;
                    yield sortValue;
                }
                case 5 -> {
                    Integer ignored = (Integer)object;
                    yield sortValue;
                }
                case -1 -> sortValue;
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("Sort values must be a BytesRef, Long, Integer, Double or Float, but got " + String.valueOf(sortValue.getClass()) + ": " + String.valueOf(sortValue)));
                    }
                    yield sortValue;
                }
            };
        }
    }

    public SearchSortValuesAndFormats(StreamInput in) throws IOException {
        this.rawSortValues = in.readArray(Lucene::readSortValue, Object[]::new);
        this.formattedSortValues = in.readArray(Lucene::readSortValue, Object[]::new);
        this.sortValueFormats = new DocValueFormat[this.formattedSortValues.length];
        for (int i = 0; i < this.sortValueFormats.length; ++i) {
            this.sortValueFormats[i] = (DocValueFormat)in.readNamedWriteable(DocValueFormat.class);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray(Lucene::writeSortValue, this.rawSortValues);
        out.writeArray(Lucene::writeSortValue, this.formattedSortValues);
        for (int i = 0; i < this.sortValueFormats.length; ++i) {
            out.writeNamedWriteable((NamedWriteable)this.sortValueFormats[i]);
        }
    }

    public Object[] getRawSortValues() {
        return this.rawSortValues;
    }

    public Object[] getFormattedSortValues() {
        return this.formattedSortValues;
    }

    public DocValueFormat[] getSortValueFormats() {
        return this.sortValueFormats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchSortValuesAndFormats that = (SearchSortValuesAndFormats)o;
        return Arrays.equals(this.rawSortValues, that.rawSortValues) && Arrays.equals(this.formattedSortValues, that.formattedSortValues) && Arrays.equals(this.sortValueFormats, that.sortValueFormats);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.rawSortValues);
        result = 31 * result + Arrays.hashCode(this.formattedSortValues);
        result = 31 * result + Arrays.hashCode(this.sortValueFormats);
        return result;
    }
}

