/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class GeneratedStatement
implements Diagnosable {
    PhysicalConnection connection;
    Accessor[] accessors = null;
    int lastIndex = -1;
    OracleInputStream streamList;
    protected int offsetOfFirstUserColumn = -1;

    protected GeneratedStatement(PhysicalConnection conn) {
        this.connection = conn;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.connection.getDiagnosable();
    }

    abstract void closeUsedStreams(int var1) throws SQLException;

    abstract int physicalRowIndex(long var1);

    Array getArray(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getArray(this.physicalRowIndex(rowIndex));
    }

    BigDecimal getBigDecimal(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getBigDecimal(this.physicalRowIndex(rowIndex));
    }

    BigDecimal getBigDecimal(long rowIndex, int columnIndex, int y) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getBigDecimal(this.physicalRowIndex(rowIndex), y);
    }

    Blob getBlob(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getBlob(this.physicalRowIndex(rowIndex));
    }

    boolean getBoolean(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getBoolean(this.physicalRowIndex(rowIndex));
    }

    byte getByte(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getByte(this.physicalRowIndex(rowIndex));
    }

    byte[] getBytes(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getBytes(this.physicalRowIndex(rowIndex));
    }

    Clob getClob(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getClob(this.physicalRowIndex(rowIndex));
    }

    Date getDate(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getDate(this.physicalRowIndex(rowIndex));
    }

    Date getDate(long rowIndex, int columnIndex, Calendar y) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getDate(this.physicalRowIndex(rowIndex), y);
    }

    double getDouble(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getDouble(this.physicalRowIndex(rowIndex));
    }

    float getFloat(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getFloat(this.physicalRowIndex(rowIndex));
    }

    int getInt(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getInt(this.physicalRowIndex(rowIndex));
    }

    long getLong(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getLong(this.physicalRowIndex(rowIndex));
    }

    NClob getNClob(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getNClob(this.physicalRowIndex(rowIndex));
    }

    String getNString(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getNString(this.physicalRowIndex(rowIndex));
    }

    Object getObject(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getObject(this.physicalRowIndex(rowIndex));
    }

    Object getObject(long rowIndex, int columnIndex, Map<String, Class<?>> y) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getObject(this.physicalRowIndex(rowIndex), y);
    }

    Ref getRef(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getRef(this.physicalRowIndex(rowIndex));
    }

    RowId getRowId(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getRowId(this.physicalRowIndex(rowIndex));
    }

    short getShort(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getShort(this.physicalRowIndex(rowIndex));
    }

    SQLXML getSQLXML(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getSQLXML(this.physicalRowIndex(rowIndex));
    }

    String getString(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getString(this.physicalRowIndex(rowIndex));
    }

    Time getTime(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getTime(this.physicalRowIndex(rowIndex));
    }

    Time getTime(long rowIndex, int columnIndex, Calendar y) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getTime(this.physicalRowIndex(rowIndex), y);
    }

    Timestamp getTimestamp(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getTimestamp(this.physicalRowIndex(rowIndex));
    }

    Timestamp getTimestamp(long rowIndex, int columnIndex, Calendar y) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getTimestamp(this.physicalRowIndex(rowIndex), y);
    }

    URL getURL(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getURL(this.physicalRowIndex(rowIndex));
    }

    ARRAY getARRAY(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getARRAY(this.physicalRowIndex(rowIndex));
    }

    BFILE getBFILE(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getBFILE(this.physicalRowIndex(rowIndex));
    }

    BFILE getBfile(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getBfile(this.physicalRowIndex(rowIndex));
    }

    BLOB getBLOB(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getBLOB(this.physicalRowIndex(rowIndex));
    }

    CHAR getCHAR(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getCHAR(this.physicalRowIndex(rowIndex));
    }

    CLOB getCLOB(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getCLOB(this.physicalRowIndex(rowIndex));
    }

    ResultSet getCursor(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getCursor(this.physicalRowIndex(rowIndex));
    }

    DATE getDATE(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getDATE(this.physicalRowIndex(rowIndex));
    }

    INTERVALDS getINTERVALDS(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getINTERVALDS(this.physicalRowIndex(rowIndex));
    }

    INTERVALYM getINTERVALYM(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getINTERVALYM(this.physicalRowIndex(rowIndex));
    }

    NUMBER getNUMBER(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getNUMBER(this.physicalRowIndex(rowIndex));
    }

    OPAQUE getOPAQUE(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getOPAQUE(this.physicalRowIndex(rowIndex));
    }

    Datum getOracleObject(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getOracleObject(this.physicalRowIndex(rowIndex));
    }

    ORAData getORAData(long rowIndex, int columnIndex, ORADataFactory y) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getORAData(this.physicalRowIndex(rowIndex), y);
    }

    Object getObject(long rowIndex, int columnIndex, OracleDataFactory y) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getObject(this.physicalRowIndex(rowIndex), y);
    }

    RAW getRAW(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getRAW(this.physicalRowIndex(rowIndex));
    }

    REF getREF(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getREF(this.physicalRowIndex(rowIndex));
    }

    ROWID getROWID(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getROWID(this.physicalRowIndex(rowIndex));
    }

    STRUCT getSTRUCT(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getSTRUCT(this.physicalRowIndex(rowIndex));
    }

    TIMESTAMPLTZ getTIMESTAMPLTZ(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getTIMESTAMPLTZ(this.physicalRowIndex(rowIndex));
    }

    TIMESTAMPTZ getTIMESTAMPTZ(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getTIMESTAMPTZ(this.physicalRowIndex(rowIndex));
    }

    TIMESTAMP getTIMESTAMP(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getTIMESTAMP(this.physicalRowIndex(rowIndex));
    }

    CustomDatum getCustomDatum(long rowIndex, int columnIndex, CustomDatumFactory y) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getCustomDatum(this.physicalRowIndex(rowIndex), y);
    }

    InputStream getAsciiStream(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getAsciiStream(this.physicalRowIndex(rowIndex));
    }

    InputStream getBinaryStream(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getBinaryStream(this.physicalRowIndex(rowIndex));
    }

    Reader getCharacterStream(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getCharacterStream(this.physicalRowIndex(rowIndex));
    }

    Reader getNCharacterStream(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getNCharacterStream(this.physicalRowIndex(rowIndex));
    }

    InputStream getUnicodeStream(long rowIndex, int columnIndex) throws SQLException {
        this.lastIndex = columnIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(columnIndex);
        }
        return this.accessors[columnIndex + this.offsetOfFirstUserColumn].getUnicodeStream(this.physicalRowIndex(rowIndex));
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

