/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.server.config.ConfigSynonym;

public class KafkaConfigSchema {
    public static final KafkaConfigSchema EMPTY = new KafkaConfigSchema(Map.of(), Map.of());
    private static final ConfigDef EMPTY_CONFIG_DEF = new ConfigDef();
    private static final Map<ConfigEntry.ConfigSource, DescribeConfigsResponse.ConfigSource> TRANSLATE_CONFIG_SOURCE_MAP;
    private final Map<ConfigResource.Type, ConfigDef> configDefs;
    private final Map<String, List<ConfigSynonym>> logConfigSynonyms;

    public static ConfigEntry.ConfigType translateConfigType(ConfigDef.Type type) {
        switch (type) {
            case BOOLEAN: {
                return ConfigEntry.ConfigType.BOOLEAN;
            }
            case STRING: {
                return ConfigEntry.ConfigType.STRING;
            }
            case INT: {
                return ConfigEntry.ConfigType.INT;
            }
            case SHORT: {
                return ConfigEntry.ConfigType.SHORT;
            }
            case LONG: {
                return ConfigEntry.ConfigType.LONG;
            }
            case DOUBLE: {
                return ConfigEntry.ConfigType.DOUBLE;
            }
            case LIST: {
                return ConfigEntry.ConfigType.LIST;
            }
            case CLASS: {
                return ConfigEntry.ConfigType.CLASS;
            }
            case PASSWORD: {
                return ConfigEntry.ConfigType.PASSWORD;
            }
        }
        return ConfigEntry.ConfigType.UNKNOWN;
    }

    public static DescribeConfigsResponse.ConfigSource translateConfigSource(ConfigEntry.ConfigSource configSource) {
        DescribeConfigsResponse.ConfigSource result = TRANSLATE_CONFIG_SOURCE_MAP.get(configSource);
        if (result != null) {
            return result;
        }
        return DescribeConfigsResponse.ConfigSource.UNKNOWN;
    }

    public KafkaConfigSchema(Map<ConfigResource.Type, ConfigDef> configDefs, Map<String, List<ConfigSynonym>> logConfigSynonyms) {
        this.configDefs = configDefs;
        this.logConfigSynonyms = logConfigSynonyms;
    }

    public boolean isSplittable(ConfigResource.Type type, String key) {
        ConfigDef configDef = this.configDefs.get(type);
        if (configDef == null) {
            return false;
        }
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configDef.configKeys().get(key);
        if (configKey == null) {
            return false;
        }
        return configKey.type == ConfigDef.Type.LIST;
    }

    public boolean isSensitive(ConfigRecord record) {
        ConfigResource.Type type = ConfigResource.Type.forId((byte)record.resourceType());
        return this.isSensitive(type, record.name());
    }

    public boolean isSensitive(ConfigResource.Type type, String key) {
        ConfigDef configDef = this.configDefs.get(type);
        if (configDef == null) {
            return true;
        }
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configDef.configKeys().get(key);
        if (configKey == null) {
            return true;
        }
        return configKey.type.isSensitive();
    }

    public String getDefault(ConfigResource.Type type, String key) {
        ConfigDef configDef = this.configDefs.get(type);
        if (configDef == null) {
            return null;
        }
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configDef.configKeys().get(key);
        if (configKey == null || !configKey.hasDefault()) {
            return null;
        }
        return ConfigDef.convertToString((Object)configKey.defaultValue, (ConfigDef.Type)configKey.type);
    }

    public Map<String, ConfigEntry> resolveEffectiveTopicConfigs(Map<String, ?> staticNodeConfig, Map<String, ?> dynamicClusterConfigs, Map<String, ?> dynamicNodeConfigs, Map<String, ?> dynamicTopicConfigs) {
        ConfigDef configDef = this.configDefs.getOrDefault(ConfigResource.Type.TOPIC, EMPTY_CONFIG_DEF);
        HashMap<String, ConfigEntry> effectiveConfigs = new HashMap<String, ConfigEntry>();
        for (ConfigDef.ConfigKey configKey : configDef.configKeys().values()) {
            if (configKey.internalConfig && !dynamicTopicConfigs.containsKey(configKey.name)) continue;
            ConfigEntry entry = this.resolveEffectiveTopicConfig(configKey, staticNodeConfig, dynamicClusterConfigs, dynamicNodeConfigs, dynamicTopicConfigs);
            effectiveConfigs.put(entry.name(), entry);
        }
        return effectiveConfigs;
    }

    public ConfigEntry resolveEffectiveTopicConfig(String keyName, Map<String, ?> staticNodeConfig, Map<String, ?> dynamicClusterConfigs, Map<String, ?> dynamicNodeConfigs, Map<String, ?> dynamicTopicConfigs) {
        ConfigDef configDef = this.configDefs.getOrDefault(ConfigResource.Type.TOPIC, EMPTY_CONFIG_DEF);
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configDef.configKeys().get(keyName);
        return this.resolveEffectiveTopicConfig(configKey, staticNodeConfig, dynamicClusterConfigs, dynamicNodeConfigs, dynamicTopicConfigs);
    }

    public ConfigEntry resolveEffectiveTopicConfig(ConfigDef.ConfigKey configKey, Map<String, ?> staticNodeConfig, Map<String, ?> dynamicClusterConfigs, Map<String, ?> dynamicNodeConfigs, Map<String, ?> dynamicTopicConfigs) {
        if (dynamicTopicConfigs.containsKey(configKey.name)) {
            return this.toConfigEntry(configKey, dynamicTopicConfigs.get(configKey.name), ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG, Function.identity());
        }
        List synonyms = this.logConfigSynonyms.getOrDefault(configKey.name, List.of());
        for (ConfigSynonym synonym : synonyms) {
            if (!dynamicNodeConfigs.containsKey(synonym.name())) continue;
            return this.toConfigEntry(configKey, dynamicNodeConfigs.get(synonym.name()), ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG, synonym.converter());
        }
        for (ConfigSynonym synonym : synonyms) {
            if (!dynamicClusterConfigs.containsKey(synonym.name())) continue;
            return this.toConfigEntry(configKey, dynamicClusterConfigs.get(synonym.name()), ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, synonym.converter());
        }
        for (ConfigSynonym synonym : synonyms) {
            if (!staticNodeConfig.containsKey(synonym.name())) continue;
            return this.toConfigEntry(configKey, staticNodeConfig.get(synonym.name()), ConfigEntry.ConfigSource.STATIC_BROKER_CONFIG, synonym.converter());
        }
        return this.toConfigEntry(configKey, configKey.hasDefault() ? configKey.defaultValue : null, ConfigEntry.ConfigSource.DEFAULT_CONFIG, Function.identity());
    }

    public String getStaticOrDefaultConfig(String configName, Map<String, ?> staticNodeConfig) {
        ConfigDef configDef = this.configDefs.getOrDefault(ConfigResource.Type.BROKER, EMPTY_CONFIG_DEF);
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configDef.configKeys().get(configName);
        if (configKey == null) {
            return null;
        }
        List synonyms = this.logConfigSynonyms.getOrDefault(configKey.name, List.of());
        for (ConfigSynonym synonym : synonyms) {
            if (!staticNodeConfig.containsKey(synonym.name())) continue;
            return this.toConfigEntry(configKey, staticNodeConfig.get(synonym.name()), ConfigEntry.ConfigSource.STATIC_BROKER_CONFIG, synonym.converter()).value();
        }
        return this.toConfigEntry(configKey, configKey.hasDefault() ? configKey.defaultValue : null, ConfigEntry.ConfigSource.DEFAULT_CONFIG, Function.identity()).value();
    }

    private ConfigEntry toConfigEntry(ConfigDef.ConfigKey configKey, Object value, ConfigEntry.ConfigSource source, Function<String, String> converter) {
        String stringValue = null;
        if (value != null) {
            if (value instanceof String) {
                stringValue = (String)value;
            } else if (value instanceof Password) {
                stringValue = ((Password)value).value();
            } else {
                try {
                    stringValue = ConfigDef.convertToString((Object)value, (ConfigDef.Type)configKey.type);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to convert " + configKey.name + " to string.", e);
                }
            }
        }
        if (stringValue != null) {
            stringValue = converter.apply(stringValue);
        }
        return new ConfigEntry(configKey.name, stringValue, source, configKey.type().isSensitive(), false, List.of(), KafkaConfigSchema.translateConfigType(configKey.type()), configKey.documentation);
    }

    public int getStaticallyConfiguredMinInsyncReplicas(Map<String, ?> staticNodeConfig) {
        String minInsyncReplicasString = Objects.requireNonNull(this.getStaticOrDefaultConfig("min.insync.replicas", staticNodeConfig));
        return (Integer)ConfigDef.parseType((String)"min.insync.replicas", (Object)minInsyncReplicasString, (ConfigDef.Type)ConfigDef.Type.INT);
    }

    static {
        HashMap<ConfigEntry.ConfigSource, DescribeConfigsResponse.ConfigSource> map = new HashMap<ConfigEntry.ConfigSource, DescribeConfigsResponse.ConfigSource>();
        for (DescribeConfigsResponse.ConfigSource source : DescribeConfigsResponse.ConfigSource.values()) {
            map.put(source.source(), source);
        }
        TRANSLATE_CONFIG_SOURCE_MAP = Collections.unmodifiableMap(map);
    }
}

